#! /bin/bash

# Vraag de gebruiker om het aantal lucifers in te geven
echo "Gelieve het aantal lucifers in te geven:"
read LUCIFER_COUNT

# Zolang dat er nog lucifers zijn, spelen we een rondje
until [ $LUCIFER_COUNT -le 0 ]
do
    # Vraag aan de speler hoeveel lucifers weggenomen moeten worden
    echo "Er zijn $LUCIFER_COUNT lucifers."
    echo "Aantal weg te nemen lucifers (1, 2 of 3):"
    read NUM_TAKE_AWAY

    # controleer dat de gebruiker slechts 1, 2, of 3 lucifers heeft ingegeven
    case $NUM_TAKE_AWAY
    in
        1|2|3)
            # Aantal lucifers updaten
            LUCIFER_COUNT=$(($LUCIFER_COUNT-$NUM_TAKE_AWAY))
        ;;
        *)
            # Indien de input niet 1, 2, of 3 is dan geven we een foutmelding
            echo "Fout: geef een getal tussen 1 en 3!"
        ;;
    esac
done

echo "Einde van het spel"
