from Tkinter import *
from ATOM3Type import *
from ATOM3Text import ATOM3Text
class CDV3_ExtendClassCode_TYPEImpl (ATOM3Type):
   def __init__(self):
      ATOM3Type.__init__(self)
      self.code= None

   def createComponents(self):
      if not self.code:
         self.code=ATOM3Text('\n', 80,15 )

   def show(self, parent, parentWindowInfo=None):
      self.createComponents()
      ATOM3Type.show(self, parent, parentWindowInfo)
      self.containerFrame = Frame(parent)
      Label(self.containerFrame, text='code').grid(row=0,column=0,sticky=W)
      self.code.show(self.containerFrame, parentWindowInfo).grid(row=0,column=1,sticky=W)
      return self.containerFrame

   def toString(self):
      self.createComponents()
      return  self.code.toString()

   def getValue(self):
      self.createComponents()
      return (self.code.getValue(),)

   def setValue(self, value):
      self.createComponents()
      if value == None:
         self.code.setNone()
      else:
         self.code.setValue(value[0])

   def writeConstructor2File(self, file, indent, objName="at", depth = 0, generatingCode = 0):
      self.createComponents()
      file.write(indent+objName+'= CDV3_ExtendClassCode_TYPEImpl()\n')
      self.code.writeConstructor2File(file, indent, objName+'.code', depth, generatingCode)

   def writeValue2File(self, file, indent, objName="at", depth = 0, generatingCode = 0):
      self.createComponents()
      self.code.writeValue2File(file, indent, objName+'.code', depth, generatingCode)

   def clone(self):
     "Makes an exact copy of itself"
     cloneObject = CDV3_ExtendClassCode_TYPEImpl()
     if self.code: cloneObject.code = self.code.clone()
     return cloneObject

   def copy(self, other):
     "copies each field of the other object into its own state"
     self.parent = other.parent
     self.mode   = other.mode
     self.createComponents()
     self.code.copy(other.code)

   def destroy(self):
     "Destroys (i.e. updates) each field"
     if self.code: self.code.destroy()

   def invalid(self):
     "checks whether the entity is valid or not"
     inval = 0
     if self.code: inval = inval or self.code.invalid()
     return inval

