
from ATOM3 import ATOM3


import exporter_ClassDiagram 
import exporter_FileOutputer
import exporter_StateChartDiagram

reload(exporter_ClassDiagram)
reload(exporter_FileOutputer)
reload(exporter_StateChartDiagram)

def export(existingATOM3, model):
    
    classes = []
        
    for classEntity in model.listNodes['CD_Class3']:
        c = exporter_ClassDiagram.ClassDiagram(classEntity, existingATOM3)
        print "Class", c.name, "has been loaded in exporter."
        classes.append(c)
            
    for c in classes:
        exporter = CPPExporter(c)
        exporter.run()


class CPPExporter:

    def __init__(self, classDiagram):
        
        self.classDiagram = classDiagram
        if classDiagram.stateChart == 0:
            self.stateChart = None
        else:
            self.stateChart = classDiagram.stateChart 
        
    def run(self):
    
        self.fOut = exporter_FileOutputer.FileOutputer(self.classDiagram.name + ".cpp.txt")
        self.fHeader = exporter_FileOutputer.FileOutputer(self.classDiagram.name + ".h.txt")
        
        self.fHeader.write("#ifndef ATOM3_"+self.classDiagram.name+"__H")
        self.fHeader.write("#define ATOM3_"+self.classDiagram.name+"__H")
        self.fHeader.write()
        
        self.fHeader.write("#define INFINITY -1")
    
        self.fHeader.write("#include <list>")
        self.fHeader.write("using namespace std;")
        self.fHeader.write()
    
    
        self.fHeader.write("typedef list<myEvent> EventList;")
        self.fHeader.write()
        
        self.fOut.write()
        for code in self.classDiagram.preClassCode:
            self.writeCode(code)
        self.fOut.write()
            
        self.fHeader.write("class " + self.classDiagram.name + " {")
        self.fHeader.indent()
        self.fHeader.write()
        
        self.fHeader.write("public:")
        self.fHeader.indent()
        
        for attribute, type, initValue in self.classDiagram.attributes:
            if type == "Float" :
                self.fHeader.write("float " + attribute + " = " + initValue + ";")                            
            if type == "Integer" :
                self.fOut.write("int " + attribute + " = " + initValue + ";")
            if type == "Boolean" :
                if initValue == True:
                    self.fOut.write("bool " + attribute + " = true;")
                else:
                    self.fOut.write("bool " + attribute + " = false;")
                    
    
        self.fHeader.write()
    
        if self.stateChart != None:
            #initCodeForChart(self.classDiagram,self.classDiagram.self.stateChart,self.fOut)
            
            self.fHeader.write("enum myState {")
            self.fHeader.indent()
            
            for state in self.stateChart.basics:
                self.fHeader.write(state.name.getValue() + ",")
                            
            self.fHeader.write("NONE")
            self.fHeader.dedent()        
            self.fHeader.write("};")
            self.fHeader.write()
            
            self.fHeader.write("enum myEvent {")
            self.fHeader.indent()
            
            for event in self.stateChart.eventList:
                self.fHeader.write(event + ",")
                
            #for i in range(0, self.classDiagram.self.stateChart.numberTimeTransitions):
            #    self.fHeader.write("_"+str(i)+"after,")
                
            self.fHeader.write("NONE")
            self.fHeader.dedent()        
            self.fHeader.write("};")
            
            self.fHeader.write()
    
            self.fHeader.write("myState currentState;")        
            self.fHeader.write("EventList chartEventList;")        
            self.fHeader.write("long currentTime;")
            
            if self.stateChart.numberTimeTransitions != 0:
                self.fHeader.write("long timers[" + str(self.stateChart.numberTimeTransitions) + "];")
       
            self.fHeader.write("public void process( );")            
    
            self.fHeader.write()
    
            self.initCodeForChart(self.classDiagram.constructors)
            self.fOut.write("\n")            
        else:
            for parameters, body in self.classDiagram.constructors:
                self.writeMethod(self.classDiagram.name, parameters, "", body)
        
        for name, parameters, returnType, body in self.classDiagram.methods:
            self.writeMethod(name, parameters, returnType, body)  
                                
        for body in self.classDiagram.destructors:
            self.writeMethod("~" + self.classDiagram.name, "", "", body)  
            
        self.fHeader.dedent()         
        self.fHeader.dedent() 
        self.fHeader.write("};")
        self.fHeader.write()
        self.fHeader.write("#endif")
        self.fHeader.close()
            
        if self.stateChart != None:
            self.processChart()
            
        self.fOut.close()    
    
    def writeCode(self, body):
        
        lineByLine = body.split("\n")
        for line in lineByLine:
            self.fOut.write(line)
            
    def writeConstructor(self, name, parameters, body):
        
        self.fHeader.write( name + "( " + parameters + " );")
        
        self.fOut.write()    
        self.fOut.write("public " + self.classDiagram.name + "::" + name + "( " + parameters + " ) {\n")
        self.fOut.indent()
        self.fOut.write()
        self.fOut.write("timeb temp;")
        self.fOut.write("ftime(&temp);")
        self.fOut.write("currentTime = temp.time * 1000 + temp.millitm;")        
        self.fOut.write("currentState = \"" + self.stateChart.initState +"\";")                
        self.fOut.write()
        if self.stateChart.numberTimeTransitions != 0:
            for i in range(0, self.stateChart.numberTimeTransitions):
                self.fOut.write("timers["+str(i)+"] = INFINITY;")
            for timer, exp in self.stateChart.initTimers:
                self.fOut.write("timers["+timer+"] = " + exp + " + currentTime;")            
            self.fOut.write()
            
        for code in self.stateChart.initCode:
            self.writeCode(code)
        self.fOut.write()             
        self.writeCode(body)
        self.fOut.dedent()
        self.fOut.write("}")
    
    def writeMethod(self, name, parameters, returnType, body):
        
        self.fHeader.write( returnType + " " + name + "( " + parameters + " );")
        
        self.fOut.write("public " + returnType + " " + self.classDiagram.name 
                        + "::" + name + "( " + parameters + " ) {\n")
        self.fOut.indent()
        self.fOut.write()
        self.writeCode(body)
        self.fOut.write()
        self.fOut.dedent()
        self.fOut.write("}\n\n")
    
    def initCodeForChart(self, constructors):
        
        if constructors != []:
            for parameters, body in constructors:
                self.writeConstructor(self.classDiagram.name, parameters, body)    
        else:
            self.writeConstructor(self.classDiagram.name, "", "")  
            
        
    def processChart(self):
        
        self.fOut.write("public void " + self.classDiagram.name + "::process() {\n")
        self.fOut.indent()
        self.fOut.write("timeb temp;")
        self.fOut.write("ftime(&temp);")
        self.fOut.write("currentTime = temp.time * 1000 + temp.millitm;")
        if self.stateChart.numberTimeTransitions != 0:
            self.fOut.write("// Lets check the timers")
            self.fOut.write("for (int i = 0; i < " + str(self.stateChart.numberTimeTransitions) + "; i++) {")
            self.fOut.indent()
            self.fOut.write("if ((timers[i] != INFINITY) && (timers[i] < currentTime)) {")
            self.fOut.indent()
            self.fOut.write("chartEventList.pushback(\"_\" + i + \"after\");")
            self.fOut.dedent()
            self.fOut.write("}")
            self.fOut.dedent()
            self.fOut.write("}")
    
        self.fOut.write()        
        self.fOut.write("while(chartEventList.size() != 0) {")
        self.fOut.indent()
        self.fOut.write()
        self.fOut.write("myEvent event = chartEventList.front();")
        self.fOut.write("chartEventList.pop_front();")
        self.fOut.write()
        for state in self.stateChart.basics:
            # If the state has transition
            if self.stateChart.transitionData[state] != [] :            
                self.fOut.write("if ( currentState == " + state.name.getValue() + " ) {\n")
                self.fOut.indent()
                self.processTransition(state)
                self.fOut.dedent()
                self.fOut.write("}")
        
        self.fOut.dedent()
        self.fOut.write("}")
            
        self.fOut.dedent()
        self.fOut.write("}\n")
        
    def processTransition(self, state):
        
        transitions = self.stateChart.transitionData[state]
        
        for transition in transitions:
                                        
            if "event" in transition:
                condition = "( event.equals(\"" + transition["event"] + "\") )"
            else:
                condition = ""
            
            if "guard" in transition:
                if transition["guard"] == "1":
                    transition["guard"] = "true"
                        
                if condition == "":
                    condition = transition["guard"]
                else :
                    condition += " && " + transition["guard"]
            
            self.fOut.write()
            self.fOut.write("if ( " + condition + " ) {")
            self.fOut.indent()
            
            for key, value in transition["timersToReset"]:
                self.fOut.write("timers[" + key + "] = INFINITY;")
                
            for key, value in transition["historyToSet"]:
                self.fOut.write("history[" + key + "] = " + value)
                
            for key, value in transition["timersToSet"]:
                self.fOut.write("timers[" + key + "] = " + value + " + currentTime;")
            
            for code in transition["exitCode"]:
                self.writeCode(code)
                
            for code in transition["triggerCode"]:
                self.writeCode(code)
            
            for code in transition["enterCode"]:
                self.writeCode(code)
            
            
            self.fOut.write("state = \"" + transition["destinationState"] + "\";")
            
            self.fOut.dedent()
            self.fOut.write("}")
            self.fOut.write()
            