from Tkinter import *
from ATOM3Type import *
from ATOM3Text import ATOM3Text
from ATOM3String import ATOM3String
class CDV3_Constructor_TYPEImpl (ATOM3Type):
   def __init__(self):
      ATOM3Type.__init__(self)
      self.body= None
      self.parameters= None

   def createComponents(self):
      if not self.body:
         self.body=ATOM3Text('\n', 80,15 )
      if not self.parameters:
         self.parameters=ATOM3String('', 20)

   def show(self, parent, parentWindowInfo=None):
      self.createComponents()
      ATOM3Type.show(self, parent, parentWindowInfo)
      self.containerFrame = Frame(parent)
      Label(self.containerFrame, text='body').grid(row=0,column=0,sticky=W)
      self.body.show(self.containerFrame, parentWindowInfo).grid(row=0,column=1,sticky=W)
      Label(self.containerFrame, text='parameters').grid(row=1,column=0,sticky=W)
      self.parameters.show(self.containerFrame, parentWindowInfo).grid(row=1,column=1,sticky=W)
      return self.containerFrame

   def toString(self):
      self.createComponents()
      return  self.body.toString()+' '+ self.parameters.toString()

   def getValue(self):
      self.createComponents()
      return (self.body.getValue(),self.parameters.getValue(),)

   def setValue(self, value):
      self.createComponents()
      if value == None:
         self.body.setNone()
         self.parameters.setNone()
      else:
         self.body.setValue(value[0])
         self.parameters.setValue(value[1])

   def writeConstructor2File(self, file, indent, objName="at", depth = 0, generatingCode = 0):
      self.createComponents()
      file.write(indent+objName+'= CDV3_Constructor_TYPEImpl()\n')
      self.body.writeConstructor2File(file, indent, objName+'.body', depth, generatingCode)
      self.parameters.writeConstructor2File(file, indent, objName+'.parameters', depth, generatingCode)

   def writeValue2File(self, file, indent, objName="at", depth = 0, generatingCode = 0):
      self.createComponents()
      self.body.writeValue2File(file, indent, objName+'.body', depth, generatingCode)
      self.parameters.writeValue2File(file, indent, objName+'.parameters', depth, generatingCode)

   def clone(self):
     "Makes an exact copy of itself"
     cloneObject = CDV3_Constructor_TYPEImpl()
     if self.body: cloneObject.body = self.body.clone()
     if self.parameters: cloneObject.parameters = self.parameters.clone()
     return cloneObject

   def copy(self, other):
     "copies each field of the other object into its own state"
     self.parent = other.parent
     self.mode   = other.mode
     self.createComponents()
     self.body.copy(other.body)
     self.parameters.copy(other.parameters)

   def destroy(self):
     "Destroys (i.e. updates) each field"
     if self.body: self.body.destroy()
     if self.parameters: self.parameters.destroy()

   def invalid(self):
     "checks whether the entity is valid or not"
     inval = 0
     if self.body: inval = inval or self.body.invalid()
     if self.parameters: inval = inval or self.parameters.invalid()
     return inval

