from Tkinter import *
from ATOM3Type import *
from ATOM3String import ATOM3String
from ATOM3Text import ATOM3Text
class CDV3_GetMethod_TYPEImpl (ATOM3Type):
   def __init__(self):
      ATOM3Type.__init__(self)
      self.returnType= None
      self.parameters= None
      self.body= None

   def createComponents(self):
      if not self.returnType:
         self.returnType=ATOM3String('', 20)
      if not self.parameters:
         self.parameters=ATOM3String('', 20)
      if not self.body:
         self.body=ATOM3Text('\n', 80,15 )

   def show(self, parent, parentWindowInfo=None):
      self.createComponents()
      ATOM3Type.show(self, parent, parentWindowInfo)
      self.containerFrame = Frame(parent)
      Label(self.containerFrame, text='returnType').grid(row=0,column=0,sticky=W)
      self.returnType.show(self.containerFrame, parentWindowInfo).grid(row=0,column=1,sticky=W)
      Label(self.containerFrame, text='parameters').grid(row=1,column=0,sticky=W)
      self.parameters.show(self.containerFrame, parentWindowInfo).grid(row=1,column=1,sticky=W)
      Label(self.containerFrame, text='body').grid(row=2,column=0,sticky=W)
      self.body.show(self.containerFrame, parentWindowInfo).grid(row=2,column=1,sticky=W)
      return self.containerFrame

   def toString(self):
      self.createComponents()
      return  self.returnType.toString()+' '+ self.parameters.toString()+' '+ self.body.toString()

   def getValue(self):
      self.createComponents()
      return (self.returnType.getValue(),self.parameters.getValue(),self.body.getValue(),)

   def setValue(self, value):
      self.createComponents()
      if value == None:
         self.returnType.setNone()
         self.parameters.setNone()
         self.body.setNone()
      else:
         self.returnType.setValue(value[0])
         self.parameters.setValue(value[1])
         self.body.setValue(value[2])

   def writeConstructor2File(self, file, indent, objName="at", depth = 0, generatingCode = 0):
      self.createComponents()
      file.write(indent+objName+'= CDV3_GetMethod_TYPEImpl()\n')
      self.returnType.writeConstructor2File(file, indent, objName+'.returnType', depth, generatingCode)
      self.parameters.writeConstructor2File(file, indent, objName+'.parameters', depth, generatingCode)
      self.body.writeConstructor2File(file, indent, objName+'.body', depth, generatingCode)

   def writeValue2File(self, file, indent, objName="at", depth = 0, generatingCode = 0):
      self.createComponents()
      self.returnType.writeValue2File(file, indent, objName+'.returnType', depth, generatingCode)
      self.parameters.writeValue2File(file, indent, objName+'.parameters', depth, generatingCode)
      self.body.writeValue2File(file, indent, objName+'.body', depth, generatingCode)

   def clone(self):
     "Makes an exact copy of itself"
     cloneObject = CDV3_GetMethod_TYPEImpl()
     if self.returnType: cloneObject.returnType = self.returnType.clone()
     if self.parameters: cloneObject.parameters = self.parameters.clone()
     if self.body: cloneObject.body = self.body.clone()
     return cloneObject

   def copy(self, other):
     "copies each field of the other object into its own state"
     self.parent = other.parent
     self.mode   = other.mode
     self.createComponents()
     self.returnType.copy(other.returnType)
     self.parameters.copy(other.parameters)
     self.body.copy(other.body)

   def destroy(self):
     "Destroys (i.e. updates) each field"
     if self.returnType: self.returnType.destroy()
     if self.parameters: self.parameters.destroy()
     if self.body: self.body.destroy()

   def invalid(self):
     "checks whether the entity is valid or not"
     inval = 0
     if self.returnType: inval = inval or self.returnType.invalid()
     if self.parameters: inval = inval or self.parameters.invalid()
     if self.body: inval = inval or self.body.invalid()
     return inval

