from Tkinter import *
from ATOM3Type import *
from ATOM3String import ATOM3String
class CDV3_ObjectReference_TYPEImpl (ATOM3Type):
   def __init__(self):
      ATOM3Type.__init__(self)
      self.objectType= None

   def createComponents(self):
      if not self.objectType:
         self.objectType=ATOM3String('', 20)

   def show(self, parent, parentWindowInfo=None):
      self.createComponents()
      ATOM3Type.show(self, parent, parentWindowInfo)
      self.containerFrame = Frame(parent)
      Label(self.containerFrame, text='objectType').grid(row=0,column=0,sticky=W)
      self.objectType.show(self.containerFrame, parentWindowInfo).grid(row=0,column=1,sticky=W)
      return self.containerFrame

   def toString(self):
      self.createComponents()
      return  self.objectType.toString()

   def getValue(self):
      self.createComponents()
      return (self.objectType.getValue(),)

   def setValue(self, value):
      self.createComponents()
      if value == None:
         self.objectType.setNone()
      else:
         self.objectType.setValue(value[0])

   def writeConstructor2File(self, file, indent, objName="at", depth = 0, generatingCode = 0):
      self.createComponents()
      file.write(indent+objName+'= CDV3_ObjectReference_TYPEImpl()\n')
      self.objectType.writeConstructor2File(file, indent, objName+'.objectType', depth, generatingCode)

   def writeValue2File(self, file, indent, objName="at", depth = 0, generatingCode = 0):
      self.createComponents()
      self.objectType.writeValue2File(file, indent, objName+'.objectType', depth, generatingCode)

   def clone(self):
     "Makes an exact copy of itself"
     cloneObject = CDV3_ObjectReference_TYPEImpl()
     if self.objectType: cloneObject.objectType = self.objectType.clone()
     return cloneObject

   def copy(self, other):
     "copies each field of the other object into its own state"
     self.parent = other.parent
     self.mode   = other.mode
     self.createComponents()
     self.objectType.copy(other.objectType)

   def destroy(self):
     "Destroys (i.e. updates) each field"
     if self.objectType: self.objectType.destroy()

   def invalid(self):
     "checks whether the entity is valid or not"
     inval = 0
     if self.objectType: inval = inval or self.objectType.invalid()
     return inval

