# The gen_cpp routine is invoked from the custom DCharts UI. The routine generates 
# C++ code for a statechart and is saved as atom3\ai_default.cpp.

# Half of this code has been contributed by David Meunier for an assignment effort
# in Comp522 Modelling and Simulation


from re import match

# Since triggers for after events aren't "named" we identify them by "_*After" where
# * is a unique number. We use the dictionary toevent to map model in_connections_
# to trigger names.

toevent = {}    # mapping from hyperedge to trigger name
                # toevent[h] is equivalent to '+h.trigger.name.getValue()+'
                # 
                
afterevents = {} # mapping from hyperedge to name of the generated event 
                 # corresponding to a timeout.

tostate = {}    # mapping from a basic state to its name
                # tostate[s] is equivalent to '+s.name.getValue()+'


basics = []
historys = []
composites = []

f=open('gen_py.txt', 'w')   # output file
indent=0

# Returns the first top level default node found, can be Composite or Basic.
# Raises an error if no such node is found.
def getInitialState(model):
    #print "\ngetting initial state,"
    for state in basics + composites:
        #print state.is_default.getValue()
        if state.is_default.getValue()[1]==True:
            for link in state.in_connections_:
                if link.getClass()=="contains":
                    break
            else:
                    return state
    raise "No initial state found!"

# returns a list representing the containment hierarchy of node.
# node is always the first element, and its outermost composite is the last.
def getOuterNodes(node):
    outernodes=[node]
    for link in node.in_connections_:
        if link.getClass()=="contains":
            outernodes = outernodes + getOuterNodes(link.in_connections_[0])
            break
    return outernodes

# Returns a list representing the containment hierarchy of the default
# state of node, up to and including node itself. If node is Basic or History
# then it is the only element of the returned list. Otherwise, the default 
# state is always the first element, and node is the last. An error is raised
# if no default History or Basic state is found.
def getDefaultPath(node):
    #print "\ngetting default path for " + node.name.getValue() +","
    defaultpath=[node]
    if (node.getClass()=='Basic' or node.getClass()=='History'):
        return defaultpath
    for link in node.out_connections_:
        if link.getClass()=="contains" and \
           link.out_connections_[0].is_default.getValue()[1]==True:
            defaultpath=getDefaultPath(link.out_connections_[0]) + defaultpath
            break
    else:
        raise node.name.getValue() + " contains no default state!"
    #print "result: ",defaultpath
    return defaultpath

# Returns an optimized list of all hyperedges coming out of 'node'.
# If a hyperedge with no trigger or guard is found then it alone is returned.
# Otherwise the returned list is ordered by hyperedges having guards only,
# followed by the rest of the hyperedges. This is done to facilitate the
# sequence of transitions executed in a single step (loop iteration).
def getHyperedgesOutOf(node):
    onlyguards = []
    withtriggers = []
    for link in node.out_connections_:
        if link.getClass()=="Hyperedge":
            if isUCTransition(link):
                if not hasGuard(link):
                    return [link]
                else:
                    onlyguards.append(link)
            else:
                withtriggers.append(link)
    return onlyguards+withtriggers

# given a model hyperedge determine whether it is an after edge
def isAfter(edge):
    value = edge.trigger.getValue()
    if value[0:6] == "AFTER(" and value[-1] == ")":
      return True
    return False

# given a model hyperedge extract the after expression
def getAfterExp(afteredge):
    value = afteredge.trigger.getValue()
    return value[6:-1]

# returns a list of after transitions/edges
def getAfterEdges(state):
    afters = []
    edges = getHyperedgesOutOf(state)
    for edge in edges:
      if isAfter(edge):
        afters.append(edge)
    return afters

# returns true iff edge is an unconditional transition (i.e. no trigger)
def isUCTransition(edge):
    return not edge.trigger.getValue()

def hasGuard(edge):
    return not (not edge.guard.getValue()) #yea... i know :(

#------------------------------------------------------------------------------
def getTransitionPath(startnode, endnode, currentState):
    #first get the ancestors of each node
    startAncestors=getOuterNodes(startnode)
    endAncestors=getOuterNodes(endnode)
    #now find the scope of the transition (lowest common proper ancestor)
    LCA=None
    while not(startAncestors[-1]==startnode or
              endAncestors[-1]==endnode or
              startAncestors[-1]!=endAncestors[-1]):
        LCA=startAncestors.pop()
        endAncestors.pop()
    #the states to be exited are all proper descendants of the scope in which
    #currentState resides
    #the states to be entered are all the proper descendants of the scope in
    #which the final basic state resides
    enterpath=getDefaultPath(endnode)+getOuterNodes(endnode)[1:]
    exitpath=getOuterNodes(currentState)
    if LCA:
        exitpath=exitpath[:exitpath.index(LCA)]    ## last element (LCA) is
        enterpath=enterpath[:enterpath.index(LCA)] ## not included in slice
    exitpath.reverse()
    return (exitpath, enterpath)
#------------------------------------------------------------------------------

# Returns all basic states in the scope of the history connector H.
def historyScope(H):
    s=[]
    for inlink in H.in_connections_:
        if inlink.getClass()=="contains":
            parent=inlink.in_connections_[0]
            print "\n\n\nThe parent is",parent
            break
    else:
        return basics #toplevel history node

    def getBasics(C):
        b=[]
        for outlink in C.out_connections_:
            if outlink.getClass()=='contains':
                child=outlink.out_connections_[0]
                if child.getClass()=='Basic':
                    b.append(outlink.out_connections_[0])
                elif child.getClass()=='Composite':
                    b.extend(getBasics(child))
        return b

    return getBasics(parent)


# Scans all lines of text and converts any event generation command (ie GEN(e))
# to the apropriate code. Also prefixes each line with 4*(indent) spaces. The
# resulting text is written to f, a file that has been opened for writing.
def toFile(text, indent, f):
    if text:
	code=""
	s=text.splitlines()
	for l in s:
	    if l.startswith('GEN('):
		event=l[4:-1]
		l="EVENTQ.append('"+event+"')"
			
            code=code+ 4*indent*" " + l + "\n"
	f.write(code)

def getName(s):
      if type(s)==type([]):
        return map(getName,s)
      return s.name.getValue()

def getNameStr(s):
      if type(s)==type([]):
        return map(getName,s)
      return "'"+s.name.getValue()+"'"

# Returns a list of History connectors whose scope contains 'state'. That
# is, the list of History connectors that must be updated when the system
# moves out of 'state'.
def getHistoryConnectors(state):
  HC = []
  for h in historys:
    for inlink in h.in_connections_:
      if inlink.getClass()=="contains":
        break
    else:
        HC.append(h) #toplevel history node

  ancestors = getOuterNodes(state)
  while len(ancestors)>1:
    ancestor = ancestors.pop()
    for outlink in ancestor.out_connections_:
      if outlink.getClass()=="contains" and \
         outlink.out_connections_[0].getClass()=="History":
        HC.append(outlink.out_connections_[0])

  return HC

def getStateChart(classEntity):
    for a in classEntity.attributes.getValue():
        if a.seltype=="CDV3_DChart_TYPE": return a.initialValue.getValue()
    return None


def gen_cpp(existingATOM3, CDmodel):

    for classEntity in model.listNodes['CD_Class3']:
#        toFile("class "+classEntity.name.getValue()+":", indent, f)
        indent+=1

        print 'atom3i', existingATOM3.__class__.__name__

        # Quick and dirty: Create a new window then hide it
        temporaryWindow = Toplevel(existingATOM3.parent)
        temporaryWindow.withdraw()

        atom3i = ATOM3.ATOM3(temporaryWindow, "DCharts", 0, 1)

        atom3i.open(fileName=getStateChart(classEntity))

        for nodeType in atom3i.ASGroot.listNodes.keys():
           for node in atom3i.ASGroot.listNodes[nodeType]:
               print 'This is a node if no typos were made in here:', node.__class__.__name__
               
        # Clean-up! 
        temporaryWindow.destroy()

    
"""
    global indent,tostate,basics,historys,composites
   
    basics = model.listNodes['Basic']
    composites = model.listNodes['Composite']
    historys = model.listNodes['History']

    # build toevent, tostate and afterevents dicts to help with translation
    edges = model.listNodes["Hyperedge"]
    i_after = 0
    for edge in edges:
        key = edge
        if edge.trigger.getValue():
            value = "'"+edge.trigger.getValue()+"'"
        else:
            value = ''
        if isAfter(edge):
            value = "'_" + str(i_after) + "after'"
            i_after = i_after + 1
            afterevents[key] = str(i_after)
        toevent[key] = value

    
    states = basics + model.listNodes["Composite"] + model.listNodes["History"]
    tostate = dict(zip(states, getNameStr(states)))
    laststate = {}.fromkeys(getName(model.listNodes['History']))
    
    toFile("from time import sleep", indent, f)
    toFile("from time import time", indent, f)
    toFile("from infinity import *\n", indent, f)
    # Initialize all timers to infinity, event queue to empty, and timer.
    if i_after:
        timers = (i_after-1) * 'INFINITY, ' + 'INFINITY'
        toFile("\nTIMERS=["+timers+"]", indent, f)
    toFile("EVENTQ=[]", indent, f)
    toFile("CUR_TIME=time()", indent, f)
    toFile('LASTSTATE = ' + str(laststate), indent, f)
                            
    # enter the initial default state of the statechart
    initPath = getDefaultPath(getInitialState(model))
    initialState = initPath[0]
    while initPath:
        writePathCode([], [], initPath)

    toFile("\nCURRENTSTATE="+tostate[initialState], indent, f)

    toFile("\nwhile(True):", indent, f)
    indent+=1
    toFile("\nCUR_TIME=time()", indent, f)
    toFile("\nfor i in range(len(TIMERS)):", indent, f)
    toFile("if CUR_TIME>=TIMERS[i]: EVENTQ.append('_' + str(i) + 'after')", \
           indent+1, f)
    toFile("\nwhile(EVENTQ):", indent, f)
    indent+=1
    
    toFile("\nEVENT=EVENTQ.pop()", indent, f)
    basicStates=model.listNodes["Basic"]
    branch='if'
    for state in basicStates:
        toFile("\n"+branch+" CURRENTSTATE=="+tostate[state]+":", indent, f)
        indent+=1
        writeTransitionCodeFrom(state)
        indent-=1
        branch='elif'
    indent-=1
    toFile("sleep(0.1)",indent,f)

    f.close()

# writes either enter or exit action code for a given state
# also will set or reset timers for after events
##def writeStateCode(state, enter):
##    if enter:
##      enterCode = state.enter_action.getValue()
##      if enterCode: toFile(enterCode, indent, f)
##      enterafters = getAfterEdges(state)
##      for after in enterafters:
##        toFile("TIMERS["+afterevents[after]+"] = CUR_TIME + "+getAfterExp(after), indent, f)
##    else:
##      exitCode = state.exit_action.getValue()
##      if exitCode: toFile(exitCode, indent, f)
##      exitafters = getAfterEdges(state)
##      for after in exitafters:
##        toFile("TIMERS[" + afterevents[after] + "] = INFINITY", indent, f)
##
#####################################################
# Written by David Meunier, modified by Bill Cheung #
#####################################################
# This routine writes out all the action code that corresponds to the transitions of
# a particular state.  David's version was changed to use a switch on events rather
# than if statements of expressions.

def writePathCode(leaving, travelling, arriving):
        while leaving:
            left = leaving.pop()
            exitcode=left.exit_action.getValue()
            if exitcode: toFile(exitcode, indent, f)
            for ae in getAfterEdges(left):
                toFile("TIMERS[" + afterevents[ae] + "] = INFINITY", indent, f)
            if left.getClass()=='Basic':
                for hc in getHistoryConnectors(left):
                    toFile("LASTSTATE["+getNameStr(hc)+"] = "+getNameStr(left),
                           indent,f)
        while travelling:
            triggercode = travelling.pop().action.getValue()
            if triggercode: toFile(triggercode, indent, f)

        while arriving:
            arrived = arriving.pop()
            print len(arriving)
            entercode = arrived.enter_action.getValue()
            if entercode: toFile(entercode, indent, f)
            for ae in getAfterEdges(arrived):
                toFile("TIMERS["+afterevents[ae]+"] = CUR_TIME + " + \
                       getAfterExp(ae), indent, f)
                
        toFile("\nCURRENTSTATE=" + tostate[arrived], indent, f)
        for out in getHyperedgesOutOf(arrived):
            if isUCTransition(out):
                toFile("continue", indent, f)
                break

def writeTransitionCodeFrom(state):
    global indent
    
    # -------------------------------------------------------------
##    def writePathActions(source, target, state, triggerAction):
##        (exitpath,enterpath)=getTransitionPath(source,target,state)
##        while exitpath:
##            writeStateCode(exitpath.pop(), False)
##        if triggerAction.strip(): toFile(triggerAction, indent, f)     
##        while enterpath:
##            enterstate = enterpath.pop()
##            writeStateCode(enterstate, True)
##        toFile("\nCURRENTSTATE=" + tostate[enterstate], indent, f)
    # -------------------------------------------------------------
     # -------------------------------------------------------------
     
    containers = getOuterNodes(state)
    containers.reverse()    #reverse so pop() returns innermost container
    branch='if '
    nada=True
    while containers:
        c = containers.pop()
        transitions = getHyperedgesOutOf(c)
        if transitions:toFile("## Transitions out of "+tostate[c], indent, f)
        while transitions:

            nada=False

            t = transitions.pop()

            if toevent[t]:   #does the transition have a trigger?
              if t.guard.getValue():   #does it have a guard?
                condition="(EVENT=="+toevent[t]+" and "+t.guard.getValue()+"):"
              else:
                condition="(EVENT=="+toevent[t]+"):"
            else:
              if t.guard.getValue():   #does it have a guard?
                condition="("+t.guard.getValue()+"):"
              else:
                condition="(True):"
                
            toFile(branch + condition+ "\t##"+t.name.getValue(),indent,f)
            branch='elif '
            indent+=1

            target = t.out_connections_[0]
            (exits, enters) = getTransitionPath(c,target,state)
            
            if enters[0].getClass()!='History':
                writePathCode(exits, [t], enters)
            # if trasition leads to a history connector, we must consider all
            # possible states it can reference.
            else:
                hc = enters[0]
                # if the current state is in the scope of the history connector
                # the transition resolves back to the current state since upon
                # leaving the current sate, the history connector will be
                # updated to reference the current state.
                if state in historyScope(hc):
                    (exits, enters) = getTransitionPath(c, state, state)
                    writePathCode(exits, [t], enters)
                else:
                    # first consider that the history connector is not yet
                    # referencing any state. Consider any NON-TRIGGERED hyper-
                    # edge out of it or else resolve to the default state.
                    H=tostate[hc]
                    toFile("if LASTSTATE['" + H + "']==None:", indent, f)
                    indent+=1
                    skipdef = False
                    b='if '
                    for link in getHyperedgesOutOf(hc):
                        if isUCTransition(link):
                            if hasGuard(link):
                                cond = '(' + link.guard.getValue() + '):'
                            else:
                                cond = '(True):'
                                skipdef = True
                            toFile(b+cond,indent,f)
                            indent+=1
                            b='elif '
                            ht=link
                            ref=link.out_connections_[0]
                            (exits, enters) = getTransitionPath(c, ref, state)
                            writePathCode(exits,[t,ht],enters)
                            indent-=1
                    
                    if not skipdef:
                        # send to default state
                        parent = getOuterNodes(hc)[1]
                        ref=getDefaultPath(parent)[0]
                        ### target garanteed to be contained at least once or
                        ### else current state would have been caught in
                        ### historyScope(hc) above.
                        if ref!=hc:
                            toFile("else:", indent, f)
                            indent+=1
                            (exits, enters) = getTransitionPath(c, ref, state)
                            writePathCode(exits, [t], enters)
                            indent-=1
                        else:
                            print "WARNING - "+getName(hc)+" as Default State \
of " + getName(parent) + " may cause unwanted behaviour."
                    indent-=1        
                    # now consider all the possible states the history
                    # connector can reference.
                    for ref in historyScope(hc):
                        toFile('elif LASTSTATE['+H+']=='+tostate[ref],indent,f)
                        indent+=1
                        (exits, enters) = getTransitionPath(c, ref, state)
                        writePathCode(exits, [t], enters)
                        indent-=1
            indent-=1
    if nada: toFile("pass", indent, f)

# almost identical to writeTransitionCodeFrom except we have a few modifications for
# unconditional transitions. The main difference is that there is no switching on events.
# guards are simply checked if they are true or not.
def writeUCTransitionCodeFrom(state, indent, f):

    containers = getOuterNodes(state)
    while containers:
        c = containers.pop()
        transitions = getHyperedgesOutOf(c)
        print_comment = True
        iforelseif = "if"
        while transitions:
            t = transitions.pop()

            # only write code for unconditional transitions
            if isUCTransition(t):
              if print_comment == False:
                toFile( "// transitions out of " + c.name.getValue(), indent, f)
                print_comment = True

              guard = t.guard.getValue()
              if not guard:
                guard = "true"

              # use if else statements
              toFile(iforelseif + " (" + guard + ") {", indent, f)
              iforelseif = "else if"
              indent = indent + 1
            
              startnode = c
              endnode = t.out_connections_[0]
              (exitpath, enterpath) = getTransitionPath(startnode, endnode, state)

              triggerAction = t.action.getValue()
              if triggerAction: toFile( triggerAction, indent, f)

              while exitpath:
                writeStateCode(exitpath.pop(), False, indent, f)
                
              while enterpath:
                enterstate = enterpath.pop()
                writeStateCode(enterstate, True, indent, f)

              toFile("CURRENTSTATE = " + enterstate.name.getValue() + ";", indent, f)

              # if a state has been entered unconditionally we need to check the new state
              # unconditional events
              toFile("CHECK_UCEVENT = true;", indent, f)
              
              indent = indent - 1
              toFile("}", indent, f)
"""
