from FileWriter_java import *

fw = None

basics = []
historys = []
composites = []
afterevents = {}
triggeredOps = []
toevent = {}

# Sets the module's file writer
def setFileWriter(fwObj):
    global fw
    fw = fwObj


# Tells the module what names are bound to triggered operations
# 'ops' is expected not to contain any whitespaces
def setTriggeredOperations(ops):
    global triggeredOps
    triggeredOps = ops


# Gives the module information on the statechart by listing its basic,
# composite and history states as well as mapping triggers to names making the
# appropriate conversion from AFTER() triggers to event names.
def load(model):
    global basics, historys, composites, afterevents, toevent
    basics = model.listNodes['Basic']
    composites = model.listNodes['Composite']
    historys = model.listNodes['History']
    afterevents = {}
    toevent = {}
    edges = model.listNodes["Hyperedge"]
    i_after = 0
    for edge in edges:
        if edge.trigger.getValue():
            if isAfter(edge):
                value = "'_" + str(i_after) + "after'"
                afterevents[edge] = str(i_after)
                i_after+=1
            else:
                value = "'"+edge.trigger.getValue()+"'"
        else:
            value = ''
        toevent[edge] = value


# Returns the name of s or a list of names of elements of s.
def getName(s):
      if type(s)==type([]):
        return map(getName,s)
      return s.name.getValue()


# Same as getNames(s) but the strings returned are enclosed in single quotes
def getNameStr(s):
      if type(s)==type([]):
        return map(getNameStr,s)
      return s.name.getValue()


# Returns true iff edge is an unconditional transition (i.e. no trigger)
def isUCTransition(edge):
    return not edge.trigger.getValue()


# Returns true if the edge has a guard
def hasGuard(edge):
    return not (not edge.guard.getValue())


# Returns a list of edges out of state which are triggred by AFTER()
def getAfterEdges(state):
    afters = []
    edges = getEventEdgesOutOf(state)
    for edge in edges:
      if isAfter(edge):
        afters.append(edge)
    return afters


# Given a hyperedge determines whether it is triggered by AFTER()
def isAfter(edge):
    value = edge.trigger.getValue().strip()
    if value[0:6] == "AFTER(" and value[-1] == ")":
      return True
    return False


# Given a hyperedge returns the timeout value from an AFTER() trigger
def getAfterExp(afteredge):
    value = afteredge.trigger.getValue().strip()
    return value[6:-1]


# Returns an optimized list of all hyperedges coming out of 'node'.
# The list does not include hyperedges whose trigers are operations in the
# triggeredOps list.
# If a hyperedge with no trigger or guard is found then it alone is returned.
# Otherwise the returned list is ordered by hyperedges having guards only,
# followed by the rest of the hyperedges. This is done to facilitate the
# sequence of transitions executed in a single step (loop iteration).
def getEventEdgesOutOf(node):
    onlyguards = []
    withtriggers = []
    for link in node.out_connections_:
        if link.getClass()=="Hyperedge":
            if isUCTransition(link):
                if not hasGuard(link):
                    return [link]
                else:
                    onlyguards.append(link)
            elif not getEventParams(link.trigger.getValue())[0]in triggeredOps:
                withtriggers.append(link)
    return onlyguards+withtriggers


# Returns a list of edges coming out of 'node' that are triggered by the
# operation 'op'. If there exists such an edge that does not have a guard, then
# one of them is the only element of the list that is returned. This is done
# to implement the sematics that an edge with no guard can always be taken,
# thereby making another edge useless to consider.
def getOperationEdgeOutsOf(node, opname):
    withguards = []
    for link in node.out_connections_:
        if link.getClass()=="Hyperedge" and \
           nowhites(link.trigger.getValue()).startswith(opname):
            if hasGuard(link):                
                withguards.append(link)
            else:
                return [link]
                
    return withguards


# Returns all basic states in the scope of the history connector H.
def historyScope(H):
    s=[]
    for inlink in H.in_connections_:
        if inlink.getClass()=="contains":
            parent=inlink.in_connections_[0]
            print "\n\n\nThe parent is",parent
            break
    else:
        return basics #toplevel history node

    def getBasics(C):
        b=[]
        for outlink in C.out_connections_:
            if outlink.getClass()=='contains':
                child=outlink.out_connections_[0]
                if child.getClass()=='Basic':
                    b.append(outlink.out_connections_[0])
                elif child.getClass()=='Composite':
                    b.extend(getBasics(child))
        return b

    return getBasics(parent)


# Returns a list of History connectors whose scope contains 'state'. That
# is, the list of History connectors that must be updated when the system
# moves out of 'state'.
def getHistoryConnectors(state):
  HC = []
  for h in historys:
    for inlink in h.in_connections_:
      if inlink.getClass()=="contains":
        break
    else:
        HC.append(h) #toplevel history node

  ancestors = getOuterNodes(state)
  while len(ancestors)>1:
    ancestor = ancestors.pop()
    for outlink in ancestor.out_connections_:
      if outlink.getClass()=="contains" and \
         outlink.out_connections_[0].getClass()=="History":
        HC.append(outlink.out_connections_[0])

  return HC


# returns a list representing the containment hierarchy of node.
# node is always the first element, and its outermost composite is the last.
def getOuterNodes(node):
    outernodes=[node]
    for link in node.in_connections_:
        if link.getClass()=="contains":
            outernodes = outernodes + getOuterNodes(link.in_connections_[0])
            break
    return outernodes

   
# Returns the first top level default node found, can be Composite or Basic.
# Raises an error if no such node is found.
def getInitialState():
    #print "\ngetting initial state,"
    for state in basics + composites:
        #print state.is_default.getValue()
        if state.is_default.getValue()[1]==True:
            for link in state.in_connections_:
                if link.getClass()=="contains":
                    break
            else:
                    return state
    raise "No initial state found!"


# Returns a list representing the containment hierarchy of the default
# state of node, up to and including node itself. If node is Basic or History
# then it is the only element of the returned list. Otherwise, the default 
# state is always the first element, and node is the last. An error is raised
# if no default History or Basic state is found.
def getDefaultPath(node):
    #print "\ngetting default path for " + node.name.getValue() +","
    defaultpath=[node]
    if (node.getClass()=='Basic' or node.getClass()=='History'):
        return defaultpath
    for link in node.out_connections_:
        if link.getClass()=="contains" and \
           link.out_connections_[0].is_default.getValue()[1]==True:
            defaultpath=getDefaultPath(link.out_connections_[0]) + defaultpath
            break
    else:
        raise node.name.getValue() + " contains no default state!"
    #print "result: ",defaultpath
    return defaultpath


# Uses the modules FileWriter to write the code corresponding to the
# exit actions of all states in 'leaving' the actions all edges in
# 'travelling' and the enter actions of all states in 'arriving'.
def writePathCode(leaving, travelling, arriving):
    while leaving:
        left = leaving.pop()
        exitcode=left.exit_action.getValue()
        if exitcode: fw.write(exitcode)
        for ae in getAfterEdges(left):
            fw.write("timers[" + afterevents[ae] + "] = INFINITY;")
        if left.getClass()=='Basic':
            for hc in getHistoryConnectors(left):
              w.write("self.LASTSTATE["+getNameStr(hc)+"] = "+getNameStr(left))
                
    while travelling:
        triggercode = travelling.pop().action.getValue()
        if triggercode: fw.write(triggercode)

    while arriving:
        arrived = arriving.pop()
        print len(arriving)
        entercode = arrived.enter_action.getValue()
        if entercode: fw.write(entercode)
        for ae in getAfterEdges(arrived):
            fw.write("timers["+afterevents[ae]+"] = currentTime + " + 
                     getAfterExp(ae) + ";")
            
    fw.write("\ncurrentState = State." + getNameStr(arrived) + ";")
    for out in getEventEdgesOutOf(arrived):
        if isUCTransition(out):
            fw.write("self.process([[None]])")
            break


# Writes initialization code. This includes initializing the object's event
# queue, timers, and history references.
def writeInitCode():
##    fw.write("self.EVENTQ=[]")
    #fw.write("self.CUR_TIME=time()")
    #laststate = {}.fromkeys(getName(historys))
    #fw.write('self.LASTSTATE = ' + str(laststate))

    #if afterevents:
    #    timers = (len(afterevents.items())-1) * 'INFINITY, ' + 'INFINITY'
    #    fw.write("\nself.TIMERS=["+timers+"]")

    initPath = getDefaultPath(getInitialState())
    #initialState = initPath[0]   do i need this???
    while initPath:
        writePathCode([], [], initPath)


# Computes the states that must be exited and entered if the system is to make
# a transition from 'startnode' to 'endnode' while currently residing in the
# basic state 'currentState'. These ordered lists are returned in a tuple,
# (exitedStates, enteredStates).
def getTransitionPath(startnode, endnode, currentState):
    #first get the ancestors of each node
    startAncestors=getOuterNodes(startnode)
    endAncestors=getOuterNodes(endnode)
    #now find the scope of the transition (lowest common proper ancestor)
    LCA=None
    while not(startAncestors[-1]==startnode or
              endAncestors[-1]==endnode or
              startAncestors[-1]!=endAncestors[-1]):
        LCA=startAncestors.pop()
        endAncestors.pop()
    #the states to be exited are all proper descendants of the scope in which
    #currentState resides
    #the states to be entered are all the proper descendants of the scope in
    #which the final basic state resides
    enterpath=getDefaultPath(endnode)+getOuterNodes(endnode)[1:]
    exitpath=getOuterNodes(currentState)
    if LCA:
        exitpath=exitpath[:exitpath.index(LCA)]    ## last element (LCA) is
        enterpath=enterpath[:enterpath.index(LCA)] ## not included in slice
    exitpath.reverse()
    return (exitpath, enterpath)


# Given a trigger (String), separates the trigger's name from its list of
# parameters. The returned value is a tuple (event, params). Before the
# separation is made, all the whitespaces are removed from 'trigger'.
# 'trigger' is required to have the form event(arg1,arg2,...,argn) where
# the ellipsis implies any number of arguments (and not the Python's ellipsis
# object.
def getEventParams(trigger):
        event_args = nowhites(trigger)
        event_args = noquotes(event_args)
        if not '(' in event_args: return (event_args, []) # no args
        params=[]
        event = ""+event_args[:event_args.index('(')]+""
        for a in event_args[trigger.index('(')+1:-1].split(","):
            params.append(a)
        return (event, params)
        
##        openstack=[]
##        openchars=['(','{','[',"'",'"']
##        endof = {'(':')','[':']','{':'}','"':'"',"'":"'"}
##        
##        arglist = trigger[trigger.index('(')+1:-1]
##        currentarg = ''
##        for i in arglist:
##            if not openstack:
##                if i==',':
##                    params.append(currentarg)
##                    currentarg = ''
##                elif i.isspace():
##                    continue
##                elif i in openchars:
##                    openstack.append(i)
##                    currentarg+=i
##                elif i in endof.values():
##                    print "WARNING - Unmatched " + i + " in " + event
##                    currentarg+=i
##                else:
##                    currentarg+=i
##            if openstack:
##                if i == endof[openstack[-1]]:
##                    openstack.pop()
##                    currentarg+=i
##                elif i.isspace() and not('"' in openstack or "'" in openstack):
##                    continue
##                elif i in openchars:
##                    openstack.append(i)
##                    currentarg+=i
##                else:
##                    currentarg+=i


# Deals with writing the code considering all the possible transitions when the
# system resides in the basic state 'state'. Calls getTransitionPath for each
# possibility, checks if the a history connector must be resolved, and then
# calls writePathCode.
def writeTransitionCodeFrom(state):
    containers = getOuterNodes(state)
    containers.reverse()    #reverse so pop() returns innermost container
    branch='if '
    nada=True
    while containers:
        c = containers.pop()
        transitions = getEventEdgesOutOf(c)

        if transitions: fw.write("// Transitions out of " + getName(c))

        while transitions:
            nada=False

            t = transitions.pop()
            trigger = toevent[t]
            guard = t.guard.getValue()

            if trigger:   #does the transition have a trigger?
              event, params = getEventParams(trigger)
              if guard:   #does it have a guard?
                condition="((event == "+event+") && ("+guard+")) {"
              else:
                condition="(event == "+event+") {"
            else:
              params = []
              if guard:   #does it have a guard?
                condition="(" + guard + ") {"
              else:
                condition="(1==1) {"
                
            fw.write(branch + condition+ "\t //"+ getName(t))
            for i in range(len(params)):
                fw.write(params[i] + " = PARAMS["+str(i)+"]")
            branch='else if '
            fw.indent()

            target = t.out_connections_[0]
            exits, enters = getTransitionPath(c,target,state)
            
            if enters[0].getClass()!='History':
                writePathCode(exits, [t], enters)
            # if trasition leads to a history connector, we must consider all
            # possible states it can reference.
            else:
                hc = enters[0]
                # if the current state is in the scope of the history connector
                # the transition resolves back to the current state since upon
                # leaving the current sate, the history connector will be
                # updated to reference the current state.
                if state in historyScope(hc):
                    (exits, enters) = getTransitionPath(c, state, state)
                    writePathCode(exits, [t], enters)
                else:
                    # first consider that the history connector is not yet
                    # referencing any state. Consider any NON-TRIGGERED hyper-
                    # edge out of it or else resolve to the default state.
                    H=tostate[hc]
                    fw.write("if LASTSTATE['" + H + "']==None:")
                    fw.indent()
                    skipdef = False
                    b='if '
                    for link in getHyperedgesOutOf(hc):
                        if isUCTransition(link):
                            if hasGuard(link):
                                cond = '(' + link.guard.getValue() + '):'
                            else:
                                cond = '(True):' # null transition found
                                skipdef = True #nevermind writing the code that
                                               #sends to the defalt state
                            fw.write(b+cond,indent,f)
                            fw.indent()
                            b='elif '
                            ht=link
                            ref=link.out_connections_[0]
                            (exits, enters) = getTransitionPath(c, ref, state)
                            writePathCode(exits,[t,ht],enters)
                            fw.dedent()
                    
                    if not skipdef:
                        # send to default state
                        parent = getOuterNodes(hc)[1]
                        ref=getDefaultPath(parent)[0]
                        ### target garanteed to be contained at least once or
                        ### else current state would have been caught in
                        ### historyScope(hc) above.
                        if ref!=hc:
                            if b=='elif': #previous condition exists
                                fw.write("else:")
                                fw.indent()
                            (exits, enters) = getTransitionPath(c, ref, state)
                            writePathCode(exits, [t], enters)
                            if b=='elif': fw.dedent()
                        else:
                            print "WARNING - "+getName(hc)+" as Default State \
of " + getName(parent) + " may cause unwanted behaviour."
                            fw.write("pass")
                    fw.dedent()        
                    # now consider all the possible states the history
                    # connector can reference.
                    for ref in historyScope(hc):
                        fw.write('elif LASTSTATE['+H+']=='+getNameStr(ref))
                        fw.indent()
                        (exits, enters) = getTransitionPath(c, ref, state)
                        writePathCode(exits, [t], enters)
                        fw.dedent()
            fw.dedent()
            fw.write("}")
    if nada: fw.write("") #fw.write("pass")


# Writes code required to process one event from a specified queue, 'evtq',
# excluding all events whose names are listed in triggeredOps. Essentially this
# calls writeTransitionCodeFrom for each basic state in the model.
def writeEventProcessingCode(evtq):
    if afterevents:
        ##fw.write("self.CUR_TIME = time()")
        fw.write("\ntimeb temp;")
        fw.write("ftime(&temp);")
        fw.write("\ncurrentTime = temp.time*1000 + temp.millitm;")            
        ##fw.write("for i in range(len(self.TIMERS)):")
        ##fw.indent()
        ##fw.write("if self.CUR_TIME>=self.TIMERS[i]:")
        ##fw.indent()
        ##fw.write(evtq + ".append(['_' + str(i) + 'after'])")
        ##fw.dedent()
        ##fw.dedent(
        for i in range(0,10):
            fw.write("\nif ((timers[" + str(i) + "] != INFINITY) && (timers[" + str(i) + "] < currentTime)) {")
            fw.indent()
            fw.write(evtq + ".push_back(_" + str(i) + "after);")
            fw.dedent()
            fw.write("}")
        
    fw.write("\n while ( " + evtq +".size() != 0) {")
    fw.indent()
    fw.write("\nmyEvent event = "+ evtq +".front();")
    fw.write(evtq +".pop_front(); \n\n")
    
    branch = 'if '
    for state in basics:
        fw.write(branch + " (currentState == State." + getNameStr(state) + ") {")
        fw.indent()
        writeTransitionCodeFrom(state)
        fw.dedent()
        fw.write("}")
        branch='else if '

    fw.dedent()
    fw.write("}")

# Similar to writeEventProcessingCode. This writes the code required to process
# the edge triggered by the operation 'op'.
def writeTriggeredOperationCode(op):
    opname = nowhites(op)
    statebranch = "if "
    for state in basics:
        containers = getOuterNodes(state)
        containers.reverse()    #reverse so pop() returns innermost container
        nada=True
        guardbranch = "if "
        while containers:
            c = containers.pop()
            transitions = getOperationEdgesOutOf(c, opname)

            if transitions:
                fw.write("## Transitions out of " + getName(c))
                if  nada:
                    fw.write(branch + "(currentState State.== "+getNameStr(state)+" ) {")
                    statebranch="else if "
                    fw.indent()
                    nada=False
            while transitions:

                t = transitions.pop()
                guard = t.guard.getValue()

                if guard:   #does it have a guard?
                    fw.write(guardbranch + "("+guard+"):")
                    guardbranch='else if '
                    fw.indent()

                target = t.out_connections_[0]
                exits, enters = getTransitionPath(c,target,state)
            
                if enters[0].getClass()!='History':
                    writePathCode(exits, [t], enters)
            # if trasition leads to a history connector, we must consider all
            # possible states it can reference.
                else:
                    hc = enters[0]
                # if the current state is in the scope of the history connector
                # the transition resolves back to the current state since upon
                # leaving the current sate, the history connector will be
                # updated to reference the current state.
                    if state in historyScope(hc):
                        (exits, enters) = getTransitionPath(c, state, state)
                        writePathCode(exits, [t], enters)
                    else:
                    # first consider that the history connector is not yet
                    # referencing any state. Consider any NON-TRIGGERED hyper-
                    # edge out of it or else resolve to the default state.
                        H=tostate[hc]
                        fw.write("if LASTSTATE['" + H + "']==None:")
                        fw.indent()
                        skipdef = False
                        b='if '
                        for link in getHyperedgesOutOf(hc):
                            if isUCTransition(link):
                                if hasGuard(link):
                                    cond = '(' + link.guard.getValue() + '):'
                                else:
                                    cond = '(True):' # null transition found
                                    skipdef = True #nevermind writing the code that
                                                   #sends to the defalt state
                                fw.write(b+cond,indent,f)
                                fw.indent()
                                b='elif '
                                ht=link
                                ref=link.out_connections_[0]
                                (exits, enters) = getTransitionPath(c, ref, state)
                                writePathCode(exits,[t,ht],enters)
                                fw.dedent()
                    
                        if not skipdef:
                            # send to default state
                            parent = getOuterNodes(hc)[1]
                            ref=getDefaultPath(parent)[0]
                        ### target garanteed to be contained at least once or
                        ### else current state would have been caught in
                        ### historyScope(hc) above.
                            if ref!=hc:
                                if b=='elif': #previous condition exists
                                    fw.write("else:")
                                    fw.indent()
                                (exits, enters) = getTransitionPath(c, ref, state)
                                writePathCode(exits, [t], enters)
                                if b=='elif': fw.dedent()
                            else:
                                print "WARNING - "+getName(hc)+" as Default State \
of " + getName(parent) + " may cause unwanted behaviour."
                                fw.write("pass")
                        fw.dedent()        
                    # now consider all the possible states the history
                    # connector can reference.
                        for ref in historyScope(hc):
                            fw.write('elif LASTSTATE['+H+']=='+getNameStr(ref))
                            fw.indent()
                            (exits, enters) = getTransitionPath(c, ref, state)
                            writePathCode(exits, [t], enters)
                            fw.dedent()
                if guard: fw.dedent()
        if nada: fw.write("pass")
                                            
def writeStates():
    fw.write("enum State {")
    fw.indent()
    for state in basics:
        fw.write(getNameStr(state) + ",")
    fw.write("NONE")
    fw.dedent()
    fw.write("};")
                                            
