
from ATOM3 import ATOM3

import exporter_ClassDiagram 
import exporter_FileOutputer
import exporter_StateChartDiagram

reload(exporter_ClassDiagram)
reload(exporter_FileOutputer)
reload(exporter_StateChartDiagram)

def export(existingATOM3, model):
    
    classes = []
        
    for classEntity in model.listNodes['CD_Class3']:
        c = exporter_ClassDiagram.ClassDiagram(classEntity, existingATOM3)
        print "Class", c.name, "has been loaded in exporter."
        classes.append(c)
            
    for c in classes:
        exporter = GenericExporter(c)
        exporter.run()

class GenericExporter:
        
    def __init__(self, classDiagram):
        
        self.classDiagram = classDiagram
        if classDiagram.stateChart == 0:
            self.stateChart = None
        else:
            self.stateChart = classDiagram.stateChart 
        
    def run(self):
        
        methodList = []
        constructorList = []
        destructorList = []
                
        self.fOut = exporter_FileOutputer.FileOutputer(self.classDiagram.name + ".txt")
        
        for code in self.classDiagram.preClassCode:
            self.writeCode(code)
        self.fOut.write()            
        
        self.fOut.write("Class " + self.classDiagram.name)
        self.fOut.indent()
        self.fOut.write()
        
        for attribute, type, initValue in self.classDiagram.attributes:
            self.fOut.write("var " + type + " " + attribute + " is " + initValue)
    
        for name, type in self.classDiagram.objectRef:
            self.fOut.write("var objectref " + type + " " + name + ";")
    
        self.fOut.write()
        
        if self.stateChart != None:
            self.initCodeForChart(self.classDiagram.constructors)
            self.fOut.write("\n")
        else:
            for parameters, body in self.classDiagram.constructors:
                self.writeMethod(self.classDiagram.name, parameters, "", body)
        
        for name, parameters, returnType, body in self.classDiagram.methods:
            self.writeMethod(name, parameters, returnType, body)        
            
        for body in self.classDiagram.destructors:
            self.writeMethod("destructor", "", "void", body)        
            
        if self.stateChart != None:
            self.processChart()
        
        self.fOut.dedent()
        self.fOut.close()
    
    def writeCode(self, body):
        lineByLine = body.split("\n")
        for line in lineByLine:
            self.fOut.write(line)
    
    def writeConstructor(self, name, parameters, body):
    
        self.fOut.write()    
        self.fOut.write("function constructor ( " + parameters + " )\n")
        self.fOut.indent()
        self.fOut.write("current state is " + self.stateChart.initState)
        self.fOut.write("last state is None")
        self.fOut.write("current time is NOW")
        self.fOut.write("queue is a new Queue()")
        self.fOut.write()
        if self.stateChart.numberTimeTransitions != 0:
            for i in range(0, self.stateChart.numberTimeTransitions):
                self.fOut.write("timers ["+str(i)+"] is -1")
            for timer, exp in self.stateChart.initTimers:
                self.fOut.write("timers ["+timer+"] = " + exp + " + currentTime;")            
            self.fOut.write()
            
        for code in self.stateChart.initCode:
            self.writeCode(code)
        self.fOut.write()
        self.writeCode(body)
        self.fOut.dedent()
        self.fOut.write("")
    
    def writeMethod(self, name, parameters, returnType, body):
        
        self.fOut.write("function " + returnType + " " + name + "( " + parameters + " )\n")
        self.fOut.indent()
        self.fOut.write()
        self.writeCode(body)
        self.fOut.write()
        self.fOut.dedent()
    
    def initCodeForChart(self, constructors):
        
        self.fOut.write("var current state;")
        self.fOut.write("var last state;")
        self.fOut.write("var current time;")
        self.fOut.write("var timers [];")
        self.fOut.write("var queue;")    
        
        #writeConstructor(self.fOut, self.classDiagram.name, "", "")
        if constructors != []:
            for parameters, body in constructors:
                self.writeConstructor(self.classDiagram.name, parameters, body)    
        else:
            self.writeConstructor("constructor", "", "")    
    
    def processChart(self):
        
        self.fOut.write("function process() {\n")
        self.fOut.indent()
        self.fOut.write("current time is NOW;\n")
        if self.stateChart.numberTimeTransitions != 0:
            self.fOut.write("// Lets check the timers")
            self.fOut.write("foreach timer in timers")
            self.fOut.indent()
            self.fOut.write("if timer not -1 and timer greater then current time")
            self.fOut.indent()
            self.fOut.write("add to queue _<timer id>after")
            self.fOut.dedent()
            self.fOut.write("")
            self.fOut.dedent()
            self.fOut.write("")
    
        self.fOut.write()        
        self.fOut.write("while queue is not empty")
        self.fOut.indent()
        self.fOut.write(" ")
        self.fOut.write("event is last event in queue")
        self.fOut.write(" ")
        for state in self.stateChart.basics:
            # If the state has transition
            if self.stateChart.transitionData[state] != [] :            
                self.fOut.write("if  current state is " + state.name.getValue() + "\n")
                self.fOut.indent()
                self.processTransition(state)
                self.fOut.dedent()
                self.fOut.write("")
        
        self.fOut.dedent()
        self.fOut.write("")
            
        self.fOut.dedent()
        self.fOut.write("\n")
        
    def processTransition(self, state):
        
        transitions = self.stateChart.transitionData[state]
        
        for transition in transitions:
                                        
            if "event" in transition:
                condition = "event is " + transition["event"]
            else:
                condition = ""
            
            if "guard" in transition:
                if transition["guard"] == "1":
                    transition["guard"] = "true"
                        
                if condition == "":
                    condition = transition["guard"]
                else :
                    condition += " and " + transition["guard"]
            
            self.fOut.write()
            self.fOut.write("if " + condition)
            self.fOut.indent()
            
            for key, value in transition["timersToReset"]:
                self.fOut.write("timers [" + key + "] = -1;")
                
            for key, value in transition["historyToSet"]:
                self.fOut.write("history [" + key + "] = " + value)
                
            for key, value in transition["timersToSet"]:
                self.fOut.write("timers [" + key + "] = " + value + "+ current time")
            
            for code in transition["exitCode"]:
                self.writeCode(code)
                
            for code in transition["triggerCode"]:
                self.writeCode(code)
            
            for code in transition["enterCode"]:
                self.writeCode(code)
            
            
            self.fOut.write("current state is " + transition["destinationState"])
            
            self.fOut.dedent()
            self.fOut.write()
        