import os

from ATOM3 import ATOM3
from Tkinter import *

import exporter_StateChartDiagram

class ClassDiagram:

	def __init__(self, classEntity, existingATOM3):
		
		self.classEntity = classEntity
		self.existingATOM3 = existingATOM3
		self.name = classEntity.name.getValue()
		
		self.constructors = []
		self.destructors = []
		self.attributes = []
		self.methods = []
		self.objectRef = []
		self.preClassCode = []
		self.postClassCode = []
		self.extendClassCode = []		
		self.getMethods = []
		self.stateChart = 0
		
		self.processDiagram()
		

	def processMethod(self, methodEntity):

		#dir methodEntity
		
		name = methodEntity.attrName.strip()
		parameters = methodEntity.initialValue.parameters.getValue()
		returnType = methodEntity.initialValue.returnType.getValue()
		body = methodEntity.initialValue.body.getValue()
		

		
		self.methods.append( (name, parameters, returnType, body) )

	def processConstructor(self, methodEntity):
	
		#name = methodEntity.attrName.strip()
		body = methodEntity.initialValue.body.getValue()
		parameters = methodEntity.initialValue.parameters.getValue()
		
		self.constructors.append( (parameters, body) )		
		    
	def processDestructor(self, methodEntity):
	
		#name = methodEntity.attrName.strip()
		body = methodEntity.initialValue.body.getValue()
		
		self.destructors.append( body )

	def processObjectReference(self, obRef):
	
		name = obRef.attrName.strip()
		type = obRef.initialValue.objectType.getValue()
		
		self.objectRef.append( (name, type) )
 	
 	def processPreClassCode(self, codeEntity):
 		
 		name = codeEntity.attrName.strip()
 		code = codeEntity.initialValue.code.getValue()
 		
 		self.preClassCode.append(code)
 	
	def processPostClassCode(self, codeEntity):
 		
 		name = codeEntity.attrName.strip()
 		code = codeEntity.initialValue.code.getValue()
 		
 		self.postClassCode.append(code)

	def processExtendClassCode(self, codeEntity):
 		
 		name = codeEntity.attrName.strip()
 		code = codeEntity.initialValue.code.getValue()
 		
 		self.extendClassCode.append(code)

	def processGetMethod(self, methodEntity):

		#dir methodEntity
		
		name = methodEntity.attrName.strip()
		parameters = methodEntity.initialValue.parameters.getValue()
		returnType = methodEntity.initialValue.returnType.getValue()
		body = methodEntity.initialValue.body.getValue()

		self.getMethods.append( (name, parameters, returnType, body) )
		
	def processVariable(self, var, type):		
		
		name = var.attrName.strip()
		initValue = var.initialValue.toString();
		self.attributes.append( (name, type, initValue) )
 	
	def processChart(self, chartEntity):
		
		if self.stateChart != 0:
			raise "Error, two state chart found"

		pathString = chartEntity.initialValue.getValue()
		
		if(not os.path.exists(pathString)):
			raise "Error, model " + pathString + "not found."
		else:
			#try:        		
				print "Loading state chart", pathString
				temporaryWindow = Toplevel(self.existingATOM3.parent)
				temporaryWindow.withdraw()
				atom3i=ATOM3(temporaryWindow,"DCharts",0,1)
				atom3i.open(fileName=pathString)
				model = atom3i.ASGroot
				self.stateChart = exporter_StateChartDiagram.StateChartDiagram(model)

			#except:
			#	print "Error, unable to load model ", pathString
			#	temporaryWindow.destroy()
			#	raise "Error, unable to load model "		
		
	def processDiagram(self):
		attributes = self.classEntity.attributes.getValue()

		for a in attributes:
			atype = a.seltype.strip()
			
			if (atype == "Text"): #text means operation yo
	 			self.processMethod(a)
		  	elif (atype == "CDV3_DChart_TYPE"):
	  			self.processChart(a)
 	  		elif (atype == "CDV3_ObjectReference_TYPE"):
	  			self.processObjectReference(a)
		  	elif (atype == "CDV3_Constructor_TYPE"):
	  			self.processConstructor(a)
 	  		elif (atype == "CDV3_Destructor_TYPE"):
	  			self.processDestructor(a)
		  	elif (atype == "CDV3_Method_TYPE"):
	  			self.processMethod(a)
	   		elif (atype == "Float"):
		  		self.processVariable(a, atype)
		  	elif (atype == "Integer"):
	  			self.processVariable(a, atype)
		  	elif (atype == "String"):
	  			self.processVariable(a, atype)
		  	elif (atype == "Boolean"):
	  			self.processVariable(a, atype)	  			
	 	  	elif (atype == "CDV3_PreClassCode_TYPE"):
	 	  		self.processPreClassCode(a)
	 	  	elif (atype == "CDV3_PostClassCode_TYPE"):
	 	  		self.processPostClassCode(a)
			elif (atype == "CDV3_ExtendClassCode_TYPE"):
	 	  		self.processExtendClassCode(a)
			elif (atype == "CDV3_GetMethod_TYPE"):
	 	  		self.processGetMethod(a)				
			else:
		  		print "Error, unsupported type " + atype
		  		#raise "Error, unsupported type "				
  		
	
	
	