

class StateChartDiagram:
    
    # Gives the module information on the statechart by listing its basic,
    # composite and history states as well as mapping triggers to names making the
    # appropriate conversion from AFTER() triggers to event names.
    def __init__(self, stateChart):
        self.stateChart = stateChart
        
        self.triggeredOps = []
        self.eventList = []
        self.afterevents = {}
        self.toevent = {}
        
        self.initTimers = []
        self.initCode = []
        self.initState = ""

        self.basics = self.stateChart.listNodes['Basic']
        self.composites = self.stateChart.listNodes['Composite']
        self.historys = self.stateChart.listNodes['History']
        self.edges = self.stateChart.listNodes["Hyperedge"]
        
        self.transitionData = {}
        i_after = 0
        for edge in self.edges:
            if edge.trigger.getValue():
                if self.isAfter(edge):
                    value = "_" + str(i_after) + "after"
                    self.afterevents[edge] = str(i_after)
                    i_after += 1
                else:
                    value = edge.trigger.getValue()
            else:
                value = ''
            self.toevent[edge] = value
    
        self.numberTimeTransitions = i_after
        
        
        
        for state in self.basics:
            self.transitionData[state] = self.buildTransitionStructures(state)
        
        pathToInit = self.getDefaultPath(self.getInitialState());
        
        while pathToInit:
            pathNode = pathToInit.pop()
            self.initCode.append(pathNode.enter_action.getValue())
            
            for ae in self.getAfterEdges(pathNode):
                self.initTimers.append( (self.afterevents[ae], self.getAfterExp(ae)) )                

        self.initState = pathNode.name.getValue()
        #self.initState = 
    
    # Tells the module what names are bound to triggered operations
    # 'ops' is expected not to contain any whitespaces
    def setTriggeredOperations(self, ops):        
        self.triggeredOps = ops
    
    
    # Returns the name of s or a list of names of elements of s.
    def getName(s):
          if type(s)==type([]):
            return map(getName,s)
          return s.name.getValue()
    
    
    # Same as getNames(s) but the strings returned are enclosed in single quotes
    def getNameStr(self, s):
          if type(s)==type([]):
            return map(getNameStr,s)
          return s.name.getValue()
    
    
    # Returns true iff edge is an unconditional transition (i.e. no trigger)
    def isUCTransition(self, edge):
        return not edge.trigger.getValue()
    
    
    # Returns true if the edge has a guard
    def hasGuard(self, edge):
        return not (not edge.guard.getValue())
    
    
    # Returns a list of edges out of state which are triggred by AFTER()
    def getAfterEdges(self, state):
        afters = []
        edges = self.getEventEdgesOutOf(state)
        for edge in edges:
          if self.isAfter(edge):
            afters.append(edge)
        return afters
    
    
    # Given a hyperedge determines whether it is triggered by AFTER()
    def isAfter(self, edge):
        value = edge.trigger.getValue().strip()
        if value[0:6] == "AFTER(" and value[-1] == ")":
          return True
        return False
    
    
    # Given a hyperedge returns the timeout value from an AFTER() trigger
    def getAfterExp(self, afteredge):
        value = afteredge.trigger.getValue().strip()
        return value[6:-1]
    
    
    # Returns an optimized list of all hyperedges coming out of 'node'.
    # The list does not include hyperedges whose trigers are operations in the
    # triggeredOps list.
    # If a hyperedge with no trigger or guard is found then it alone is returned.
    # Otherwise the returned list is ordered by hyperedges having guards only,
    # followed by the rest of the hyperedges. This is done to facilitate the
    # sequence of transitions executed in a single step (loop iteration).
    def getEventEdgesOutOf(self, node):
        onlyguards = []
        withtriggers = []
        for link in node.out_connections_:
            if link.getClass()=="Hyperedge":
                if self.isUCTransition(link):
                    if not self.hasGuard(link):
                        return [link]
                    else:
                        onlyguards.append(link)
                elif not self.getEventParams(link.trigger.getValue())[0]in self.triggeredOps:
                    withtriggers.append(link)
        return onlyguards + withtriggers
    
    
    # Returns a list of edges coming out of 'node' that are triggered by the
    # operation 'op'. If there exists such an edge that does not have a guard, then
    # one of them is the only element of the list that is returned. This is done
    # to implement the sematics that an edge with no guard can always be taken,
    # thereby making another edge useless to consider.
    def getOperationEdgeOutsOf(node, opname):
        withguards = []
        for link in node.out_connections_:
            if link.getClass()=="Hyperedge" and \
               nowhites(link.trigger.getValue()).startswith(opname):
                if hasGuard(link):                
                    withguards.append(link)
                else:
                    return [link]
                    
        return withguards
    
    
    # Returns all basic states in the scope of the history connector H.
    def historyScope(H):
        s=[]
        for inlink in H.in_connections_:
            if inlink.getClass()=="contains":
                parent=inlink.in_connections_[0]
                print "\n\n\nThe parent is",parent
                break
        else:
            return basics #toplevel history node
    
        def getBasics(C):
            b=[]
            for outlink in C.out_connections_:
                if outlink.getClass()=='contains':
                    child=outlink.out_connections_[0]
                    if child.getClass()=='Basic':
                        b.append(outlink.out_connections_[0])
                    elif child.getClass()=='Composite':
                        b.extend(getBasics(child))
            return b
    
        return getBasics(parent)
    
    
    # Returns a list of History connectors whose scope contains 'state'. That
    # is, the list of History connectors that must be updated when the system
    # moves out of 'state'.
    def getHistoryConnectors(self,state):
      HC = []
      for h in self.historys:
        for inlink in h.in_connections_:
          if inlink.getClass()=="contains":
            break
        else:
            HC.append(h) #toplevel history node
    
      ancestors = self.getOuterNodes(state)
      while len(ancestors)>1:
        ancestor = ancestors.pop()
        for outlink in ancestor.out_connections_:
          if outlink.getClass()=="contains" and \
             outlink.out_connections_[0].getClass()=="History":
            HC.append(outlink.out_connections_[0])
    
      return HC
    
    
    # returns a list representing the containment hierarchy of node.
    # node is always the first element, and its outermost composite is the last.
    def getOuterNodes(self, node):
        outernodes=[node]
        for link in node.in_connections_:
            if link.getClass()=="contains":
                outernodes = outernodes + self.getOuterNodes(link.in_connections_[0])
                break
        return outernodes
    
       
    # Returns the first top level default node found, can be Composite or Basic.
    # Raises an error if no such node is found.
    def getInitialState(self):
        
        for state in self.basics + self.composites:
            if state.is_default.getValue()[1]==True:
                for link in state.in_connections_:
                    if link.getClass()=="contains":
                        break
                else:
                        return state
        raise "No initial state found!"
    
    
    # Returns a list representing the containment hierarchy of the default
    # state of node, up to and including node itself. If node is Basic or History
    # then it is the only element of the returned list. Otherwise, the default 
    # state is always the first element, and node is the last. An error is raised
    # if no default History or Basic state is found.
    def getDefaultPath(self, node):
        #print "\ngetting default path for " + node.name.getValue() +","
        defaultpath=[node]
        if (node.getClass()=='Basic' or node.getClass()=='History'):
            return defaultpath
        for link in node.out_connections_:
            if link.getClass()=="contains" and \
               link.out_connections_[0].is_default.getValue()[1]==True:
                defaultpath=self.getDefaultPath(link.out_connections_[0]) + defaultpath
                break
        else:
            raise node.name.getValue() + " contains no default state!"
        #print "result: ",defaultpath
        return defaultpath
    
    
    # Uses the modules FileWriter to write the code corresponding to the
    # exit actions of all states in 'leaving' the actions all edges in
    # 'travelling' and the enter actions of all states in 'arriving'.
    def buildPathStructures(self, output, leaving, travelling, arriving):
        
        timersToReset = []
        timersToSet = []
        historyToSet = []
        
        exitCode = []
        triggerCode = []
        enterCode = []
        
        output["timersToReset"] = timersToReset
        output["timersToSet"] = timersToSet
        output["historyToSet"] = historyToSet
        output["exitCode"] = exitCode
        output["triggerCode"] = triggerCode
        output["enterCode"] = enterCode
        
        while leaving:
            left = leaving.pop()
            
            if left.exit_action.getValue():
                exitCode.append(left.exit_action.getValue())

            for ae in self.getAfterEdges(left):
                timersToReset.append( (self.afterevents[ae], "INFINITY") )
                                
            if left.getClass()=='Basic':
                for hc in self.getHistoryConnectors(left):
                    historyToSet.append( (self.getNameStr(hc), self.getNameStr(left)) )                  
                    
        while travelling:
            code = travelling.pop().action.getValue()
            if code:
                triggerCode.append(code)
    
        while arriving:
            arrived = arriving.pop()

            if arrived.enter_action.getValue():
                enterCode.append(arrived.enter_action.getValue())
                
            for ae in self.getAfterEdges(arrived):
                timersToSet.append( (self.afterevents[ae], self.getAfterExp(ae)) )
            
            output["destinationState"] = self.getNameStr(arrived)
        
        # Check for null transition
        #for out in getEventEdgesOutOf(arrived):
        #    if isUCTransition(out):
        #        fw.write("self.process([[None]])")
        #        break
    
    # Computes the states that must be exited and entered if the system is to make
    # a transition from 'startnode' to 'endnode' while currently residing in the
    # basic state 'currentState'. These ordered lists are returned in a tuple,
    # (exitedStates, enteredStates).
    def getTransitionPath(self, startnode, endnode, currentState):
        #first get the ancestors of each node
        startAncestors=self.getOuterNodes(startnode)
        endAncestors=self.getOuterNodes(endnode)
        #now find the scope of the transition (lowest common proper ancestor)
        LCA=None
        while not(startAncestors[-1]==startnode or
                  endAncestors[-1]==endnode or
                  startAncestors[-1]!=endAncestors[-1]):
            LCA=startAncestors.pop()
            endAncestors.pop()
        #the states to be exited are all proper descendants of the scope in which
        #currentState resides
        #the states to be entered are all the proper descendants of the scope in
        #which the final basic state resides
        enterpath= self.getDefaultPath(endnode) + self.getOuterNodes(endnode)[1:]
        exitpath= self.getOuterNodes(currentState)
        if LCA:
            exitpath=exitpath[:exitpath.index(LCA)]    ## last element (LCA) is
            enterpath=enterpath[:enterpath.index(LCA)] ## not included in slice
        exitpath.reverse()
        return (exitpath, enterpath)
    
    
    # Given a trigger (String), separates the trigger's name from its list of
    # parameters. The returned value is a tuple (event, params). Before the
    # separation is made, all the whitespaces are removed from 'trigger'.
    # 'trigger' is required to have the form event(arg1,arg2,...,argn) where
    # the ellipsis implies any number of arguments (and not the Python's ellipsis
    # object.
    def getEventParams(self, trigger):
            event_args = trigger.replace(' ', '') # remove spaces
            if not '(' in event_args: return (event_args, []) # no args
            params=[]
            event = "'"+event_args[:event_args.index('(')]+"'"
            for a in event_args[trigger.index('(')+1:-1].split(","):
                params.append(a)
            return (event, params)
            
    ##        openstack=[]
    ##        openchars=['(','{','[',"'",'"']
    ##        endof = {'(':')','[':']','{':'}','"':'"',"'":"'"}
    ##        
    ##        arglist = trigger[trigger.index('(')+1:-1]
    ##        currentarg = ''
    ##        for i in arglist:
    ##            if not openstack:
    ##                if i==',':
    ##                    params.append(currentarg)
    ##                    currentarg = ''
    ##                elif i.isspace():
    ##                    continue
    ##                elif i in openchars:
    ##                    openstack.append(i)
    ##                    currentarg+=i
    ##                elif i in endof.values():
    ##                    print "WARNING - Unmatched " + i + " in " + event
    ##                    currentarg+=i
    ##                else:
    ##                    currentarg+=i
    ##            if openstack:
    ##                if i == endof[openstack[-1]]:
    ##                    openstack.pop()
    ##                    currentarg+=i
    ##                elif i.isspace() and not('"' in openstack or "'" in openstack):
    ##                    continue
    ##                elif i in openchars:
    ##                    openstack.append(i)
    ##                    currentarg+=i
    ##                else:
    ##                    currentarg+=i
    
    
    # Deals with writing the code considering all the possible transitions when the
    # system resides in the basic state 'state'. Calls getTransitionPath for each
    # possibility, checks if the a history connector must be resolved, and then
    # calls buildPathStructures.
    def buildTransitionStructures(self, state):

        listOutput = []
    
        containers = self.getOuterNodes(state)
        containers.reverse()    #reverse so pop() returns innermost container
        
        while containers:
            c = containers.pop()
            transitions = self.getEventEdgesOutOf(c)
                
            while transitions:
                output = {}
                listOutput.append(output)
                
                t = transitions.pop()
                
                trigger = self.toevent[t]           
                guard = t.guard.getValue()
    
                if trigger:   #does the transition have a trigger?                  
                    event, params = self.getEventParams(trigger)
                    output["event"] = event
                    output["params"] = params
                    if event not in self.eventList:
                        self.eventList.append(event)
                  
                if guard:   #does it have a guard?                    
                    output["guard"] = guard
                    
                target = t.out_connections_[0]
                exits, enters = self.getTransitionPath(c,target,state)
                
                if enters[0].getClass()!='History':                    
                    self.buildPathStructures(output, exits, [t], enters)
#                # if trasition leads to a history connector, we must consider all
#                # possible states it can reference.
#                else:
#                    hc = enters[0]
#                    # if the current state is in the scope of the history connector
#                    # the transition resolves back to the current state since upon
#                    # leaving the current sate, the history connector will be
#                    # updated to reference the current state.
#                    if state in historyScope(hc):
#                        (exits, enters) = getTransitionPath(c, state, state)
#                        buildPathStructures(output, exits, [t], enters)
#                    else:
#                        # first consider that the history connector is not yet
#                        # referencing any state. Consider any NON-TRIGGERED hyper-
#                        # edge out of it or else resolve to the default state.
#                        H=tostate[hc]
#                        fw.write("if LASTSTATE['" + H + "']==None:")
#                        fw.indent()
#                        skipdef = False
#                        b='if '
#                        for link in getHyperedgesOutOf(hc):
#                            if isUCTransition(link):
#                                if hasGuard(link):
#                                    cond = '(' + link.guard.getValue() + '):'
#                                else:
#                                    cond = '(True):' # null transition found
#                                    skipdef = True #nevermind writing the code that
#                                                   #sends to the defalt state
#                                fw.write(b+cond,indent,f)
#                                fw.indent()
#                                b='elif '
#                                ht=link
#                                ref=link.out_connections_[0]
#                                (exits, enters) = getTransitionPath(c, ref, state)
#                                buildPathStructures(exits,[t,ht],enters)
#                                fw.dedent()
#                        
#                        if not skipdef:
#                            # send to default state
#                            parent = getOuterNodes(hc)[1]
#                            ref=getDefaultPath(parent)[0]
#                            ### target garanteed to be contained at least once or
#                            ### else current state would have been caught in
#                            ### historyScope(hc) above.
#                            if ref!=hc:
#                                if b=='elif': #previous condition exists
#                                    fw.write("else:")
#                                    fw.indent()
#                                (exits, enters) = getTransitionPath(c, ref, state)
#                                buildPathStructures(exits, [t], enters)
#                                if b=='elif': fw.dedent()
#                            else:
#                                print "WARNING - "+getName(hc)+" as Default State \
#    of " + getName(parent) + " may cause unwanted behaviour."
#                                fw.write("pass")
#                        fw.dedent()        
#                        # now consider all the possible states the history
#                        # connector can reference.
#                        for ref in historyScope(hc):
#                            fw.write('elif LASTSTATE['+H+']=='+getNameStr(ref))
#                            fw.indent()
#                            (exits, enters) = getTransitionPath(c, ref, state)
#                            buildPathStructures(exits, [t], enters)
#                            fw.dedent()
#                fw.dedent()
        
        return listOutput
    
    
    
    # Similar to writeEventProcessingCode. This writes the code required to process
    # the edge triggered by the operation 'op'.
    def writeTriggeredOperationCode(op):
        opname = nowhites(op)
        statebranch = "if "
        for state in basics:
            containers = getOuterNodes(state)
            containers.reverse()    #reverse so pop() returns innermost container
            nada=True
            guardbranch = "if"
            while containers:
                c = containers.pop()
                transitions = getOperationEdgesOutOf(c, opname)
    
                if transitions:
                    fw.write("## Transitions out of " + getName(c))
                    if  nada:
                        fw.write(branch+"self.CURRENTSTATE=="+getNameStr(state)+":")
                        statebranch="elif "
                        fw.indent()
                        nada=False
                while transitions:
    
                    t = transitions.pop()
                    guard = t.guard.getValue()
    
                    if guard:   #does it have a guard?
                        fw.write(guardbranch + "("+guard+"):")
                        guardbranch='elif '
                        fw.indent()
    
                    target = t.out_connections_[0]
                    exits, enters = getTransitionPath(c,target,state)
                
                    if enters[0].getClass()!='History':
                        buildPathStructures(exits, [t], enters)
                # if trasition leads to a history connector, we must consider all
                # possible states it can reference.
                    else:
                        hc = enters[0]
                    # if the current state is in the scope of the history connector
                    # the transition resolves back to the current state since upon
                    # leaving the current sate, the history connector will be
                    # updated to reference the current state.
                        if state in historyScope(hc):
                            (exits, enters) = getTransitionPath(c, state, state)
                            buildPathStructures(exits, [t], enters)
                        else:
                        # first consider that the history connector is not yet
                        # referencing any state. Consider any NON-TRIGGERED hyper-
                        # edge out of it or else resolve to the default state.
                            H=tostate[hc]
                            fw.write("if LASTSTATE['" + H + "']==None:")
                            fw.indent()
                            skipdef = False
                            b='if '
                            for link in getHyperedgesOutOf(hc):
                                if isUCTransition(link):
                                    if hasGuard(link):
                                        cond = '(' + link.guard.getValue() + '):'
                                    else:
                                        cond = '(True):' # null transition found
                                        skipdef = True #nevermind writing the code that
                                                       #sends to the defalt state
                                    fw.write(b+cond,indent,f)
                                    fw.indent()
                                    b='elif '
                                    ht=link
                                    ref=link.out_connections_[0]
                                    (exits, enters) = getTransitionPath(c, ref, state)
                                    buildPathStructures(exits,[t,ht],enters)
                                    fw.dedent()
                        
                            if not skipdef:
                                # send to default state
                                parent = getOuterNodes(hc)[1]
                                ref=getDefaultPath(parent)[0]
                            ### target garanteed to be contained at least once or
                            ### else current state would have been caught in
                            ### historyScope(hc) above.
                                if ref!=hc:
                                    if b=='elif': #previous condition exists
                                        fw.write("else:")
                                        fw.indent()
                                    (exits, enters) = getTransitionPath(c, ref, state)
                                    buildPathStructures(exits, [t], enters)
                                    if b=='elif': fw.dedent()
                                else:
                                    print "WARNING - "+getName(hc)+" as Default State \
    of " + getName(parent) + " may cause unwanted behaviour."
                                    fw.write("pass")
                            fw.dedent()        
                        # now consider all the possible states the history
                        # connector can reference.
                            for ref in historyScope(hc):
                                fw.write('elif LASTSTATE['+H+']=='+getNameStr(ref))
                                fw.indent()
                                (exits, enters) = getTransitionPath(c, ref, state)
                                buildPathStructures(exits, [t], enters)
                                fw.dedent()
                    if guard: fw.dedent()
            if nada: fw.write("pass")
