from ATOM3 import ATOM3
import os
from Tkinter import *
import DChartFunctions_cpp
import FileWriter_cpp

reload(DChartFunctions_cpp)
reload(FileWriter_cpp)

fwC = FileWriter_cpp.FileWriter('gen_CD.cpp')   # output file
fwH = FileWriter_cpp.FileWriter('gen_CD.h')   # output file
DChartFunctions_cpp.setFileWriter(fwH)

# Scans all lines of text and converts any event generation command (ie GEN(e))
# to the apropriate code. Also prefixes each line with 4*(indent) spaces. The
# resulting text is written to f, a file that has been opened for writing.
##def toFile(text, indent, f):
##    if text:
##        code=""
##        s=text.splitlines()
##    for l in s:
##        if l.startswith('GEN('):
##            event=l[4:-1]
##            l="EVENTQ.append('"+event+"')"
##            code=code+ 4*indent*" " + l + "\n"
##    f.write(code)

##def sameOperations(op1, op2):
##    return op1.replace(' ','') == op2.replace(' ','')
    

def gen(existingATOM3, CDmodel):

    init = "(self, dispatcher):"
    
    ##fwC.write("from time import time")
    ##fwC.write("from infinity import *")

    fwH.write("#include \"ai.h\"")
    fwH.write("#include \"atom3_utils.h\"")
    fwH.write("#include <time.h>")
    fwH.write("#include <sys/timeb.h>")
    fwH.write("\n#define INFINITY -1")
    
    fwC.write("#include \"gen_CD.h\"")
    
    # Foward class declaration
    for classEntity in CDmodel.listNodes['CD_Class3']:
        fwH.write("class " + classEntity.name.getValue() + ";")

    for classEntity in CDmodel.listNodes['CD_Class3']:
        
        dchartFound = False
        opbodies = {}
        opnames = []
        functionList = []
        
        DChartFunctions_cpp.setFileWriter(fwH)
        
        fwH.write("\n\nclass " + classEntity.name.getValue() + " : public CAtom3DChart { ")
        fwH.indent()

        fwH.write("\npublic:")
        fwH.indent()
        fwH.write("\n")

        constructorArg = ""
        constructorBody = ""
            
        for a in classEntity.attributes.getValue():
            atype = a.seltype
            
            classAttributeType = ""
            classAttributeInit = ""
            
            if atype=="Text": #text means operation yo
                #if a.name.getValue().strip=="__init__":
                #    init = a.initialValue.getValue().strip()
                #    continue
                #op = nowhites(a.name.getValue())
                #name = op[:op.index('(')]
                #args = op[op.index('('):]
                #if not name in opnames:
                #    opnames.append(name)
                #    opbodies[op]=a.initialValue.getValue()
                #else:
                #    print "WARNING - Multiple declaration of operation " + name
                #    print "Disregarding declaration " + op
                functionList.append(a.initialValue.getValue());
                    
            elif atype=="CDV3_DChart_TYPE":
                if not dchartFound:
                    pathString = a.initialValue.getValue()
                    if(not os.path.exists(pathString)):
                        print 'Path to dchart:',pathString,"not found."
                    else:
                        try:
                            print 'attempting a new atom3 instance'
                            temporaryWindow = Toplevel(existingATOM3.parent)
                            temporaryWindow.withdraw()
                            atom3i=ATOM3(temporaryWindow,"DCharts",0,1)
                            atom3i.open(fileName=pathString)
                            model = atom3i.ASGroot
                            DChartFunctions_cpp.load(model)
                            dchartFound = True
                        except:
                            print "An error occured while attempting to load dchart model"
                            temporaryWindow.destroy()
            elif atype=="Integer":
                #argument = a.self.seltype + " " + a.attrName + " = " + a.initialValue.toString() + ";"
                classAttributeType = "int";
                classAttributeInit = a.initialValue.toString();
                
            elif atype=="Float":
                classAttributeType = "float";
                classAttributeInit = a.initialValue.toString();
                
            elif atype=="String":
                classAttributeType = a.initialValue.toString();
                
                
            if classAttributeType != "":
                
                # Declare the attributes
                fwH.write(classAttributeType + " " + a.attrName + ";")

                if classAttributeInit == "":
                    # Prepare the constructor function header for stuff without init values
                    if constructorArg == "" :
                        constructorArg = classAttributeType + " arg_" + a.attrName
                    else :
                        constructorArg = constructorArg + ", arg_" + classAttributeType + " " + a.attrName
                    # and prepare the constructor body                
                    constructorBody = constructorBody + "\n" + a.attrName + " = arg_" + a.attrName + ";"                    
                else:
                    #Attributes with initial values should just be initialized.
                    constructorBody = constructorBody + "\n" + a.attrName + " = " + classAttributeInit + ";"                    

        fwH.write("\n")
        if dchartFound:
            DChartFunctions_cpp.writeStates()
            fwH.write("\n")        
            fwH.write("myState currentState;")
            fwH.write("\n")        
        fwH.write(classEntity.name.getValue() + "(" + constructorArg + ");")
        if dchartFound:
            fwH.write("void process( );")
        
        for b in functionList:
            functionDeclaration = b.splitlines()[0]
            functionDeclaration = functionDeclaration.replace(classEntity.name.getValue(),"");
            functionDeclaration = functionDeclaration.replace("::","");
            functionDeclaration = functionDeclaration.replace("{","");
            fwH.write(functionDeclaration + ";")

        fwH.dedent()
        fwH.dedent()
        
        fwH.write("};")
        
        DChartFunctions_cpp.setFileWriter(fwC);

        # Constructor
        fwC.write("\n" + classEntity.name.getValue() + "::" + classEntity.name.getValue() + "(" + constructorArg + ") {")
        fwC.indent()
        
        fwC.write(constructorBody + "\n")                
        
        fwC.write("\ntimeb temp;")
        fwC.write("ftime(&temp);")
        fwC.write("\ncurrentTime = temp.time*1000 + temp.millitm;")            
        
        
        fwC.write("\nfor(int i = 0; i < 10; i++) {")
        fwC.indent()        
        fwC.write("timers[i] = INFINITY;")
        
        fwC.dedent()
        fwC.write("}")                                    
        DChartFunctions_cpp.setTriggeredOperations(opnames)
        
        if dchartFound:
            DChartFunctions_cpp.writeInitCode()
            
        fwC.dedent()        
        fwC.write("}")
        
        # Process function
        if dchartFound:

            fwC.write("\nvoid " + classEntity.name.getValue() + "::process( ) {")
            fwC.indent()
            DChartFunctions_cpp.writeEventProcessingCode('chartEventList')
            fwC.dedent()                    
            fwC.write("}")

        #for op in opbodies.keys():
        #    body = strip(opbodies[op])
        #    fwC.write("\ndef " + op + body)
        #    fwC.indent()
        #    if dchartfound:
        #        DChartFunctions.writeTriggeredOperationCode(op)
        #    fwC.dedent()
            for b in functionList:
                fwC.write("\n" + b);
            
        if dchartFound:
            temporaryWindow.destroy()
            dchartFound = False                
        
    fwC.close()
    fwH.close()
    
