import os
import sys
from Tkinter import *
from tkMessageBox import showinfo, showerror, askokcancel

from ATOM3Type import ATOM3Type
from ATOM3String import ATOM3String

from ATOM3 import ATOM3
from ATOM3TypeDialog import ATOM3TypeDialog




class CDV3_DChart_TYPEa (ATOM3Type):
  
  
   def __init__(self):
      ATOM3Type.__init__(self)
      self.pathATOM3String = None
      self.containerFrame = None


   def createComponents(self):
      if not self.pathATOM3String:
         self.pathATOM3String = ATOM3String('', 100)


   def show(self, parent, parentWindowInfo=None):
      self.createComponents()
      ATOM3Type.show(self, parent, parentWindowInfo)
      self.containerFrame = Frame(parent)
      i = 0
      
            
      editButton = Button(self.containerFrame, text='Edit DChart',
                          command=self.editHandler)
      editButton.grid(row=i, column=0, columnspan=1, sticky=EW)
      
      pathString = self.pathATOM3String.getValue()
      if(pathString):
        textA = 'DChart Path: '
        text = os.path.split(pathString)[1]
      else:
        textA = 'No DChart selected'
        text = '(press Edit to add one)'

      helpLabel = Label(self.containerFrame, text=textA, bg='white', 
                        relief='solid', font=("Helvetica", 10))
      helpLabel.grid(row=i, column=1, columnspan=1, sticky=EW)
      helpLabel = Label(self.containerFrame, text=text, bg='white', 
                        relief='groove', font=("Helvetica", 10))
      helpLabel.grid(row=i, column=2, columnspan=2, sticky=EW)
      
      return self.containerFrame
      
      
  

    

   def editHandler(self):
     """
     Intention in context:
       Handles user request to edit the layout statechart model by creating a 
       new window with a new instance of ATOM3 in it...
     """

     # Nothing can stop me from getting atom3i, nothing... Ahahahaahaha - Denis
     atom3i = ATOM3.ROOT_ATOM3_INSTANCE
     if(not atom3i):
       showerror('ERROR', 'No ATOM3 instance found! Call denkkar@gmail.com')
       return
     
     text = 'A new instance of ATOM3 is being created.'
     text += '\n\nYou can either create a new layout statechart model from'
     text += ' scratch or by modifying existing ones'
     text += '\n\nWhen done modeling: save and press the OK button on the bottom'
     if(not askokcancel('Edit Layout Model', text)):
       return

     # I can't import DCharts unless I have the path in sys.path so... add it :)
     atom3i.addDirectoryWithModelName('DCharts')
     from ASG_DCharts import ASG_DCharts 
     
     def openModel(AT3Dialog, ATOM3Instance, SemanticObject, self=self):
       """
       Attempts to open the currently selected layout statechart model
       Called by ATOM3TypeDialog as a post-command
       """
       pathString = self.pathATOM3String.getValue()
       if(pathString):
         ATOM3Instance.open(fileName=pathString)
       

     # Create a DChart ASG and then show it to the user! 
     # ATOM3TypeDialog in "OPEN" mode, will call the DChart ASG and make it
     # create a new instance of ATOM3 featuring the DChart ASG.
     at3object = ASG_DCharts(atom3i)
     windowAtom3 = ATOM3TypeDialog(atom3i, at3object, ATOM3TypeDialog.OPEN,
                                   (None, openModel))
     
     # Execution returns here only after the user closes windowAtom3
     if(windowAtom3.result_ok): 
       self.applyEdit(windowAtom3.myWidget)


       
   def applyEdit(self, atom3i):
     """
     Intention in context:
       If the user just edited/created a layout statechart, then make sure
       it is saved and then compile it into excutable code.
     Parameter:
       atom3i, the new windowed ATOM3 instance
     """
     
     modelPath = self.getSavedModelPath(atom3i)
     if(not modelPath):
       return 
       
     try:
       from SVMAToM3Plugin import generate_description
     except:
       showerror('SVM DCharts Plugin not found!',
                 'This error occured because SVMAToM3Plugin.py was not found in DCharts formalism')
       return
       
     try:
      import TkinterGenerator
     except:
      showerror('SVM/SCC package not found!', 
                'Please download it and add it to the "AToM3 User" directory '
                + 'in the "User Externals" sub-directory'
                + '\nUnable to generate layout model without this!')
      return
   
     # The model is saved AND we know where it is saved! 
     self.pathATOM3String.setValue(modelPath)
     
     sc = generate_description(atom3i, savetofile=None)
     desc = sc["desc"]
     
     # Save .des file
     tempString = modelPath.split('.')[0] # D:/blah/Blah_MDL.py <-- remove .py
#     if(tempString[-4:].upper() == '_MDL'):
#       tempString = tempString[:-4]
     desPath = tempString + '.DES'
     mf = open(desPath, "w")
     mf.write(desc)
     mf.close()
       
#================================================================================
#  Generate the code
#================================================================================
     # WARNING: I get the path to scc.py because TkinterGenerator just happens
     # to be in the same directory. I don't import scc to get the path to it
     # because just the act of importing would trigger code in scc.py which
     # I don't want! 
     scc = os.path.join(os.path.split(TkinterGenerator.__file__)[0], 'scc.py')
     pythonPath = sys.executable # Path to Python executable
     os.system(pythonPath + ' "' + scc + '" -l tkinter "' + desPath + '"' )
      
#================================================================================
#  Find the name & path of the generated code file
#================================================================================
     DESfilename = os.path.split(desPath)[1] # get rid of path, just the filename
     DESfilename = DESfilename[:-3] + 'py' # Remove des, replace it with py
     compiledFilePath = os.path.join(os.getcwd(), DESfilename)
     if( os.path.exists( compiledFilePath ) ):
       print '\n"%s" was succesfully compiled as "%s"' % \
             (os.path.split(desPath)[1], os.path.split(compiledFilePath)[1] )
     else:
       print '\n"%s" could not be compiled' % (os.path.split(desPath)[1])
       return

#================================================================================
#  Now lets put the compiled code somewhere useful.. like where the original
#  model was!  
#================================================================================
     newName = desPath[:-4] + '_Compiled.py'
     if(os.path.exists(newName)):
       backupName = newName + '.backup'
       if(os.path.exists(backupName)):
         os.remove(backupName)
       os.rename(newName, backupName)    
     os.rename(compiledFilePath, newName)

     text = """
Layout statechart successfully compiled!

All existing instances of the layout statechart will be swapped out of memory
in favor of the new one as soon as you press OK in the Editing DC_DChart dialog.

NOTE: Pressing Cancel will ignore your changes, although you can always reload
the saved layout statechart model...
"""
     showinfo('Layout Statechart Compilation', text)
     self.__isNewCompiledStatechart = True


   def isNewCompiledStatechart(self):
     """
     Returns:
       True if a statechart was compiled since the last time this method was
       called, False otherwise.
     """
     if(self.__dict__.has_key('__wasUpdated')):
       del self.__isNewCompiledStatechart
       return True
     return False


   def getSavedModelPath(self, atom3i):
     """
     Intention in context:
       Save the layout statechart model that the user just edited/created.
     Parameters:
       atom3i and ASGroot are of the new instances created in the window
     Return:
       Path to the saved model if things did work
       None, if something didn't work out
     """
          
     statusbar = atom3i.statusbar
     status, fileSavedTo = statusbar.getState(statusbar.MODEL)
     
     # Model is not saved! Save it!
     if(status == statusbar.MODIFIED):
       text = 'Please save the layout model (or press cancel to bail out)\n\n'
       if(not askokcancel('Save layout model', text)):
         return
       atom3i.save(export=0)
       
       # The user was asked to save the model, did they really do it?!?!
       status, fileSavedTo = statusbar.getState(statusbar.MODEL)
       if(status != statusbar.NOT_MODIFIED):
         showerror('Save path error', 'Model still not saved. Abort.')
         return
       
     # I doubt this could happen...
     if(not fileSavedTo):
       showerror('Save path error', 
                 'Statusbar showed model saved, but filepath not found. Abort.')
       return
       
     # We have a filestring...
     fileSavedToString = fileSavedTo[0] # Get the string from tuple
     # Oh you got to be kidding, save the model already!!!
     if(fileSavedToString == 'Nonamed'):
       showerror('Save path error', 'Model not saved. Abort.')
       return
     
     return fileSavedToString
           
     
  
   def toString(self, unused1=None, unused2=None):
      self.createComponents()
      return  self.pathATOM3String.toString()
      
      
      
   def getValue(self):
      self.createComponents()
      return self.pathATOM3String.getValue()



   def setValue(self, value):
      self.createComponents()
      if value == None:
         self.pathATOM3String.setNone()
      else:
         self.pathATOM3String.setValue(value)




   def writeConstructor2File(self, file, indent, objName="at", depth = 0, 
                             generatingCode = 0):
      self.createComponents()
      file.write(indent+objName+'= CDV3_DChart_TYPEa()\n')
      self.pathATOM3String.writeConstructor2File(file, indent, 
                       objName+'.pathATOM3String', depth, generatingCode)



   def writeValue2File(self, file, indent, objName="at", depth = 0, 
                       generatingCode = 0):
      self.createComponents()
      self.pathATOM3String.writeValue2File(file, indent, 
                              objName+'.pathATOM3String', depth, generatingCode)


   def clone(self):
     "Makes an exact copy of itself"
     cloneObject = CDV3_DChart_TYPEa()
     if self.pathATOM3String: 
       cloneObject.pathATOM3String = self.pathATOM3String.clone()
     return cloneObject
     
     
     
   def destroy(self):
     "Destroys (i.e. updates) each field"
     if self.pathATOM3String: 
       self.pathATOM3String.destroy()



   def invalid(self):
     "checks whether the entity is valid or not"
     inval = 0
     if self.pathATOM3String: 
       inval = inval or self.pathATOM3String.invalid()
     return inval

