
def nowhites(s):
        new = ""
        for c in s:
            if not str.isspace(c):
                new+=c
        return new

def noquotes(s):
        new = ""
        for c in s:
            if not c == '\'':
                new+=c
        return new

def leadingwhites(s):
    new = ""
    for c in s:
        if str.isspace(c):
            new+=c
        else:
            break
    return new



class FileWriter:

    def __init__(self, filename, spacepertab=4):
        self.out = open(filename, 'w')
        self.indentLevel = 0
        self.tablen=spacepertab

    def write(self, text):
        
        if text:
            code=""
            s=text.splitlines()
            for l in s:
                nw = nowhites(l)
                #accepted syntax for event is GEN(target, event(arg1,...,argn))
                if nw.startswith('GEN('):
                    target_event_args = nw[4:-1]
                    target = target_event_args[:target_event_args.index(",")]
                    event_args=target_event_args[target_event_args.index(",")+1:]
                    if "(" in event_args:
                        event = event_args[:nw.index('(')]
                        args = ","+event_args[nw.index('(')+1:-1]
                    else:
                        event = event_args # no arguments
                        args = ""
                    
                    send = "("+event+")"
                                       
                    l=leadingwhites(l)+ target + "->chartEventList.push_back" + send + ";"
                            
                code=code+ self.tablen*self.indentLevel*" " + l + "\n"
            self.out.write(code)

    def indent(self):
        self.indentLevel+=1

    def dedent(self):
        self.indentLevel-=1

    def close(self):
        self.out.close()
    
