
from ATOM3 import ATOM3

import exporter_ClassDiagram 
import exporter_FileOutputer
import exporter_StateChartDiagram

reload(exporter_ClassDiagram)
reload(exporter_FileOutputer)
reload(exporter_StateChartDiagram)

def export(existingATOM3, model):
    
    classes = []
        
    for classEntity in model.listNodes['CD_Class3']:
        c = exporter_ClassDiagram.ClassDiagram(classEntity, existingATOM3)
        print "Class", c.name, "has been loaded in exporter."
        classes.append(c)
            
    for c in classes:
        exporter = JavaExporter(c)
        exporter.run()

class JavaExporter:
        
    def __init__(self, classDiagram):
        
        self.classDiagram = classDiagram
        if classDiagram.stateChart == 0:
            self.stateChart = None
        else:
            self.stateChart = classDiagram.stateChart 
        
    def run(self):
        
        methodList = []
        constructorList = []
        destructorList = []
                
        #self.fOut = exporter_FileOutputer.FileOutputer("D:\\dev\\spaceracer-trunk\\src\\spaceracer\\" + self.classDiagram.name + ".java")
        self.fOut = exporter_FileOutputer.FileOutputer(self.classDiagram.name + ".java.txt")
            
        self.fOut.write()
        for code in self.classDiagram.preClassCode:
            self.writeCode(code)
        self.fOut.write()
        
        self.fOut.write("import java.util.LinkedList;")
        self.fOut.write("import java.util.Calendar;")        
        
        self.fOut.write("public class " + self.classDiagram.name + " {")
        self.fOut.indent()
        self.fOut.write()
        
        for attribute, type, initValue in self.classDiagram.attributes:
            if type == "Float" :
                self.fOut.write("public float " + attribute + " = " + initValue + ";")
            if type == "Integer" :
                self.fOut.write("public int " + attribute + " = " + initValue + ";")
            if type == "Boolean" :
                if initValue == True:
                    self.fOut.write("public boolean " + attribute + " = true;")
                else:
                    self.fOut.write("public boolean " + attribute + " = false;")
                    
        for name, type in self.classDiagram.objectRef:
            self.fOut.write("public " + type + " " + name + ";")
    
        self.fOut.write()
    
        if self.stateChart != None:
            self.initCodeForChart(self.classDiagram.constructors)
            self.fOut.write("\n")
            self.writeMethod("push", "String event", "void", "this.queue.add(event);")
            self.fOut.write("\n")
        else:
            for parameters, body in self.classDiagram.constructors:
                self.writeMethod(self.classDiagram.name, parameters, "", body)
        
        for name, parameters, returnType, body in self.classDiagram.methods:
            self.writeMethod(name, parameters, returnType, body)        
            
        for body in self.classDiagram.destructors:
            self.writeMethod("end", "", "void", body)        
            
        if self.stateChart != None:
            self.processChart()
        
        self.fOut.dedent()
        self.fOut.write("}")
        self.fOut.close()
    
    def writeCode(self, body):
        lineByLine = body.split("\n")
        for line in lineByLine:
            self.fOut.write(line)
    
    def writeConstructor(self, name, parameters, body):
    
        self.fOut.write()    
        self.fOut.write("public " + name + "( " + parameters + " ) {\n")
        self.fOut.indent()
        self.fOut.write()
        self.fOut.write("this.state = \"" + self.stateChart.initState +"\";")
        self.fOut.write("this.lastState = \"none\";")
        self.fOut.write("this.currentTime = Calendar.getInstance().getTimeInMillis();")
        self.fOut.write("this.queue = new LinkedList<String>();")
        self.fOut.write()
        
        if self.stateChart.numberTimeTransitions != 0:
            self.fOut.write("this.timer = new long[" + str(self.stateChart.numberTimeTransitions) + "];")
            for i in range(0, self.stateChart.numberTimeTransitions):                
                self.fOut.write("this.timer["+str(i)+"] = -1;")                
            for timer, exp in self.stateChart.initTimers:
                self.fOut.write("this.timer["+timer+"] = " + exp + " + this.currentTime;")            
            self.fOut.write()
            
        for code in self.stateChart.initCode:
            self.writeCode(code)
        self.fOut.write()                
        self.writeCode(body)
        self.fOut.dedent()
        self.fOut.write("}")
    
    def writeMethod(self, name, parameters, returnType, body):
        
        self.fOut.write("public " + returnType + " " + name + "( " + parameters + " ) {\n")
        self.fOut.indent()
        self.fOut.write()
        self.writeCode(body)
        self.fOut.write()
        self.fOut.dedent()
        self.fOut.write("}\n\n")
        
    
    def initCodeForChart(self, constructors):
        
        self.fOut.write("private String state;")
        self.fOut.write("private String lastState;")
        self.fOut.write("private long currentTime;")
        self.fOut.write("private long[] timer;")
        self.fOut.write("private LinkedList<String> queue;")    
        
        #writeConstructor(self.fOut, self.classDiagram.name, "", "")
        if constructors != []:
            for parameters, body in constructors:
                self.writeConstructor(self.classDiagram.name, parameters, body)    
        else:
            self.writeConstructor(self.classDiagram.name, "", "")    
    
    def processChart(self):
        
        self.fOut.write("public void process() {\n")
        self.fOut.indent()
        self.fOut.write("this.currentTime = Calendar.getInstance().getTimeInMillis();\n")
        if self.stateChart.numberTimeTransitions != 0:
            self.fOut.write("// Lets check the timers")
            self.fOut.write("for (int i = 0; i < " + str(self.stateChart.numberTimeTransitions) + "; i++) {")
            self.fOut.indent()
            self.fOut.write("if ((this.timer[i] != -1) && (this.timer[i] < this.currentTime)) {")
            self.fOut.indent()
            self.fOut.write("this.queue.add(\"_\" + i + \"after\");")
            self.fOut.dedent()
            self.fOut.write("}")
            self.fOut.dedent()
            self.fOut.write("}")
    
        self.fOut.write()        
        self.fOut.write("while(!this.queue.isEmpty()) {")
        self.fOut.indent()
        self.fOut.write(" ")
        self.fOut.write("String event = this.queue.removeLast();")
        self.fOut.write(" ")
        self.fOut.write("//System.out.println(\"[" + self.classDiagram.name + "] \" + event);")
        self.fOut.write(" ")
        for state in self.stateChart.basics:
            # If the state has transition
            if self.stateChart.transitionData[state] != [] :            
                self.fOut.write("if ( state.equals(\"" + state.name.getValue() + "\") ) {\n")
                self.fOut.indent()
                self.processTransition(state)
                self.fOut.dedent()
                self.fOut.write("}")
        
        self.fOut.dedent()
        self.fOut.write("}")
            
        self.fOut.dedent()
        self.fOut.write("}\n")
        
    def processTransition(self, state):
        
        transitions = self.stateChart.transitionData[state]
        
        for transition in transitions:
                                        
            if "event" in transition:
                condition = "( event.equals(\"" + transition["event"] + "\") )"
            else:
                condition = ""
            
            if "guard" in transition:
                if transition["guard"] == "1":
                    transition["guard"] = "true"
                        
                if condition == "":
                    condition = transition["guard"]
                else :
                    condition += " && " + transition["guard"]
            
            self.fOut.write()
            self.fOut.write("if ( " + condition + " ) {")
            self.fOut.indent()
            
            for key, value in transition["timersToReset"]:
                self.fOut.write("timer[" + key + "] = -1;")
                
            for key, value in transition["historyToSet"]:
                self.fOut.write("history[" + key + "] = " + value)
                
            for key, value in transition["timersToSet"]:
                self.fOut.write("timer[" + key + "] = " + value + " + this.currentTime;")
            
            for code in transition["exitCode"]:
                self.writeCode(code)
                
            for code in transition["triggerCode"]:
                self.writeCode(code)
            
            for code in transition["enterCode"]:
                self.writeCode(code)
            
            
            self.fOut.write("state = \"" + transition["destinationState"] + "\";")
            
            self.fOut.dedent()
            self.fOut.write("}")
            self.fOut.write()
        