from ATOM3 import ATOM3
import os
from Tkinter import *
import DChartFunctions
import FileWriter

reload(DChartFunctions)
reload(FileWriter)

fw = FileWriter.FileWriter('gen_py_CD.txt')   # output file
DChartFunctions.setFileWriter(fw)

# Scans all lines of text and converts any event generation command (ie GEN(e))
# to the apropriate code. Also prefixes each line with 4*(indent) spaces. The
# resulting text is written to f, a file that has been opened for writing.
##def toFile(text, indent, f):
##    if text:
##        code=""
##        s=text.splitlines()
##    for l in s:
##        if l.startswith('GEN('):
##            event=l[4:-1]
##            l="EVENTQ.append('"+event+"')"
##            code=code+ 4*indent*" " + l + "\n"
##    f.write(code)

##def sameOperations(op1, op2):
##    return op1.replace(' ','') == op2.replace(' ','')
    

def gen_py(existingATOM3, CDmodel):

    dchartFound = False
    opbodies = {}
    opnames = []
    init = "(self, dispatcher):"
    
    fw.write("from time import time")
    fw.write("from infinity import *")

    for classEntity in CDmodel.listNodes['CD_Class3']:
        fw.write("\n\n\nclass "+classEntity.name.getValue()+":")
        fw.indent()
        
        for a in classEntity.attributes.getValue():
            atype = a.seltype
            
            if atype=="Text": #text means operation yo
                if a.name.getValue().strip=="__init__":
                    init = a.initialValue.getValue().strip()
                    continue
                op = nowhites(a.name.getValue())
                name = op[:op.index('(')]
                #args = op[op.index('('):]
                if not name in opnames:
                    opnames.append(name)
                    opbodies[op]=a.initialValue.getValue()
                else:
                    print "WARNING - Multiple declaration of operation " + name
                    print "Disregarding declaration " + op
                    
            elif atype=="CDV3_DChart_TYPE":
                if not dchartFound:
                    pathString = a.initialValue.getValue()
                    if(not os.path.exists(pathString)):
                        print 'Path to dchart:',pathString,"not found."
                    else:
                        try:
                            print 'attempting a new atom3 instance'
                            temporaryWindow = Toplevel(existingATOM3.parent)
                            temporaryWindow.withdraw()
                            atom3i=ATOM3(temporaryWindow,"DCharts",0,1)
                            atom3i.open(fileName=pathString)
                            model = atom3i.ASGroot
                            DChartFunctions.load(model)
                            dchartFound = True
                        except:
                            print "An error occured while attempting to load dchart model"
                            temporaryWindow.destroy()

        fw.write("\ndef __init__"+init)
        fw.indent()
                            
        DChartFunctions.setTriggeredOperations(opnames)
        
        if dchartFound:
            DChartFunctions.writeInitCode()
            fw.dedent()
            fw.write("\ndef process(self, eventList):")
            fw.indent()
            DChartFunctions.writeEventProcessingCode('eventList')
            fw.dedent()

        for op in opbodies.keys():
            body = strip(opbodies[op])
            fw.write("\ndef " + op + body)
            fw.indent()
            if dchartfound:
                DChartFunctions.writeTriggeredOperationCode(op)
            fw.dedent()
            
        if dchartFound:
            temporaryWindow.destroy()
            dchartFound = False                
        fw.dedent()
        
    fw.close()
    
