"""
inheritanceGenerator.py

Generates code from the class diagram
Re-worked by Denis Dube May 16, 2005 and again Feb 2006
Beware the mad hacks... oooops did I say the H word? :)
"""

import tkMessageBox
import os

from ATOM3Connection import ATOM3Connection
from ATOM3Constraint import ATOM3Constraint

# Names of entities in Class Diagram formalism
from inheritanceCodeBase import Magic

  
def genCode(self):
  """ 
  Generates class diagram code 
  By Denis Dube
  """
    
  # Save first, so if anything goes wrong, we got a fallback position hehehe
  status = self.statusbar.getState(self.statusbar.MODEL)[0]
  if( status == self.statusbar.MODIFIED ):
    self.save()
    
#===============================================================================
#  Pathfinding initilization
#===============================================================================
    
  # Get the ASGroot for this formalism
  ASGroot = self.ASGroot.getASGbyName(Magic().ASGname)
    
  # Make sure we don't generate a formalism with no name...
  if( ASGroot and hasattr( ASGroot, 'name' ) ):
    if( ASGroot.name.getValue() == '' ): 
      modelPathAndFile = self.statusbar.getState(self.statusbar.MODEL)[1][0] 
      modelName = os.path.split(modelPathAndFile)[1].split('.')[0]
      modelName = modelName.split('_')[0]
      ASGroot.name.setValue(modelName)
      
      tkMessageBox.showerror(
               "Code Generator Error",
               "Please give your formalism a name, such as: " + modelName 
               + "\nAnd then try to generate again"
               + "\n\nNOTE: A name was automatically generated, so just"
               + " press OK in the next dialog if you like it.",
               parent = self
          )
      self.modelAttributes(ASGroot)
      return
       
  # In cardConstObjects, we are storing the objects with cardinality constraints
  cardConstObjects = []
  
  if ASGroot.keyword_:
         if self.console: 
           self.console.appendText('Generating code for model '
                         +ASGroot.keyword_.toString())
  else:
         if self.console: 
           self.console.appendText('Generating code for model.')
  

  # Use directory of class diagram for generating code
  modelPathAndFile = self.statusbar.getState(self.statusbar.MODEL)[1][0]      
  modelPath = os.path.split(modelPathAndFile)[0]
  oldCodeGenDir = self.codeGenDir
  self.codeGenDir = os.path.normpath( modelPath )
    
#===============================================================================
#  Generate code
#===============================================================================
  print 'Generating code to: ', self.codeGenDir
    
  # for each node type
  for nodeType in ASGroot.nodeTypes:        
     # for each object of any type
     for UMLobject in ASGroot.listNodes[nodeType]:    
         # Generate code for this particular entity
         self.genCodeFor (UMLobject, cardConstObjects)    
  
  # see first if we have generative attributes...
  self.genASGCode(cardConstObjects, ASGroot)  # generate code for the ASG node
  self.genButtons(ASGroot)       # generate the file for the syntax actions
  # now generate the file with the GUI model...
  self.genButtonsModel(ASGroot)
  
#===============================================================================
#  Cleanup
#===============================================================================
  
  # Restore path
  self.codeGenDir = oldCodeGenDir
  
  # Clear the screen, and then reload the old diagram
  # WHY? Because this generator has totally messed up the diagram in order
  # to do the inheritance stuff (it's safer this way, trust Denis)
  self.clearModel( showDialog=False )
  
  #for nodeType in ASGroot.nodeTypes:
  #  print nodeType, ASGroot.listNodes[nodeType]
    
  # Re-open the model
  self.open( fileName = modelPathAndFile )
  
  tkMessageBox.showinfo(
   "Code generated",
   "Code generated in:\n    " + modelPath +
   "\n\nPlease restart AToM3 before trying to load the newly generated " +
   "formalism\n\nHINT: starting another instance of AToM3 works too"
  )
  
  
  
def propagateInheritanceItems(ASGroot):
  """
  Author?
  """
  inheritance_rel = ASGroot.listNodes[Magic().inheritanceClassName]
  i = 0
  ##print "inheritance_rel=", inheritance_rel
  
  # now go for each inheritance association...
  while len(inheritance_rel)>0:
     inh = inheritance_rel[i]          # get the ith inheritance relationship
     ##print "inh=", inh
     parent = inh.out_connections_[0]  # get parent & child of the relationship  
     ##print "parent=", parent
     child = inh.in_connections_[0]
     ##print "child=", child
     found = 0
     # check that the parent does not have another class up
     for in_proc in parent.out_connections_:  
          if in_proc in inheritance_rel: 
             found = 1
             break   
     if found == 1:
        i = i+1
        if (i>=len(inheritance_rel)-1): 
          i = 0
     else:
        # add the attributes of the father to the child
        #child.addedAttrs = []
        child.added_in_connections_ = []
        child.added_out_connections_ = []
        child.addedCardinalities = []
        #for attr in parent.attributes.getValue():
           #child_attr = attr.clone()
           #child.attributes.newItem(child_attr)
           #child.addedAttrs.append(child_attr)
        child.added_in_connections_   = []+parent.in_connections_
        child.added_out_connections_ = []+parent.out_connections_
        for ic in child.added_in_connections_: 
          child.in_connections_.append(ic)    
        for oc in child.added_out_connections_: 
          child.out_connections_.append(oc)
        # now add the Cardinalities to the list in the child...
        for card in parent.cardinality.getValue():
           child_card = card.clone()
           child.cardinality.newItem(child_card)
           child.addedCardinalities.append(child_card)
  
        # now add the Cardinalities to the list in the in and out connections...
        for ic in parent.in_connections_:
           if ic.getTypeName() == Magic().associationClassName:
              cloneCardinality(ic, parent, child, 0)
        for oc in parent.out_connections_:
           if oc.getTypeName() == Magic().associationClassName:
              cloneCardinality(oc, parent, child, 1)
        inheritance_rel.remove (inh)    ## remove the relationship from the list
  
    
  
def addConstraintMinIn (assoc):
    """
    Author?
    """
    constr = assoc.Constraints.getValue()
    for con in constr:
        if con.getValue()[0] == "minCardinality_In_INH": 
          return
    const = ATOM3Constraint()
    const.setValue(("minCardinality_In_INH", 1, (None, 1), 
                    (None, [0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0]), 
                    "    if len(self.in_connections_)>1: "
                    + "return ('Too much source objects', self)\n"))
    constr.append(const)
    #assoc.Constraints.setValue(constr)



def addConstraintMinOut (assoc):
    """
    Author?
    """
    constr = assoc.Constraints.getValue()    
    for con in constr:
        if con.getValue()[0] == "minCardinality_Out_INH": 
          return
    const = ATOM3Constraint()
    const.setValue(("minCardinality_Out_INH", 1, (None, 1), 
                    (None, [0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0]), 
                    "    if len(self.out_connections_)>1: "
                    + "return ('Too much target objects', self)\n"))
    constr.append(const)
    #assoc.Constraints.setValue(constr)    



def cloneCardinality ( assoc, parent, child, dir ):
    """
    Author?
    """
    for elem in assoc.cardinality.getValue():
        name, dire, min, max = elem.getValue()
        if name == parent.keyword_.toString() and dir == dire[1]:
            if min == '1' and max == '1':
                elem.setValue((name, dire, '0', '1'))
                if dire == 0: 
                  addConstraintMinOut (assoc)
                else: 
                  addConstraintMinIn (assoc)
            newElem = ATOM3Connection( child, min, max )
            # as we can have more than one child, we are not
            # sure whether we should restrict to exactly one
            # that is, it is ONE among all the children
            newElem.setValue(( child, dire, '0', max ))     
                                                            
            assoc.cardinality.newItem(newElem)
            if dir == 0:
                if "added_out_connections_" in assoc.__dict__.keys():
                    assoc.added_out_connections_.append(child)
                else:
                    assoc.added_out_connections_ = [child]
            else:
                if "added_in_connections_" in assoc.__dict__.keys():
                    assoc.added_in_connections_.append(child)
                else:
                    assoc.added_in_connections_ = [child]
            if "addedCardinalities" in assoc.__dict__.keys():
                assoc.addedCardinalities.append(newElem)
            else: assoc.addedCardinalities = [newElem]
            return 



def hasAttribute (classInstance, attrName):
    """
    Author?
    Returns:
      True if classInstance has an attribute called attrName
    """
    for attr in classInstance.attributes.getValue():
        if attr.getValue()[0] == attrName: 
          return 1
    return 0



def hasCardinality(classInstance, card):
    """
    Author?
    Returns:
      True if classInstance has a cardinality like card
    """
    for c in classInstance.cardinality.getValue():
        if c.hasEqualValue(card) : 
          return 1
    return 0

