import nodes, compiler, random

from pytcore.core.himesis import HConstants as HC
from pytcore.rules.arule import ARule
from pytcore.tcore.messages import Packet

class LeftHandSide(nodes.Graph):
    def __init__(self, objectID, areaID, name, editable = True):
        nodes.Graph.__init__(self, objectID, areaID, name, editable)
        self.condition = ''
        
    def setCondition(self, condition):
        self.condition = condition
        
    def getCondition(self):
        return self.condition
        
class RightHandSide(nodes.Graph):
    def __init__(self, objectID, areaID, name, editable = True):
        nodes.Graph.__init__(self, objectID, areaID, name, editable)
        self.action = ''
        
    def setAction(self, action):
        self.action = action
        
    def getAction(self):
        return self.action

class GraphGrammar:
    def __init__(self, compiler):
        random.seed(1234)
        self.compiler = compiler
        self.rules = {}
        self.compiledRules = {}
        self.precedences = []
        self.hGraph = None
        self.graph = None
        self.objectFactory = nodes.ObjectFactory()
        self.relationshipFactory = nodes.RelationshipFactory()
        
    def addRule(self, rule):
        if rule.precedence in self.rules:
            self.rules[rule.precedence].append(rule)
        else:
            self.rules[rule.precedence] = [rule]
            self.precedences.append(rule.precedence)
            
    def setGraph(self, graph):
        self.graph = graph
        self.hGraph = self.compiler.compileModel(graph)
        
    def compileRules(self):
        for precedence, rules in self.rules.iteritems():
            self.compiledRules[precedence] = []
            for rule in rules:
                self.compiledRules[precedence].append(self.compiler.compileRule(rule))
                    
        self.precedences.sort()
            
    def executeContinously(self):
        ''' print self.hGraph, '\n\n'
        for v in self.hGraph.vs:
            print 'NODE ', v[HC.FULLTYPE], ' ', v.index
            for name, value in v.attributes().iteritems():
                print name, ':', value
            print '\n\n'            
        for e in self.hGraph.es:
            print 'EDGE'
            print e.source, ' ', e.target, '\n\n' '''
        if self.compiledRules == {}:
            self.compileRules()
            
        somethingHappened = True
        while (somethingHappened):
            somethingHappened = self.step()
            
    def step(self):
        def handleChanges(deltas):
            def cmpOPs(x, y):
                node = None
                if 'guid' in x:
                    node = self.hGraph.vs[self.hGraph.get_node(x['guid'])]
                elif 'guid' in y:
                    node = self.hGraph.vs[self.hGraph.get_node(y['guid'])]
                if x['op'] == y['op']:
                    return 0
                elif x['op'] == 'MKNODE' and node[HC.FULLTYPE] not in self.compiler._connectorTypes:
                    return -1
                elif y['op'] == 'MKNODE' and node[HC.FULLTYPE] not in self.compiler._connectorTypes:
                    return 1
                elif x['op'] == 'MKNODE':
                    return -1
                elif y['op'] == 'MKNODE':
                    return 1
                elif x['op'] == 'MKEDGE':
                    return -1
                elif y['op'] == 'MKEDGE':
                    return 1
                else:
                    return 0
        
            deltas.sort(cmp = lambda x, y: cmpOPs(x, y))
            
            ''' print deltas '''
        
            createRels = {}
            createdNodes = {}
            dirtyNodes = []
            movedNodes = []
        
            ''' First for-loop: create objects and set attributes. Second for-loop: display objects. Third for-loop: update properties '''
            for delta in deltas:
                if delta['op'] == 'CHATTR':
                    # print 'CHANGING ATTRIBUTE'
                    node = self.hGraph.vs[self.hGraph.get_node(delta['guid'])]
                    objectID = int(node['$objectID'])
                    gNode = self.graph.nodesByID[objectID]
                    gNode.setProperty(delta['attr'], delta['new_val'])
                    dirtyNodes.append(gNode)
                elif delta['op'] == 'MKNODE':
                    # print 'MAKING NODE'
                    node = self.hGraph.vs[self.hGraph.get_node(delta['guid'])]
                    if node[HC.FULLTYPE] in self.compiler._connectorTypes:
                        createRels[delta['guid']] = (node[HC.FULLTYPE], -1)
                    else:
                        newNode = self.objectFactory.createObject(self.graph, node[HC.FULLTYPE])
                        createdNodes[delta['guid']] = newNode
                        node['$objectID'] = newNode.objectID
                        node['$areaID'] = newNode.areaID
                        
                elif delta['op'] == 'MKEDGE':
                    # print 'MAKING EDGE'
                    relGUID = -1
                    objGUID1 = -1
                    if delta['guid1'] in createRels:
                        relGUID = delta['guid1']
                        objGUID1 = delta['guid2']
                    else:
                        relGUID = delta['guid2']
                        objGUID1 = delta['guid1']
                        
                    className, objGUID2 = createRels[relGUID]
                    if objGUID2 == -1:
                        createRels[relGUID] = (className, objGUID1)
                    else:
                        # print graph.relationTypes
                        node1 = None
                        node2 = None
                        gNode1 = None
                        Node2 = None
                        if objGUID1 in createdNodes:
                            gNode1 = createdNodes[objGUID1]
                        else:
                            node1 = self.hGraph.vs[self.hGraph.get_node(objGUID1)]
                            gNode1 = self.graph.nodesByID[int(node1['$objectID'])]
                        if objGUID2 in createdNodes:
                            gNode2 = createdNodes[objGUID2]
                        else:
                            node2 = self.hGraph.vs[self.hGraph.get_node(objGUID2)]
                            gNode2 = self.graph.nodesByID[int(node2['$objectID'])]
                        fromRole = None
                        toRole = None
                        if gNode1.className == gNode2.className:
                            fromRole, toRole = self.graph.relationTypes[className][gNode1.className]
                        else:
                            fromRole = self.graph.relationTypes[className][gNode1.className]
                            toRole = self.graph.relationTypes[className][gNode2.className]
                        newRel = self.relationshipFactory.createRelationship(self.graph, className, fromRole, toRole, gNode1, gNode2)
                        createdNodes[relGUID] = newRel
                        node = self.hGraph.vs[self.hGraph.get_node(relGUID)]
                        node['$objectID'] = newRel.objectID
                        node['$areaID'] = newRel.areaID
                        movedNodes.append(gNode2)
                        
                elif delta['op'] == 'RMEDGE':
                    pass
                    
                elif delta['op'] == 'RMNODE':
                    # print 'REMOVING NODE'
                    objectID = int(delta['attrs']['$objectID'])
                    if objectID in self.graph.nodesByID:
                        gNode = self.graph.nodesByID[objectID]
                        gNode.remove()
                    
            ''' This is actually only valid for ProductionSystem '''
            for node in [x for x in createdNodes.itervalues() if isinstance(x, nodes.ObjectNode)]:
                rel = node.getRelations()[0]
                cObj = rel.getObjects()[0] if rel.getObjects()[0].objectID != node.objectID else rel.getObjects()[1]
                place = cObj.getPlace()
                node.addToGraph(place[0], str(int(place[1]) - 30))
            for node in [x for x in createdNodes.itervalues() if isinstance(x, nodes.RelationshipNode)]:
                obj = node.getObjects()[0]
                place = obj.getPlace()
                node.addToGraph(place[0], str(int(place[1]) - 30))
            for node in [x for x in movedNodes if x not in createdNodes.itervalues() and x.className != 'MachineOperator']:
                rel = node.getRelations()[0]
                cObj = rel.getObjects()[0] if rel.getObjects()[0].objectID != node.objectID else rel.getObjects()[1]
                place = cObj.getPlace()
                node.moveTo(place[0], str(int(place[1]) - 30))

            for node in dirtyNodes:
                node.updateProperties()
        
        
        if self.compiledRules == {}:
            self.compileRules()
        somethingHappened = False
        for precedence in self.precedences:
            compiledRules = self.compiledRules[precedence]
            executed = True
            while executed:
                executed = False
                for compiledRule in random.sample(compiledRules, len(compiledRules)):
                    print 'Executing rule ', compiledRule['name']
                    '''print '---------LHS----------\n\n', compiledRule['lhs'], '\n\n'
                    for v in compiledRule['lhs'].vs:
                        print 'NODE ', v[HC.FULLTYPE], ' ', v.index
                        for name, value in v.attributes().iteritems():
                            print name, ':', value
                        print '\n\n'
                    for e in compiledRule['lhs'].es:
                        print 'EDGE'
                        print e.source, ' ', e.target, '\n\n'
                        
                    print '---------RHS----------\n\n', compiledRule['rhs'], '\n\n'
                    for v in compiledRule['rhs'].vs:
                        print 'NODE ', v[HC.FULLTYPE], ' ', v.index
                        for name, value in v.attributes().iteritems():
                            print name, ':', value
                        print '\n\n'
                    for e in compiledRule['rhs'].es:
                        print 'EDGE'
                        print e.source, ' ', e.target, '\n\n
                        
                    print '---------NAC----------\n\n', compiledRule['lhs'].NACs[0], '\n\n'
                    for v in compiledRule['lhs'].NACs[0].vs:
                        print 'NODE ', v[HC.FULLTYPE], ' ', v.index
                        for name, value in v.attributes().iteritems():
                            print name, ':', value
                        print '\n\n'
                    for e in compiledRule['lhs'].NACs[0].es:
                        print 'EDGE'
                        print e.source, ' ', e.target, '\n\n'''
                                            
                    ar = ARule(compiledRule['lhs'], compiledRule['rhs'])
                    packet = ar.packet_in( Packet(self.hGraph) )
                    if ar.is_success :
                        somethingHappened = True
                        executed = True
                        print 'SUCESS\n'
                        handleChanges(packet.deltas)
                    elif not ar.is_success :
                        if ar.exception :
                            ''' print 'FAILED', ar.exception '''
                        else :
                            ''' print 'NO SUCCESS' '''
        
        
        self.graph.refreshDisplay()
        return somethingHappened
        
class Rule:
    def __init__(self, name, precedence):
        self.name = name
        self.precedence = precedence
        self.lhs = None
        self.rhs = None
        self.nacs = []
    
    def setLHS(self, lhs):
        self.lhs = lhs
        
    def setRHS(self, rhs):
        self.rhs = rhs
        
    def addNAC(self, nac):
        self.nacs.append(nac)