from suds.client import Client
import logging
import threading

url = 'file:///C://metaedit_semantics//MetaEditAPI.wsdl'
client = Client(url, location='http://127.0.0.1:6390/MetaEditAPI')

logging.basicConfig(level=logging.INFO)
# logging.getLogger('suds.client').setLevel(logging.DEBUG)

class NodeRepresentation:
    def __init__(self, objectID, areaID):
        self.objectID = objectID
        self.areaID = areaID
        self.x = None
        self.y = None
        
    def remove(self):
        rep = client.factory.create('ns0:MEOop')
        rep.areaID = self.areaID
        rep.objectID = self.objectID
        client.service.remove(rep)
        
    def moveTo(self, x, y):
        self.x = x
        self.y = y
        rep = client.factory.create('ns0:MEOop')
        rep.areaID = self.areaID
        rep.objectID = self.objectID
        place = client.factory.create('ns0:MEAny')
        place.meType = 'Point'
        place.meValue = x + ',' + y
        client.service.setPlace(rep, place)
        
    def getPlace(self):
        if self.x == None or self.y == None:
            rep = client.factory.create('ns0:MEOop')
            rep.areaID = self.areaID
            rep.objectID = self.objectID
            place = client.service.place(rep)
            coords = place.meValue.replace('\'', '').split(',')
            self.x = coords[0]
            self.y = coords[1]
            
        return self.x, self.y

class Node:
    def __init__(self, className, objectID, areaID, parent):
        self.className = className
        self.objectID = objectID
        self.areaID = areaID
        self.parent = parent
        self.propertyMEOops = None
        self.propertyValues = None
        self.propertyValues = []
        self.propertyNames = []
        self.dirty = []
        
    def getRepresentation(self):
        return self.parent.representations[self.objectID]
        
    def setRepresentation(self, representation):
        self.parent.representations[self.objectID] = representation
        
    def remove(self):
        self.getRepresentation().remove()
        self.parent.removeNode(self)
        
    def getPlace(self):
        return self.getRepresentation().getPlace()
        
    def moveTo(self, x, y):
        self.getRepresentation().moveTo(x, y)
        
    def addProperty(self, name, value):
        self.propertyValues.append(value)
        self.propertyNames.append(name)
        
    def setProperty(self, name, value):
        if name not in self.propertyNames:
            self.propertyValues.append(value)
            self.propertyNames.append(name)
        self.propertyValues[self.propertyNames.index(name)] = value
        self.dirty.append(name)
        
    def delProperty(self, name):
        del self.propertyValues[self.propertyNames.index(name)]
        del self.propertyNames[self.propertyNames.index(name)]
        if name in self.dirty:
            del self.dirty[self.dirty.index(name)]
        
    def getPropertyNames(self):
        return self.propertyNames
            
    def getProperty(self, name):
        return self.propertyValues[self.propertyNames.index(name)]
        
    def updateProperties(self):
        object = client.factory.create('ns0:MEOop')
        object.areaID = self.areaID
        object.objectID = self.objectID
        for dirtyProperty in self.dirty:
            idx = self.propertyNames.index(dirtyProperty)
            value = client.factory.create('ns0:MEAny')
            value.meType = 'Number'
            value.meValue = self.propertyValues[idx]
            client.service.setValueAt(object, idx + 1, value)
            
        del self.dirty[:]
        
class RelationshipNode(Node):
    def __init__(self, className, objectID, areaID, parent):
        Node.__init__(self, className, objectID, areaID, parent)
        self.objects = None
        self.initObjectIDs = None
        self.binding = None
        
    def addToGraph(self, x, y):
        place = client.factory.create('ns0:MEAny')
        place.meType = 'Point'
        place.meValue = x + ',' + y
        rep = client.service.addNewBindingRepFor(self.parent.diagramMEOop, self.binding, 1, place)
        rep.x = x
        rep.y = y
        self.setRepresentation(NodeRepresentation(rep.objectID, rep.areaID))
        
    def getObjects(self):
        if self.objects == None:
            if self.initObjectIDs == None:
                relation = client.factory.create('ns0:MEOop')
                relation.areaID = self.areaID
                relation.objectID = self.objectID
                restrictedType = client.factory.create('ns0:METype')
                restrictedType.name = 'NonProperty'
                objectMEOops = client.service.objsForRel(self.parent.MEOop, relation, restrictedType)
                self.objects = []
                for objectMEOop in objectMEOops:
                    self.objects.append(self.parent.nodesByID[objectMEOop.objectID])
            else:
                self.objects = []
                for initObjectID in self.initObjectIDs:
                    self.objects.append(self.parent.nodesByID[initObjectID])
                self.initObjectIDs = None
                
        return self.objects
        
    def remove(self):
        for object in self.getObjects():
            object.removeRelation(self)
        Node.remove(self)

class ObjectNode(Node):
    def __init__(self, className, objectID, areaID, parent):
        Node.__init__(self, className, objectID, areaID, parent)        
        self.relations = None
        self.initRelationshipIDs = None
       
    def getRelations(self):
        if self.relations == None:
            if self.initRelationshipIDs == None:
                object = client.factory.create('ns0:MEOop')
                object.areaID = self.areaID
                object.objectID = self.objectID
                restrictedType = client.factory.create('ns0:METype')
                restrictedType.name = 'NonProperty'
                relMEOops = client.service.relsForObj(self.parent.MEOop, object, restrictedType)
                self.relations = []
                for relMEOop in relMEOops:
                    self.relations.append(self.parent.nodesByID[relMEOop.objectID])
            else:
                self.relations = []
                for initRelationshipID in self.initRelationshipIDs:
                    self.relations.append(self.parent.nodesByID[initRelationshipID])
                self.initRelationshipIDs = None
        
        return self.relations
        
    def addInitRelationshipID(self, initRelationshipID):
        if self.initRelationshipIDs == None:
            self.initRelationshipIDs = [initRelationshipID]
        else:
            self.initRelationshipIDs.append(initRelationshipID)
        
    def removeRelation(self, relation):
        self.getRelations().remove(relation)
        
    def addRelation(self, relation):
        self.getRelations().append(relation)
        
    def addToGraph(self, x, y):
        place = client.factory.create('ns0:MEAny')
        place.meType = 'Point'
        place.meValue = x + ',' + y
        object = client.factory.create('ns0:MEOop')
        object.areaID = self.areaID
        object.objectID = self.objectID
        rep = client.service.addNewObjectRepFor(self.parent.diagramMEOop, object, 1, place)
        rep.x = x
        rep.y = y
        self.setRepresentation(NodeRepresentation(rep.objectID, rep.areaID))
        
    def remove(self):
        for rel in self.getRelations():
            rel.remove()
        Node.remove(self)
        
class RelationshipFactory:
    def createRelationship(self, graph, type, fromRole, toRole, fromObj, toObj):
        relationType = client.factory.create('ns0:METype')
        relationType.name = type
        role0 = client.factory.create('ns0:METype')
        role0.name = fromRole
        role1 = client.factory.create('ns0:METype')
        role1.name = toRole
        obj0 = client.factory.create('ns0:MEOop')
        obj0.areaID = fromObj.areaID
        obj0.objectID = fromObj.objectID
        obj1 = client.factory.create('ns0:MEOop')
        obj1.areaID = toObj.areaID
        obj1.objectID = toObj.objectID
        binding = client.service.createBinding(graph.MEOop, relationType, [role0, role1], [obj0, obj1])
        relationship = client.service.relationship(binding)
        relationshipNode = RelationshipNode(type, relationship.objectID, relationship.areaID, graph)
        relationshipNode.binding = binding
        graph.addNode(relationshipNode)
        fromObj.addRelation(relationshipNode)
        toObj.addRelation(relationshipNode)
        relationshipNode.objects = [fromObj, toObj]
        # print 'Created node with ID ', relationshipNode.objectID
        return relationshipNode

class ObjectFactory:
    def createObject(self, graph, type):
        objectType = client.factory.create('ns0:METype')
        objectType.name = type
        object = client.service.unsafeNew(objectType)
        client.service.addToGraph(object, graph.MEOop)
        objectNode = ObjectNode(type, object.objectID, object.areaID, graph)
        objectNode.initRelationshipIDs = []
        graph.addNode(objectNode)
        # print 'Created node with ID ', objectNode.objectID
        return objectNode
'''  
class AssignBindingRep(threading.Thread):
    def __init__(self, bindingRep, graph):
        threading.Thread.__init__(self)
        self.graph = graph
        self.bindingRep = bindingRep
        self.client = Client(url)
    
    def run(self):
        binding = self.client.service.inst(self.bindingRep)
        relationship = self.client.service.relationship(binding)
        self.graph.representations[relationship.objectID] = NodeRepresentation(self.bindingRep.objectID, self.bindingRep.areaID)
        
class AssignObjectRep(threading.Thread):
    def __init__(self, objectRep, graph):
        threading.Thread.__init__(self)
        self.graph = graph
        self.objectRep = objectRep
        self.client = Client(url)
    
    def run(self):
        object = self.client.service.inst(self.objectRep)
        self.graph.representations[object.objectID] = NodeRepresentation(self.objectRep.objectID, self.objectRep.areaID)
'''
        
class Graph:
    def __init__(self, objectID, areaID, name, editable = True):
        if editable:
            self.MEOop = client.factory.create('ns0:MEOop')
            self.MEOop.areaID = areaID
            self.MEOop.objectID = objectID
            self.diagramMEOop = client.service.diagrams(self.MEOop)[0]
    
        self.name = name
        self.nodesByType = {}
        self.nodesByID = {}
        self.relationTypes = {}
        
        self.representations = {}
        
        if editable:
            self.searchRepresentations()
        
        self.editable = editable

    def addRelationType(self, relationType, fromClasses, toClasses, fromRole, toRole):
        val = {}
        for fromClass in fromClasses:
            val[fromClass] = fromRole
        for toClass in toClasses:
            if toClass in val:
                val[toClass] = (val[toClass], toRole)
            else:
                val[toClass] = toRole
        self.relationTypes[relationType] = val
            
    def searchRepresentations(self):
        bindingReprs = client.service.bindingReprs(self.diagramMEOop)
        for bindingRep in bindingReprs:
            binding = client.service.inst(bindingRep)
            relationship = client.service.relationship(binding)
            self.representations[relationship.objectID] = NodeRepresentation(bindingRep.objectID, bindingRep.areaID)
        
        objectReprs = client.service.objectReprs(self.diagramMEOop)
        for objectRep in objectReprs:
            object = client.service.inst(objectRep)
            self.representations[object.objectID] = NodeRepresentation(objectRep.objectID, objectRep.areaID)
    
    def addNode(self, node):
        self.nodesByID[node.objectID] = node
        if (not (node.className in self.nodesByType)):
            self.nodesByType[node.className] = [node]
        else:
            self.nodesByType[node.className].append(node)
            
    def getNodesByTypes(self, *types):
        total = set()
        for type in types:
            if type in self.nodesByType:               
                total = total | set(self.nodesByType[type])
        return list(total)
            
    def removeNode(self, node):
        del self.nodesByID[node.objectID]
        self.nodesByType[node.className].remove(node)
        
    def refreshDisplay(self):
        if self.editable:
            client.service.refresh(self.diagramMEOop)