
from ..util.infinity import INFINITY
from arule import ARule


class FRule(ARule):
    '''
        Applies the transformation on all matches found.
    '''
    def __init__(self, LHS, RHS, ignore_resolver=False, external_matches_only=False,
                 custom_resolution=lambda packet: False, max_iterations=INFINITY):
        '''
            Applies the transformation on all matches found.
            @param LHS: The pre-condition pattern (LHS + NACs).
            @param RHS: The post-condition pattern (RHS).
            @param ignore_resolver: Specifies whether or not a resolver is needed.
            @param external_matches_only: Resolve conflicts ignoring the matches found in this FRule.
            @param custom_resolution: Override the default resolution function.
            @param max_iterations: The maximum number of times to apply the rule.
        '''
        super(FRule, self).__init__(LHS, RHS, ignore_resolver, external_matches_only, custom_resolution)
        # Matcher needs to find many matches
        self.M.max = max_iterations
        self.I.max_iterations = max_iterations
    
    def packet_in(self, packet):
        self.exception = None
        self.is_success = False
        # Match
        packet = self.M.packet_in(packet)
        if not self.M.is_success:
            self.exception = self.M.exception
            return packet
        # Choose the first match
        packet = self.I.packet_in(packet)
        if not self.I.is_success:
            self.exception = self.I.exception
            return packet
        while True:
            # Rewrite
            packet = self.W.packet_in(packet)
            if not self.W.is_success:
                self.exception = self.W.exception
                return packet
            # Choose another match
            packet = self.I.next_in(packet)
            # No more iterations are left
            if not self.I.is_success:
                if self.I.exception:
                    self.exception = self.I.exception
                else:
                    # Output success packet
                    self.is_success = True
                return packet
