import nodes, re, uuid, random, copy

from pytcore.core.himesis import Himesis, HConstants as HC
from pytcore.core.himesis import HimesisPreConditionPatternLHS
from pytcore.core.himesis import HimesisPreConditionPatternNAC
from pytcore.core.himesis import HimesisPostConditionPattern

class DesignerAPI:
    def configure(self, graph, type, pl2gi, ex, pLabel=None, attr=None):
        self._graph 	= graph
        self.graph      = graph
        self._type	 	= type
        self._pl2gi		= pl2gi
        self._ex        = ex
        self._pLabel 	= pLabel
        self._attr	    = attr
        
        ''' matched = self._pl2gi.values()
        for v in self._graph.vs :
            if v.index not in matched :
                self._pl2gi[v[HC.MT_LABEL]] = v.index '''
        
    def __raise(self,msg) :
		self._ex['$err'] = msg
		raise RuntimeError(msg)
        
    def getAttr(self, attr = None, pLabel=None):
        ''' print 'GETTING ATTR ', attr, ' FOR ', pLabel '''
        if pLabel == None:
            pLabel = self._pLabel
        if attr == None :
            if not self._type.startswith('attr'):
                print 'getAttr() can only be called without parameters in attribute conditions/actions'
                self.__raise(\
                    'getAttr() can only be called without parameters' + \
                    'in attribute conditions/actions')
            attr = self._attr

        n = self._graph.vs[self._pl2gi[pLabel]]
        if attr not in n.attribute_names() :
            print 'invalid getAttr() attribute :: ' + str(attr)
            self.__raise('invalid getAttr() attribute :: ' + str(attr))
        ''' print 'Attribute ', attr, ' = ', n[attr] '''
        return n[attr]
        
    def setAttr(self, attr, val, pLabel):
		if self._type != 'patternAction' :
			self.__raise('setAttr() can only be used within RHS actions')
		elif pLabel == None :
			self.__raise('setAttr() requires a valid __pLabel')
		elif pLabel not in self._pl2gi :
			self.__raise(\
				'invalid setAttr() __pLabel :: ' + pLabel + ' (either no node ' +\
				'with that __pLabel exists, or none is matched yet)')

		n = self._graph.vs[self._pl2gi[pLabel]]
		if attr not in n.attribute_names() :
			self.__raise('invalid setAttr() attribute :: '+attr)
		oldVal = n[attr]
		if oldVal != val :
			n[attr] = val
			self._journal.append(
								{'op': 'CHATTR',
			  					 'guid': n[HC.GUID],
								 'attr': attr,
								 'old_val': oldVal,
								 'new_val': val}
                                )
			n[HC.MT_DIRTY] = True
        

class ModelAndRuleCompiler:
    def __init__(self, subtypes = {}, connectorTypes = []):
        self._subtypes 		    = subtypes
        self._connectorTypes    = connectorTypes
        self._compiledRules     = {}
        self._dAPI              = DesignerAPI()
        
    def addNode(self, graph, node):
        newNodeIdx = graph.add_node(node.className, node.className in self._connectorTypes)
        graph.vs[newNodeIdx]['$objectID'] = str(node.objectID)
        graph.vs[newNodeIdx]['$areaID'] = str(node.areaID)
        graph.vs[newNodeIdx][HC.FULLTYPE] = str(node.className)
        for propName in node.getPropertyNames():
            matches = re.match('(.*)_(LHS|RHS|GG)', propName)            
            graph.vs[newNodeIdx][matches.group(1) if matches != None else propName] = node.getProperty(propName)
            
        return newNodeIdx
        
    def compileModel(self, model, name = None, himesisBaseClass = Himesis):
        graph = himesisBaseClass(name)        
        graph[HC.GUID] = uuid.uuid4()
        
        graphToHimesisIndices = {}
        for id, node in model.nodesByID.iteritems():
            graphToHimesisIndices[id] = self.addNode(graph, node)
        
        for id, node in model.nodesByID.iteritems():                   
            if isinstance(node, nodes.RelationshipNode):
                for obj in node.getObjects():
                    graph.add_edges((graphToHimesisIndices[id], graphToHimesisIndices[obj.objectID]))
                    
        return graph
        
    def compileRule(self, rule):
        def compilePattern(patterns, patternType, himesisBaseClass):
            def wrapAttributeDesignerCode(graph, type):
                def wrap(code, pLabel, attr) :
                    def evalAttrCode(pLabel2graphIndexMap, graph):
                        if code == '':
                            if type == 'attrCondition':
                                return True
                            else:
                                return
                        ex = {}
                        self._dAPI.configure(
                                            graph,
                                            type,
                                            pLabel2graphIndexMap,
                                            ex,
                                            pLabel,
                                            attr
                                            )
                        try:
                            _code = code.replace('getAttr', 'self._dAPI.getAttr')
                            result = eval(_code)
                            ''' print 'Returning ', result, ' of code ', _code, 'for attribute ', attr '''
                            return result
                        except Exception as e :
                            if '$err' in ex :
                                raise RuntimeError(ex['$err'])
                            else :
                                raise RuntimeError(\
                                            'unexpected error encountered while evaluating '+
                                            type+' :: '+str(e))
                    return evalAttrCode

                for v in graph.vs :
                    for attr, code in v.attributes().iteritems() :
                        if Himesis.is_RAM_attribute(attr) and code != None :
                            v[attr] = wrap(code, v[HC.MT_LABEL], attr)
                            
            def wrapPatternConditionDesignerCode(graph):
                def wrap(code):
                    def evalPatternCode(pLabel2graphIndexMap, graph):
                        if code == '' :
                            return True
                        ex = {}
                        self._dAPI.configure(
                                            graph,
                                            'patternCondition',
                                            pLabel2graphIndexMap,
                                            ex
                                            )
                        try :
                            _code = code.replace('getAttr', 'self._dAPI.getAttr')
                            result = eval(_code)
                            return result
                        except Exception as e:
                            if '$err' in ex:
                                raise RuntimeError(ex['$err'])
                            else:
                                raise RuntimeError(\
                                            'unexpected error encountered while evaluating ' +
                                            'pattern condition code :: ' + str(e))
                                        
                    return evalPatternCode
                    
                graph[HC.MT_CONSTRAINT] = wrap(graph[HC.MT_CONSTRAINT])
                
            def wrapPatternActionDesignerCode(graph) :
                def wrap(code) :
                    def evalPatternCode(pLabel2graphIndexMap, graph):
                        if code == '' :
                            return []
                        journal = []
                        ex = {}
                        self._dAPI.configure(
                                            graph,
                                            'patternAction',
                                            pLabel2graphIndexMap,
                                            ex,
                                            journal=journal
                                            )
                        try :
                            _code = code.replace('getAttr', 'self._dAPI.getAttr').replace('setAttr', 'self._dAPI.setAttr')
                            eval(_code)
                            return journal
                        except Exception as e:
                            if '$err' in ex:
                                raise RuntimeError(ex['$err'])
                            else :
                                raise RuntimeError(\
                                            'unexpected error encountered while evaluating ' +
                                            'pattern action code :: ' + str(e))
                    return evalPatternCode

                graph[HC.MT_ACTION] = wrap(graph[HC.MT_ACTION])
        
            graphs = []
            for pattern in patterns:
                for id, node in pattern.nodesByID.iteritems():                    
                    matches = re.match('(.*)_(LHS|RHS|GG)', node.className)
                    node.className = matches.group(1)
                    node.setProperty(HC.MT_LABEL, node.getProperty('GG_Label'))
                    node.delProperty('GG_Label')
                    node.setProperty(HC.MT_SUBTYPE_MATCH, 1)
                    
                graph = self.compileModel(pattern, name = rule.name + '_' + patternType, himesisBaseClass = himesisBaseClass)
                
                if patternType == 'LHS' or patternType == 'NAC':
                    graph[HC.MT_CONSTRAINT] = pattern.getCondition()
                    wrapPatternConditionDesignerCode(graph)
                    wrapAttributeDesignerCode(graph, 'attrCondition')
                    for v in graph.vs :
						v[HC.MT_DIRTY] = False
						v[HC.MT_SUBTYPES] = self._subtypes[v[HC.FULLTYPE]] if v[HC.FULLTYPE] in self._subtypes else []
                
                elif patternType == 'RHS':
                    graph[HC.MT_ACTION] = pattern.getAction()
                    wrapPatternActionDesignerCode(graph)
                    wrapAttributeDesignerCode(graph, 'attrAction')
                
                graph[HC.METAMODELS] = []
                graph[HC.MISSING_METAMODELS] = lambda: []
                
                graphs.append(graph)
                
                return graphs
        
        nacs = compilePattern(rule.nacs, 'NAC', HimesisPreConditionPatternNAC) if rule.nacs else None
        lhs = compilePattern([rule.lhs], 'LHS', HimesisPreConditionPatternLHS)[0]
        rhs = compilePattern([rule.rhs], 'RHS', HimesisPostConditionPattern)[0]
        
        if nacs != None:
            lhs.NACs = nacs
            for nac in nacs:
                nac.LHS = lhs
                try:
                    nac.bridge = nac.compute_bridge()
                except Exception as e:
                    print e
        rhs.pre = lhs
        if lhs.vcount() > 0:
            rhs.pre_labels = lhs.vs[HC.MT_LABEL]
        else:
            rhs.pre_labels = []
            
        self._compiledRules[rule.name] = {'name': rule.name, 'lhs': lhs, 'rhs': rhs}
        
        return self._compiledRules[rule.name]