import nodes
import random

class Simulator:
    def __init__(self, graph):
        self.graph = graph
        self.relationshipFactory = nodes.RelationshipFactory()
        self.objectFactory = nodes.ObjectFactory()
        
        machineOperators = graph.nodesByType['MachineOperator']
        for machineOperator in machineOperators:
            relations = machineOperator.getRelations()
            for relation in relations:
                if relation.className == 'MachineOperatorToProcessor':
                    objects = relation.getObjects()
                    for object in objects:
                        if object.className != "MachineOperator":
                            machineOperator.history = [object]
                            break
                    break

    def simulate(self):
        while True:
            print '=============STEP==============\n'
                
            sinks = self.graph.nodesByType['Sink']
            for sink in sinks:
                self.sinkItem(sink)
                
            machineOperators = self.graph.nodesByType['MachineOperator']
            for machineOperator in machineOperators:
                self.moveMachineOperator(machineOperator)
                
            repairMachines = self.graph.nodesByType['RepairMachine']
            for repairMachine in repairMachines:
                self.repair(repairMachine)
                
            qualityControls = self.graph.nodesByType['QualityControl']
            for qualityControl in qualityControls:
                self.control(qualityControl)
                
            assemblers = self.graph.nodesByType['Assembler']
            for assembler in assemblers:
                self.assemble(assembler)
                
            items = self.graph.getNodesByTypes('Body', 'Wheel', 'Tracks', 'WaterCannon', 'MachineGun', 'WarAPC', 'RiotAPC')
            for item in items:
                self.moveItem(item)
                
            generators = self.graph.nodesByType['Generator']
            for generator in generators:
                self.generateItem(generator)
                            
            self.graph.refreshDisplay()
            
    def getOperator(self, processor):
        relationships = processor.getRelations()
        for relationship in relationships:
            if relationship.className == 'MachineOperatorToProcessor':
                for obj in relationship.getObjects():
                    if obj.className == 'MachineOperator':  
                        return obj
                
        return None
        
    def getItem(self, conveyorBelt):
        relationships = conveyorBelt.getRelations()
        for relationship in relationships:
            if relationship.className == 'PartToConveyorBelt' or relationship.className == 'FinishedProductToConveyorBelt':
                for obj in relationship.getObjects():
                    if obj.className in ['WarAPC', 'RiotAPC', 'Body', 'Wheel', 'Tracks', 'WaterCannon', 'MachineGun']:  
                        return obj
                
        return None
        
    def getConveyorBelt(self, item):
        relationships = item.getRelations()
        for relationship in relationships:
            if relationship.className == 'PartToConveyorBelt' or relationship.className == 'FinishedProductToConveyorBelt':
                for obj in relationship.getObjects():
                    if obj.className == 'ConveyorBelt':
                        return obj, relationship
                
        return None, None
        
    def getPrevConveyorBelt(self, conveyorBelt):
        relationships = conveyorBelt.getRelations()
        for relationship in relationships:
            if relationship.className == 'ConveyorBeltToConveyorBelt':
                for obj in relationship.getObjects():
                    if obj.objectID != conveyorBelt.objectID and obj.getProperty('order') < conveyorBelt.getProperty('order'):
                        return obj
                        
        return None
            
    def moveMachineOperator(self, machineOperator):
        processors = self.graph.getNodesByTypes('QualityControl', 'Assembler', 'RepairMachine')
        
        if len(machineOperator.history) == len(processors):
            machineOperator.history = []
            
        possibleProcessors = [processor for processor in processors if processor not in machineOperator.history and self.getOperator(processor) == None]
        random.shuffle(possibleProcessors)
        nextProcessor = possibleProcessors[0]
            
        machineOperator.history.append(nextProcessor)
        
        operatorRelations = machineOperator.getRelations()
        currRelation = None
        for relation in operatorRelations:
            if relation.className == 'MachineOperatorToProcessor':
                currRelation = relation
                break
        
        currPlace = currRelation.getPlace()
        currRelation.remove()
        rel = self.relationshipFactory.createRelationship(self.graph, 'MachineOperatorToProcessor', 'toProcessor', 'fromOperator', machineOperator, nextProcessor)
        rel.addToGraph(currPlace[0], currPlace[1])
        
    def generateItem(self, generator):
        if generator.getProperty('amount') <= 0:
            return
    
        generatorRelations = generator.getRelations()
        conveyorBelt = None
        itemType = None
        for generatorRelation in generatorRelations:
            if generatorRelation.className == 'PartToGenerator':
                for obj in generatorRelation.getObjects():
                    if obj.className != 'Generator':
                        itemType = obj.className
            elif generatorRelation.className == 'GeneratorToConveyorBelt':
                for obj in generatorRelation.getObjects():
                    if obj.className == 'ConveyorBelt':
                        conveyorBelt = obj
                        if self.getItem(conveyorBelt) != None:
                            return
                        
        newItem = self.objectFactory.createObject(self.graph, itemType)
        place = conveyorBelt.getPlace()
        newItem.addToGraph(place[0], str(int(place[1]) - 30))
        newRelation = self.relationshipFactory.createRelationship(self.graph, 'PartToConveyorBelt', 'toEntity', 'fromPart', newItem, conveyorBelt)
        newRelation.addToGraph(place[0], place[1])
        generator.setProperty('amount', generator.getProperty('amount') - 1)
        generator.updateProperties()
        
    def moveItem(self, item):
        conveyorBelt, currRelation = self.getConveyorBelt(item)
        if conveyorBelt != None:
            nextConveyorBelt = None
            for rel in conveyorBelt.getRelations():
                if rel.className == 'ConveyorBeltToConveyorBelt':
                    for obj in rel.getObjects():
                        if obj.className == 'ConveyorBelt' and obj.objectID != conveyorBelt.objectID and conveyorBelt.getProperty('order') < obj.getProperty('order'):
                            nextConveyorBelt  = obj
                            break
                            
            if nextConveyorBelt != None and self.getItem(nextConveyorBelt) == None:
                currRelation.remove()
                place = nextConveyorBelt.getPlace()
                newRelation = None
                if item.className == 'WarAPC' or item.className == 'RiotAPC':
                    newRelation = self.relationshipFactory.createRelationship(self.graph, 'FinishedProductToConveyorBelt', 'toConveyorBelt', 'fromPart', item, nextConveyorBelt)
                else:
                    newRelation = self.relationshipFactory.createRelationship(self.graph, 'PartToConveyorBelt', 'toEntity', 'fromPart', item, nextConveyorBelt)
                newRelation.addToGraph(place[0], place[1])
                item.moveTo(place[0], str(int(place[1]) - 30))
                
    def sinkItem(self, sink):
        conveyorBelt = None
        for relation in sink.getRelations():
            if relation.className == 'ConveyorBeltToSink':
                for obj in relation.getObjects():
                    if obj.className == 'ConveyorBelt':
                        conveyorBelt = obj
                        break
                break
                     
        item = self.getItem(conveyorBelt)
        if item == None:
            return
        
        sink.setProperty('finished' + item.className + 's', sink.getProperty('finished' + item.className + 's') + 1)
        sink.updateProperties()
        item.remove()
        
    def assemble(self, assembler):
        if self.getOperator(assembler) == None:
            return
            
        print 'ASSEMBLING'
        items = {'Tracks': [], 'WaterCannon': [], 'Wheel': [], 'Body': [], 'MachineGun': []}
        relationships = assembler.getRelations()
        nextConveyorBelt = None
        for relationship in relationships:
            if relationship.className == 'ConveyorBeltToProcessor':
                for obj in relationship.getObjects():
                    if obj.className == 'ConveyorBelt':
                        currConveyorBelt = obj
                        while currConveyorBelt != None:
                            print 'currConveyorBelt'
                            item = self.getItem(currConveyorBelt)
                            if item != None:
                                items[item.className].append(item)
                            currConveyorBelt = self.getPrevConveyorBelt(currConveyorBelt)
                        break                                
                            
            elif relationship.className == 'AssemblerToConveyorBelt':
                for obj in relationship.getObjects():
                    if obj != assembler:
                        nextConveyorBelt = obj
        
        print items
        
        if self.getItem(nextConveyorBelt) != None:
            return
        
        canGenerateWar = len(items['Tracks']) >= 2 and len(items['Body']) >= 1 and len(items['MachineGun']) >= 1
        canGenerateRiot = len(items['Wheel']) >= 4 and len(items['Body']) >= 1 and len(items['WaterCannon']) >= 1
        itemType = None
        if canGenerateWar and ((len(items['MachineGun']) >= len(items['WaterCannon'])) or not canGenerateRiot):
            itemType = 'WarAPC'
            for item in items['Tracks'][:2]:
                item.remove()
            items['Body'][0].remove()
            items['MachineGun'][0].remove()
        elif canGenerateRiot and ((len(items['WaterCannon']) > len(items['MachineGun'])) or not canGenerateWar):
            itemType = 'RiotAPC'
            for item in items['Wheel'][:4]:
                item.remove()
            items['Body'][0].remove()
            items['WaterCannon'][0].remove()
        if itemType != None:
            assembledAPC = self.objectFactory.createObject(self.graph, itemType)
            random.seed(None)
            rand = random.randint(0,1)
            assembledAPC.setProperty('broken', rand)
            place = nextConveyorBelt.getPlace()
            assembledAPC.addToGraph(place[0], str(int(place[1]) - 30))
            assembledAPC.updateProperties()
            newRelation = self.relationshipFactory.createRelationship(self.graph, 'FinishedProductToConveyorBelt', 'toConveyorBelt', 'fromPart', assembledAPC, nextConveyorBelt)
            newRelation.addToGraph(place[0], place[1])
            
    def control(self, qualityControl):
        if self.getOperator(qualityControl) == None:
            return
        
        workingConveyorBelt = None
        brokenConveyorBelt = None
        prevConveyorBelt = None
        for relation in qualityControl.getRelations():
            if relation.className == 'BrokenOutput':
                for obj in relation.getObjects():
                    if obj.className == 'ConveyorBelt':
                        brokenConveyorBelt = obj
            elif relation.className == 'WorkingOutput':
                for obj in relation.getObjects():
                    if obj.className == 'ConveyorBelt':
                        workingConveyorBelt = obj
            elif relation.className == 'ConveyorBeltToProcessor':
                for obj in relation.getObjects():
                    if obj.className == 'ConveyorBelt':
                        prevConveyorBelt = obj            
        
        item = self.getItem(prevConveyorBelt)
        if item == None:
            return
        
        for rel in item.getRelations():
            if rel.className == 'FinishedProductToConveyorBelt':
                rel.remove()
                
        nextConveyorBelt = brokenConveyorBelt if item.getProperty('broken') == 1 else workingConveyorBelt
        place = nextConveyorBelt.getPlace()
        newRelation = self.relationshipFactory.createRelationship(self.graph, 'FinishedProductToConveyorBelt', 'toConveyorBelt', 'fromPart', item, nextConveyorBelt)
        newRelation.addToGraph(place[0], place[1])
        item.moveTo(place[0], str(int(place[1]) - 30))
        
    def repair(self, repairMachine):
        if self.getOperator(repairMachine) == None:
            return
            
        prevConveyorBelt = None
        nextConveyorBelt = None
        for relation in repairMachine.getRelations():
            if relation.className == 'ConveyorBeltToProcessor':
                for obj in relation.getObjects():
                    if obj.className == 'ConveyorBelt':
                        prevConveyorBelt = obj
            elif relation.className == 'RepairMachineToConveyorBelt':
                for obj in relation.getObjects():
                    if obj.className == 'ConveyorBelt':
                        nextConveyorBelt = obj
                        
        item = self.getItem(prevConveyorBelt)
        if item == None:
            return
            
        for rel in item.getRelations():
            if rel.className == 'FinishedProductToConveyorBelt':
                rel.remove()
                
        item.setProperty('broken', 0)
        item.updateProperties()
        place = nextConveyorBelt.getPlace()
        newRelation = self.relationshipFactory.createRelationship(self.graph, 'FinishedProductToConveyorBelt', 'toConveyorBelt', 'fromPart', item, nextConveyorBelt)
        newRelation.addToGraph(place[0], place[1])
        item.moveTo(place[0], str(int(place[1]) - 30))