#
# DCharts.py
#
# contains the DCharts Meta-model
#

# a DC_HyperEdge is a transition and has a "name", a "fromState" and a "toState"
class DC_HyperEdge:

    def __init__(self, name, fromState, toState):
      self.name = name
      self.fromState = fromState
      self.toState = toState

# a DC_Contains has a a "fromState" and a "toState"
class DC_Contains:

    def __init__(self, fromState, toState):
      self.fromState = fromState
      self.toState = toState

# a State has a "name", an "is_default" and 
# an "inedges" and "outedges" which are lists representing the incoming/outgoing HyperEdges/Contains
class State:

    def __init__(self, name):
      self.name = name
      self.is_default = False
      self.inedges = []
      self.outedges = []
      self.incontain = None

# a DC_Basic is a State which has an "is_final"
class DC_Basic (State):

    def __init__(self, name):
      # parent constructor
      State.__init__(self, name) 

      self.is_final = False

# a DC_History is a State which has an "is_deep"
class DC_History (State):

    def __init__(self, name):
      # parent constructor
      State.__init__(self, name) 

      self.is_deep = False

# a CompositeState is a State which has 
# a "contains" which is a list representing the outgoing Contains
class CompositeState (State):

    def __init__(self, name):
      # parent constructor
      State.__init__(self, name) 
      self.contains = []

# a DC_Orthogonal is a CompositeState
class DC_Orthogonal (CompositeState):

    def __init__(self, name):
      # parent constructor
      CompositeState.__init__(self, name) 

# a DC_Composite is a CompositeState
class DC_Composite (CompositeState):

    def __init__(self, name):
      # parent constructor
      CompositeState.__init__(self, name) 
