grammar metaDepth;

options {backtrack=true; output=AST; ASTLabelType=CommonTree; superClass=MetaDepthParserBase;} 

tokens{
  NODE = 'Node';
  MODEL = 'Model';
  EDGE  = 'Edge';
  ENUM = 'enum';
  ABSTRACT = 'abstract';
  INTEGERT   = 'int';
  DOUBLET = 'double';
  BOOLEANT= 'boolean';
  STRINGT= 'String';
  ORDERED= 'ordered';
  UNIQUE= 'unique';
  READONLY= 'readOnly';
  ISID= 'id';
  STRICT = 'strict';  
  EXTENSIBLE = 'ext';
  IMPORTS = 'imports';
  CONCEPT = 'concept';
  TEMPLATE = 'template';
  TEMPLATE_INST;
  NAME;
  RELAXED;  
  DOC_INSTANCE;
  MODEL_INSTANCE;
  FIELD_INSTANCE;
  DERIVED_FIELD;
  FIELD_VALUE;
  LIST_VALUE;
  INITIAL_VALUE;
  NODE_INSTANCE;
  EDGE_INSTANCE;
  NODE_TYPE;
  EDGE_INSTANCE;
  DECLARATIONS;
  ASSOC_ENDS;
  ID_LIST;
  ASSOC_END;
  MULTIPLICITY;
  FLOAT;
  POTENCY;
  MODIFIER;
  SUPERS;
  CONSTRAINT;
  CONTEXT;
  DECLARATIONS;
  }

@parser::header{
/*******************************************************************************
 * MetaDepth parser for top-level language
 ******************************************************************************/
package meteoric.at3rdx.parse;	
}

@lexer::header{
/*******************************************************************************
 * MetaDepth parser for top-level language
 ******************************************************************************/
package meteoric.at3rdx.parse;	
}

@members{
public void emitErrorMessage ( String msg ) {
}
}

/**
  document: the main rule, which reads a sequence of models
*/
document :		declas* EOF -> ^(DOC_INSTANCE declas*);

declas  :		model | model_inst | concept | template | template_inst;

concept  :		CONCEPT ID context LBRACKET (model|model_inst)? RBRACKET ('where' CONSTR)? 	-> ^(CONCEPT ID context model? CONSTR?);

template :		TEMPLATE '<' context '>' 'requires' conceptCall (mt= model| mi=model_inst)    	-> {mt!=null}? 	^(TEMPLATE context conceptCall $mt)
													->  		^(TEMPLATE context conceptCall $mi);
template_inst	:	tn=ID '<' qualifDecla '>' (inID=ID)? SEMICOLON				   	-> ^(TEMPLATE_INST $tn qualifDecla $inID?);

qualifDecla  	:	qid+=qualifID (COMMA qid+=qualifID)* 			   			-> ^(ID $qid+);

qualifID        :	id1+=ID (ACCESS id1+=ID)* 							-> ^(ID $id1+);

conceptCall_list :	cc+=conceptCall ( COLON cc+=conceptCall )* 					-> ^(CONCEPT $cc+);

conceptCall 	:	ID context 									-> ^(CONCEPT ID context);


/**
  a model can be either an instance of a meta-model (first rule) or a linguistic instance only (hence starts by Model)
*/
model_inst:	(EXTENSIBLE)? mtype=ID mname=ID LBRACKET cls RBRACKET 			-> ^(MODEL_INSTANCE[$mname] $mtype  RELAXED POT IMPORTS cls) |
		(EXTENSIBLE)? mtype=ID mname=ID potency LBRACKET cls RBRACKET 		-> ^(MODEL_INSTANCE[$mname] $mtype  RELAXED potency IMPORTS cls) |
		
		STRICT mtype=ID mname=ID LBRACKET cls RBRACKET 					-> ^(MODEL_INSTANCE[$mname] $mtype  STRICT POT IMPORTS cls) |
		STRICT mtype=ID mname=ID potency LBRACKET cls RBRACKET 			-> ^(MODEL_INSTANCE[$mname] $mtype  STRICT potency IMPORTS cls) |
		
		(EXTENSIBLE)? mtype=ID mname=ID imports LBRACKET cls RBRACKET 		-> ^(MODEL_INSTANCE[$mname] $mtype  RELAXED POT imports cls) |
		(EXTENSIBLE)? mtype=ID mname=ID potency imports LBRACKET cls RBRACKET	-> ^(MODEL_INSTANCE[$mname] $mtype  RELAXED potency imports cls) |
		
		STRICT mtype=ID mname=ID imports LBRACKET cls RBRACKET 			-> ^(MODEL_INSTANCE[$mname] $mtype  STRICT POT imports cls) |
		STRICT mtype=ID mname=ID potency imports LBRACKET cls RBRACKET 		-> ^(MODEL_INSTANCE[$mname] $mtype  STRICT potency imports cls);
		
model: 	(EXTENSIBLE)? MODEL ID potency LBRACKET cls RBRACKET 			-> ^(MODEL_INSTANCE[$ID.text] MODEL RELAXED potency IMPORTS cls) |
		(EXTENSIBLE)? MODEL ID LBRACKET cls RBRACKET 				-> ^(MODEL_INSTANCE[$ID.text] MODEL RELAXED POT IMPORTS cls) |
		STRICT MODEL ID potency LBRACKET cls RBRACKET 				-> ^(MODEL_INSTANCE[$ID.text] MODEL STRICT potency IMPORTS cls) |
		STRICT MODEL ID LBRACKET cls RBRACKET 					-> ^(MODEL_INSTANCE[$ID.text] MODEL STRICT POT IMPORTS cls)|
		(EXTENSIBLE)? MODEL ID potency imports LBRACKET cls RBRACKET 	-> ^(MODEL_INSTANCE[$ID.text] MODEL RELAXED potency imports cls) |
		(EXTENSIBLE)? MODEL ID imports LBRACKET cls RBRACKET 			-> ^(MODEL_INSTANCE[$ID.text] MODEL RELAXED POT imports cls) |
		STRICT MODEL ID potency imports LBRACKET cls RBRACKET 		-> ^(MODEL_INSTANCE[$ID.text] MODEL STRICT potency imports cls) |
		STRICT MODEL ID imports LBRACKET cls RBRACKET 				-> ^(MODEL_INSTANCE[$ID.text] MODEL STRICT POT imports cls);		

nested_model_inst : (EXTENSIBLE)? MODEL mtype=ID mname=ID LBRACKET cls RBRACKET 			-> ^(MODEL_INSTANCE[$mname] $mtype  RELAXED POT IMPORTS cls) |
			(EXTENSIBLE)? MODEL mtype=ID mname=ID potency LBRACKET cls RBRACKET 		-> ^(MODEL_INSTANCE[$mname] $mtype  RELAXED potency IMPORTS cls) |
		
			STRICT MODEL mtype=ID mname=ID LBRACKET cls RBRACKET 					-> ^(MODEL_INSTANCE[$mname] $mtype  STRICT POT IMPORTS cls) |
			STRICT MODEL mtype=ID mname=ID potency LBRACKET cls RBRACKET 			-> ^(MODEL_INSTANCE[$mname] $mtype  STRICT potency IMPORTS cls) |
		
			(EXTENSIBLE)? MODEL mtype=ID mname=ID imports LBRACKET cls RBRACKET 		-> ^(MODEL_INSTANCE[$mname] $mtype  RELAXED POT imports cls) |
			(EXTENSIBLE)? MODEL mtype=ID mname=ID potency imports LBRACKET cls RBRACKET	-> ^(MODEL_INSTANCE[$mname] $mtype  RELAXED potency imports cls) |
			
			STRICT MODEL mtype=ID mname=ID imports LBRACKET cls RBRACKET 			-> ^(MODEL_INSTANCE[$mname] $mtype  STRICT POT imports cls) |
			STRICT MODEL mtype=ID mname=ID potency imports LBRACKET cls RBRACKET 		-> ^(MODEL_INSTANCE[$mname] $mtype  STRICT potency imports cls);

potency  :	POT pot_num -> POTENCY[$pot_num.text];	
pot_num  :	INT | INF;

imports  :	IMPORTS k+=ID (COMMA k+=ID)* -> ^(IMPORTS $k+);

cls	 :	(dc+=node_inst | dc+=edge_inst| dc+=enum_dcl |dc+=edge_dcl | dc+=node_dcl | dc+=gconstr | dc+=attr SEMICOLON | dc+=attrInst SEMICOLON | dc+=nested_model_inst ) * -> ^(DECLARATIONS $dc*);

node_dcl :	(EXTENSIBLE)? ABSTRACT NODE ID potency body   		-> ^(NODE_INSTANCE NODE ID MULTIPLICITY RELAXED TRUE  potency SUPERS body?) |
		(EXTENSIBLE)? ABSTRACT NODE ID body   			-> ^(NODE_INSTANCE NODE ID MULTIPLICITY RELAXED TRUE  POT     SUPERS body?) |
		(EXTENSIBLE)? NODE ID potency body   			-> ^(NODE_INSTANCE NODE ID MULTIPLICITY RELAXED FALSE potency SUPERS body?) |
		(EXTENSIBLE)? NODE ID body   				-> ^(NODE_INSTANCE NODE ID MULTIPLICITY RELAXED FALSE POT     SUPERS body?) |
		(EXTENSIBLE)? ABSTRACT NODE ID potency supers body 	-> ^(NODE_INSTANCE NODE ID MULTIPLICITY RELAXED TRUE  potency supers body?) |
		(EXTENSIBLE)? ABSTRACT NODE ID supers body   		-> ^(NODE_INSTANCE NODE ID MULTIPLICITY RELAXED TRUE  POT     supers body?) |
		(EXTENSIBLE)? NODE ID potency supers body   		-> ^(NODE_INSTANCE NODE ID MULTIPLICITY RELAXED FALSE potency supers body?) |
		(EXTENSIBLE)? NODE ID supers body   			-> ^(NODE_INSTANCE NODE ID MULTIPLICITY RELAXED FALSE POT     supers body?) |
		
		STRICT ABSTRACT NODE ID potency body   			-> ^(NODE_INSTANCE NODE ID MULTIPLICITY STRICT TRUE  potency  SUPERS body?) |
		STRICT ABSTRACT NODE ID body   				-> ^(NODE_INSTANCE NODE ID MULTIPLICITY STRICT TRUE  POT      SUPERS body?) |
		STRICT NODE ID potency body   				-> ^(NODE_INSTANCE NODE ID MULTIPLICITY STRICT FALSE potency  SUPERS body?) |
		STRICT NODE ID body   					-> ^(NODE_INSTANCE NODE ID MULTIPLICITY STRICT FALSE POT      SUPERS body?) |
		STRICT ABSTRACT NODE ID potency supers body  		-> ^(NODE_INSTANCE NODE ID MULTIPLICITY STRICT TRUE  potency  supers body?) |
		STRICT ABSTRACT NODE ID supers body   			-> ^(NODE_INSTANCE NODE ID MULTIPLICITY STRICT TRUE  POT      supers body?) |
		STRICT NODE ID potency supers body   			-> ^(NODE_INSTANCE NODE ID MULTIPLICITY STRICT FALSE potency  supers body?) |
		STRICT NODE ID supers body   				-> ^(NODE_INSTANCE NODE ID MULTIPLICITY STRICT FALSE POT      supers body?) |
		
		(EXTENSIBLE)? ABSTRACT NODE ID mult potency body   		-> ^(NODE_INSTANCE NODE ID mult RELAXED TRUE  potency SUPERS body?) |
		(EXTENSIBLE)? ABSTRACT NODE ID mult body   			-> ^(NODE_INSTANCE NODE ID mult RELAXED TRUE  POT     SUPERS body?) |
		(EXTENSIBLE)? NODE ID mult potency body   			-> ^(NODE_INSTANCE NODE ID mult RELAXED FALSE potency SUPERS body?) |
		(EXTENSIBLE)? NODE ID mult body   				-> ^(NODE_INSTANCE NODE ID mult RELAXED FALSE POT     SUPERS body?) |
		(EXTENSIBLE)? ABSTRACT NODE ID mult potency supers body 	-> ^(NODE_INSTANCE NODE ID mult RELAXED TRUE  potency supers body?) |
		(EXTENSIBLE)? ABSTRACT NODE ID mult supers body   		-> ^(NODE_INSTANCE NODE ID mult RELAXED TRUE  POT     supers body?) |
		(EXTENSIBLE)? NODE ID mult potency supers body   		-> ^(NODE_INSTANCE NODE ID mult RELAXED FALSE potency supers body?) |
		(EXTENSIBLE)? NODE ID mult supers body   			-> ^(NODE_INSTANCE NODE ID mult RELAXED FALSE POT     supers body?) |
		
		STRICT ABSTRACT NODE ID mult potency body   			-> ^(NODE_INSTANCE NODE ID mult STRICT TRUE  potency  SUPERS body?) |
		STRICT ABSTRACT NODE ID mult body   				-> ^(NODE_INSTANCE NODE ID mult STRICT TRUE  POT      SUPERS body?) |
		STRICT NODE ID mult potency body   				-> ^(NODE_INSTANCE NODE ID mult STRICT FALSE potency  SUPERS body?) |
		STRICT NODE ID mult body   					-> ^(NODE_INSTANCE NODE ID mult STRICT FALSE POT      SUPERS body?) |
		STRICT ABSTRACT NODE ID mult potency supers body  		-> ^(NODE_INSTANCE NODE ID mult STRICT TRUE  potency  supers body?) |
		STRICT ABSTRACT NODE ID mult supers body   			-> ^(NODE_INSTANCE NODE ID mult STRICT TRUE  POT      supers body?) |
		STRICT NODE ID mult potency supers body   			-> ^(NODE_INSTANCE NODE ID mult STRICT FALSE potency  supers body?) |
		STRICT NODE ID mult supers body   				-> ^(NODE_INSTANCE NODE ID mult STRICT FALSE POT      supers body?);

edge_dcl : 	EDGE ID potency  LPARENT assoc_ends RPARENT body  		-> ^(EDGE_INSTANCE EDGE ID RELAXED potency assoc_ends body?) |
		EDGE ID LPARENT assoc_ends RPARENT body 			-> ^(EDGE_INSTANCE EDGE ID RELAXED POT assoc_ends body?) |
		
		EDGE ID potency  LPARENT assoc_ends RPARENT body  		-> ^(EDGE_INSTANCE EDGE ID STRICT potency assoc_ends body?) |
		EDGE ID LPARENT assoc_ends RPARENT body 			-> ^(EDGE_INSTANCE EDGE ID STRICT POT assoc_ends body?) ;

body	:	LBRACKET attrs RBRACKET -> attrs? |
		SEMICOLON		-> ;
		

node_inst :	(EXTENSIBLE)? ntype=ID (nname=ID)? body_inst   			-> {nname!=null}? ^(NODE_INSTANCE $ntype $nname   RELAXED SUPERS body_inst?) .
										-> 		  ^(NODE_INSTANCE $ntype NAME[""] RELAXED SUPERS body_inst?) |
		STRICT ntype=ID (nname=ID)? body_inst   			-> {nname!=null}? ^(NODE_INSTANCE $ntype $nname STRICT  SUPERS body_inst?)  
										-> 		  ^(NODE_INSTANCE $ntype NAME[""] STRICT  SUPERS body_inst?) |
		(EXTENSIBLE)? ntype=ID (nname=ID)? supers body_inst   		-> {nname!=null}? ^(NODE_INSTANCE $ntype $nname RELAXED supers body_inst?) 
										-> 		  ^(NODE_INSTANCE $ntype NAME[""] RELAXED supers body_inst?) |
		STRICT ntype=ID (nname=ID)? supers body_inst   			-> {nname!=null}? ^(NODE_INSTANCE $ntype $nname STRICT  supers body_inst?)
										-> 		  ^(NODE_INSTANCE $ntype NAME[""] STRICT  supers body_inst?);
		
		//(EXTENSIBLE)? ntype=ID body_inst   				-> ^(NODE_INSTANCE $ntype NAME[""] RELAXED SUPERS body_inst?) |		
		//STRICT ntype=ID body_inst   					-> ^(NODE_INSTANCE $ntype NAME[""] STRICT  SUPERS body_inst?)  |		
		//(EXTENSIBLE)? ntype=ID supers body_inst   			-> ^(NODE_INSTANCE $ntype NAME[""] RELAXED supers body_inst?) |
		//STRICT ntype=ID supers body_inst   				-> ^(NODE_INSTANCE $ntype NAME[""] STRICT  supers body_inst?);
		
enum_dcl: 	ENUM ename=ID LBRACKET el+=ID (COMMA el+=ID)* RBRACKET -> ^(ENUM $ename $el+);


edge_inst :	ntype=ID nname=ID LPARENT (idl=id_list|assoc_ends) RPARENT body_inst  		-> {idl!=null}?	^(EDGE_INSTANCE $ntype $nname RELAXED id_list body_inst?) 
												-> 		^(EDGE_INSTANCE $ntype $nname RELAXED assoc_ends body_inst?) |
		STRICT ntype=ID nname=ID LPARENT (idl=id_list|assoc_ends) RPARENT body_inst  	-> {idl!=null}?	^(EDGE_INSTANCE $ntype $nname STRICT id_list body_inst?) 
												-> 		^(EDGE_INSTANCE $ntype $nname STRICT assoc_ends body_inst?) |
		ntype=ID nname=LPARENT (idl=id_list|assoc_ends) RPARENT body_inst  		-> {idl!=null}?	^(EDGE_INSTANCE $ntype $nname RELAXED id_list body_inst?) 
												->		^(EDGE_INSTANCE $ntype $nname RELAXED assoc_ends body_inst?) |
		STRICT ntype=ID nname=LPARENT (idl=id_list|assoc_ends) RPARENT body_inst  	-> {idl!=null}?	^(EDGE_INSTANCE $ntype $nname STRICT id_list body_inst?) 
												->		^(EDGE_INSTANCE $ntype $nname STRICT assoc_ends body_inst?);
		
body_inst :	 LBRACKET attr_insts RBRACKET -> attr_insts? |
 		 SEMICOLON -> ;
		
id_list	:	more+=ID COMMA more+=ID (COMMA more+=ID)*-> ^(ID_LIST $more+);

supers	:	COLON k+=ID (COMMA k+=ID)* -> ^(SUPERS $k+);

assoc_ends:	j+=assoc_end COMMA j+=assoc_end (COMMA j+=assoc_end)* -> ^(ASSOC_ENDS $j+);

assoc_end:	ty=ID PERIOD ae=ID -> ^(ASSOC_END $ty $ae) |
		typ+=ID (ACCESS typ+=ID)+ PERIOD ae=ID -> ^(ASSOC_END $typ+ $ae);

attr_insts :	( (at+=attrInst SEMICOLON) | (at+=attr SEMICOLON) | at+=lconstr )* -> $at*;

attrs 	:	( (at+=attr SEMICOLON) | at+=lconstr)* -> $at*;

attr	:	ID potency COLON decla mult init modif 		-> ^(FIELD_INSTANCE ID potency 	decla mult         init modif) |
		ID COLON decla mult init modif 			-> ^(FIELD_INSTANCE ID POT 	decla mult 	   init modif) |
		ID potency COLON decla init modif 		-> ^(FIELD_INSTANCE ID potency 	decla MULTIPLICITY init modif) |
		ID COLON decla init modif 			-> ^(FIELD_INSTANCE ID POT 	decla MULTIPLICITY init modif) |
		
		ID potency COLON decla mult modif 		-> ^(FIELD_INSTANCE ID potency  decla mult?        INITIAL_VALUE modif) |
		ID COLON decla mult modif 			-> ^(FIELD_INSTANCE ID POT      decla mult?        INITIAL_VALUE modif) |
		ID potency COLON decla modif 			-> ^(FIELD_INSTANCE ID potency  decla MULTIPLICITY INITIAL_VALUE modif) |
		ID COLON decla modif 				-> ^(FIELD_INSTANCE ID POT      decla MULTIPLICITY INITIAL_VALUE modif) |
		
		ID potency COLON decla mult init modif? 	-> ^(FIELD_INSTANCE ID potency  decla mult 	   init MODIFIER) |
		ID COLON decla mult init modif? 		-> ^(FIELD_INSTANCE ID POT 	decla mult 	   init MODIFIER) |
		ID potency COLON decla init modif? 		-> ^(FIELD_INSTANCE ID potency 	decla MULTIPLICITY init MODIFIER) |
		ID COLON decla init modif? 			-> ^(FIELD_INSTANCE ID POT 	decla MULTIPLICITY init MODIFIER) |
		
		ID potency COLON decla mult modif? 		-> ^(FIELD_INSTANCE ID potency 	decla mult? 	   INITIAL_VALUE MODIFIER) |
		ID COLON decla mult modif? 			-> ^(FIELD_INSTANCE ID POT 	decla mult? 	   INITIAL_VALUE MODIFIER) |
		ID potency COLON decla modif? 			-> ^(FIELD_INSTANCE ID potency 	decla MULTIPLICITY INITIAL_VALUE MODIFIER) |
		ID COLON decla modif? 				-> ^(FIELD_INSTANCE ID POT 	decla MULTIPLICITY INITIAL_VALUE MODIFIER) |
		
		RBAR ID COLON decla ASSIGNMENT CONSTR 			-> ^(DERIVED_FIELD ID POT     decla MULTIPLICITY CONSTR) |
		RBAR ID potency COLON decla ASSIGNMENT CONSTR 		-> ^(DERIVED_FIELD ID potency decla MULTIPLICITY CONSTR) |
		RBAR ID potency COLON decla mult ASSIGNMENT CONSTR	-> ^(DERIVED_FIELD ID potency decla mult? CONSTR);
		
lconstr :	ID potency LSQBRACKET ID RSQBRACKET COLON CONSTR -> ^(CONSTRAINT ID potency ID CONSTR) |
		ID LSQBRACKET ID RSQBRACKET COLON CONSTR -> ^(CONSTRAINT ID POT ID CONSTR) |
		ID potency COLON CONSTR -> ^(CONSTRAINT ID potency POT CONSTR) |
		ID COLON CONSTR -> ^(CONSTRAINT ID POT POT CONSTR);
		
gconstr	:	ID potency LSQBRACKET ID RSQBRACKET COLON CONSTR -> ^(CONSTRAINT ID potency ID ^(CONTEXT POT) CONSTR) |
		ID LSQBRACKET ID RSQBRACKET COLON CONSTR -> ^(CONSTRAINT ID POT ID ^(CONTEXT POT) CONSTR) |
		ID potency COLON CONSTR -> ^(CONSTRAINT ID potency POT ^(CONTEXT POT) CONSTR) |
		ID COLON CONSTR -> ^(CONSTRAINT ID POT POT ^(CONTEXT POT) CONSTR) |
		
		ID potency LSQBRACKET ID RSQBRACKET context COLON CONSTR -> ^(CONSTRAINT ID potency ID context CONSTR) |
		ID LSQBRACKET ID RSQBRACKET context COLON CONSTR -> ^(CONSTRAINT ID POT ID context CONSTR) |
		ID potency context COLON CONSTR -> ^(CONSTRAINT ID potency POT context CONSTR) |
		ID context COLON CONSTR -> ^(CONSTRAINT ID POT POT context CONSTR);

attrInst :	ID ASSIGNMENT literal -> ^(FIELD_VALUE ID literal) |
                ID ASSIGNMENT listOfLits -> ^(FIELD_VALUE ID listOfLits);
                
listOfLits :	LSQBRACKET RSQBRACKET					-> ^(LIST_VALUE ) |
		//LSQBRACKET ival+=INT (COMMA ival+=INT)* RSQBRACKET 	-> ^(LIST_VALUE $ival+) |
		LSQBRACKET (ival+=FLOAT|ival+=INT) (COMMA (ival+=FLOAT|ival+=INT))* RSQBRACKET 	-> ^(LIST_VALUE $ival+) |
		LSQBRACKET ival+=STRING (COMMA ival+=STRING)* RSQBRACKET-> ^(LIST_VALUE $ival+) |
		LSQBRACKET ival+=BOOL (COMMA ival+=BOOL)* RSQBRACKET 	-> ^(LIST_VALUE $ival+) |
		LSQBRACKET ival+=ID (COMMA ival+=ID)* RSQBRACKET 	-> ^(LIST_VALUE $ival+);


context	:	LPARENT co+=ID (COMMA co+=ID)*  RPARENT -> ^(CONTEXT $co+);

init    :	ASSIGNMENT literal -> ^(INITIAL_VALUE literal) |
                ASSIGNMENT listOfLits -> ^(INITIAL_VALUE listOfLits);

literal :	INT | FLOAT | STRING | BOOL | ID;

decla   :	INTEGERT|DOUBLET|BOOLEANT|STRINGT|NODE|user_type; 

user_type :     typ+=ID (ACCESS typ+=ID)* -> ^(NODE_TYPE $typ+) ;

modif   :	LBRACKET i+=mod (COMMA i+=mod)* RBRACKET -> ^(MODIFIER $i+);

mod	:	ISID | ORDERED | UNIQUE | READONLY | ID ;

mult 	:	LSQBRACKET low=INT INTVL pot_num RSQBRACKET 		-> ^(MULTIPLICITY $low pot_num)|
		LSQBRACKET pot_num RSQBRACKET				-> ^(MULTIPLICITY pot_num);

fragment DIGIT   :	'0'..'9';


CONSTR	:	'$' ( options {greedy=false;} : . )* '$';

INT : '-'? (DIGIT)+ ((PERIOD DIGIT)=> PERIOD (DIGIT)+ {$type = FLOAT;})? ;

fragment  TRUE	:  'True';
fragment  FALSE :  'False';
BOOL 	:	TRUE | FALSE;
INF     :	'*';
POT	:	'@';
COMMA        : ',';
LBRACKET    : '{';
RBRACKET    : '}';
LPARENT	:	'(';
RPARENT :	')';
LSQBRACKET   :	'[';
RSQBRACKET   :	 ']';
SEMICOLON   : ';';
ASSIGNMENT  : '=';
RBAR 	:	 '/';
COLON 	:	':';
ACCESS 	:	'::';	
PERIOD	:	'.';
INTVL	:	'..';

//CID :	'&' ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'0'..'9'|'_')*;

ID  :	('&')? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'0'..'9'|'_')*;


//FLOAT 	: ('-'|'+')? DIGIT+ '.' DIGIT+ EXPONENT?	
//    :   ('-'|'+')? ('0'..'9')+ '.' ('0'..'9')+ EXPONENT?
//    |  ('-'|'+')? ',' ('0'..'9')+ EXPONENT?
//    |  ('-'|'+')? ('0'..'9')+ EXPONENT
//    ;

COMMENT
    :   '//' ~('\n'|'\r')* '\r'? '\n' {$channel=HIDDEN;}
    |   '/*' ( options {greedy=false;} : . )* '*/' {$channel=HIDDEN;}
    ;

WS  :   ( ' '
        | '\t'
        | '\r'
        | '\n'
        ) {$channel=HIDDEN;}
    ;

STRING
    :  '"' ( ESC_SEQ | ~('\\'|'"') )* '"'
    ;

CHAR:  '\'' ( ESC_SEQ | ~('\''|'\\') ) '\''
    ;

fragment
EXPONENT : ('e'|'E') ('+'|'-')? ('0'..'9')+ ;

fragment
HEX_DIGIT : ('0'..'9'|'a'..'f'|'A'..'F') ;

fragment
ESC_SEQ
    :   '\\' ('b'|'t'|'n'|'f'|'r'|'\"'|'\''|'\\')
    |   UNICODE_ESC
    |   OCTAL_ESC
    ;

fragment
OCTAL_ESC
    :   '\\' ('0'..'3') ('0'..'7') ('0'..'7')
    |   '\\' ('0'..'7') ('0'..'7')
    |   '\\' ('0'..'7')
    ;

fragment
UNICODE_ESC
    :   '\\' 'u' HEX_DIGIT HEX_DIGIT HEX_DIGIT HEX_DIGIT
    ;