grammar products;
options {backtrack=true; output=AST; ASTLabelType=CommonTree; superClass=MetaDepthParserBase;}
tokens{DOC_INSTANCE;
LOAD = 'load';
TPRODUCT_NODE;
  TRUE  = 'true';
  FALSE  = 'false';
TPRODUCTS_NODE;
LBRACKET = '{';
RBRACKET = '}';
LPARENT = '(';
SYMBOL17 = '%';
RPARENT = ')';
SEMICOLON = ';';
COLON = ':';
LSQBRACKET = '[';
RSQBRACKET = ']';
POT = '@';
INTVL = '..';
INF = '*';
ASSIGNMENT = '=';
ACCESS = '::';
COMMA = ',';
  INTEGERT   = 'int';
  INTEGERTO  = 'Integer';
  DOUBLET = 'double';
  BOOLEANT= 'boolean';
  STRINGT= 'String';
  ORDERED= 'ordered';
  UNIQUE= 'unique';
  READONLY= 'readOnly';
  ISID= 'id';
  NODE = 'Node';
  EDGE  = 'Edge';
  DECLARATIONS;
  FIELD_INSTANCE;
  MULTIPLICITY;
  POTENCY;
  INITIAL_VALUE;
  LIST_VALUE;
  MODIFIER;
  NODE_TYPE;
}
@parser::header{
/*******************************************************************************
 * MetaDepth parser for language: products
 ******************************************************************************/
package serializers;
import meteoric.at3rdx.parse.MetaDepthParserBase;
}

@lexer::header{
/*******************************************************************************
 * MetaDepth parser for language: products
 ******************************************************************************/
package serializers;
import meteoric.at3rdx.parse.MetaDepthParserBase;
}

@members{
public void emitErrorMessage ( String msg ) {}
public productsParser () {}
}

document : declas* EOF -> ^(DOC_INSTANCE declas*);
declas : loadinst | main;
main :  id=ID LBRACKET ( vTProduct+=rTProduct )* RBRACKET -> ^(TPRODUCTS_NODE $id  $vTProduct*  );

rTProduct :  id=ID LPARENT VAT=FLOAT SYMBOL17 RPARENT LBRACKET cls RBRACKET -> ^(TPRODUCT_NODE $id  $VAT    cls );

loadinst :	        LOAD file=STRING -> ^(LOAD $file);
cls : (dc+=attr SEMICOLON)* -> ^(DECLARATIONS $dc*);

attr	:	ID potency COLON decla mult init modif 		-> ^(FIELD_INSTANCE ID potency 	decla mult         init modif) |
           ID COLON decla mult init modif 			-> ^(FIELD_INSTANCE ID POT 	decla mult 	   init modif) |
           ID potency COLON decla init modif 		-> ^(FIELD_INSTANCE ID potency 	decla MULTIPLICITY init modif) |
           ID COLON decla init modif 			-> ^(FIELD_INSTANCE ID POT 	decla MULTIPLICITY init modif) |

           ID potency COLON decla mult modif 		-> ^(FIELD_INSTANCE ID potency  decla mult?        INITIAL_VALUE modif) |
           ID COLON decla mult modif 			-> ^(FIELD_INSTANCE ID POT      decla mult?        INITIAL_VALUE modif) |
           ID potency COLON decla modif 			-> ^(FIELD_INSTANCE ID potency  decla MULTIPLICITY INITIAL_VALUE modif) |
           ID COLON decla modif 				-> ^(FIELD_INSTANCE ID POT      decla MULTIPLICITY INITIAL_VALUE modif) |
           ID potency COLON decla mult init modif? 	-> ^(FIELD_INSTANCE ID potency  decla mult 	   init MODIFIER) |
           ID COLON decla mult init modif? 		-> ^(FIELD_INSTANCE ID POT 	decla mult 	   init MODIFIER) |
           ID potency COLON decla init modif? 		-> ^(FIELD_INSTANCE ID potency 	decla MULTIPLICITY init MODIFIER) |
           ID COLON decla init modif? 			-> ^(FIELD_INSTANCE ID POT 	decla MULTIPLICITY init MODIFIER) |
           ID potency COLON decla mult modif? 		-> ^(FIELD_INSTANCE ID potency 	decla mult? 	   INITIAL_VALUE MODIFIER) |
           ID COLON decla mult modif? 			-> ^(FIELD_INSTANCE ID POT 	decla mult? 	   INITIAL_VALUE MODIFIER) |
           ID potency COLON decla modif? 			-> ^(FIELD_INSTANCE ID potency 	decla MULTIPLICITY INITIAL_VALUE MODIFIER) |
           ID COLON decla modif? 				-> ^(FIELD_INSTANCE ID POT 	decla MULTIPLICITY INITIAL_VALUE MODIFIER);
potency  :	POT pot_num -> POTENCY[$pot_num.text] |
           POT LPARENT p=pot_num RPARENT -> ^(POTENCY $p POT);

mult 	:	LSQBRACKET low=INT INTVL pot_num RSQBRACKET 		-> ^(MULTIPLICITY $low pot_num)|
           LSQBRACKET pot_num RSQBRACKET				-> ^(MULTIPLICITY pot_num);

pot_num  :	INT | INF ;

init    :	ASSIGNMENT literal -> ^(INITIAL_VALUE literal) |
 ASSIGNMENT listOfLits -> ^(INITIAL_VALUE listOfLits);

literal :	INT | FLOAT | STRING | bool | ID;

listOfLits :  LSQBRACKET RSQBRACKET					                                        -> ^(LIST_VALUE ) |
              LSQBRACKET (ival+=FLOAT|ival+=INT) (COMMA (ival+=FLOAT|ival+=INT))* RSQBRACKET 	-> ^(LIST_VALUE $ival+) |
              LSQBRACKET ival+=STRING (COMMA ival+=STRING)* RSQBRACKET                         -> ^(LIST_VALUE $ival+) |
              LSQBRACKET ival+=(TRUE|FALSE) (COMMA ival+=(TRUE|FALSE))* RSQBRACKET 	        -> ^(LIST_VALUE $ival+) |
              LSQBRACKET ival+=ID (COMMA ival+=ID)* RSQBRACKET 	                            -> ^(LIST_VALUE $ival+);

decla   :	INTEGERT|INTEGERTO|DOUBLET|BOOLEANT|STRINGT|NODE|EDGE|user_type;

modif   :	LBRACKET i+=mod (COMMA i+=mod)* RBRACKET -> ^(MODIFIER $i+);

mod	:	ISID | ORDERED | UNIQUE | READONLY | ID ;

user_type :     typ+=ID (ACCESS typ+=ID)* (atpot+=potency)? -> ^(NODE_TYPE $typ+ ($atpot)?) ;

ID  :	('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'0'..'9'|'_')*;
INT :	'0'..'9'+;
FLOAT:   ('0'..'9')+ '.' ('0'..'9')* EXPONENT? |   '.' ('0'..'9')+ EXPONENT? |   ('0'..'9')+ EXPONENT;
fragment EXPONENT : ('e'|'E') ('+'|'-')? ('0'..'9')+ ;
COMMENT :   '//' ~('\n'|'\r')* '\r'? '\n' {$channel=HIDDEN;}  |   '/*' ( options {greedy=false;} : . )* '*/' {$channel=HIDDEN;};
WS  :   ( ' ' | '\t' | '\r' | '\n') {$channel=HIDDEN;};
STRING :  '"' ( ESC_SEQ | ~('\\'|'"') )* '"';
CHAR:  '\'' ( ESC_SEQ | ~('\''|'\\') ) '\'';
fragment ESC_SEQ :   '\\' ('b'|'t'|'n'|'f'|'r'|'\"'|'\''|'\\') |   UNICODE_ESC |   OCTAL_ESC;
fragment OCTAL_ESC :   '\\' ('0'..'3') ('0'..'7') ('0'..'7') |   '\\' ('0'..'7') ('0'..'7') |   '\\' ('0'..'7');
fragment UNICODE_ESC :   '\\' 'u' HEX_DIGIT HEX_DIGIT HEX_DIGIT HEX_DIGIT;
fragment HEX_DIGIT : ('0'..'9'|'a'..'f'|'A'..'F') ;
//TRUE : 'true';
//FALSE : 'false';
bool 	:	TRUE | FALSE;
