grammar products2;
options {backtrack=true; output=AST; ASTLabelType=CommonTree; superClass=MetaDepthParserBase;}
tokens{DOC_INSTANCE;
LOAD = 'load';
TPRODUCTDEEP_NODE;
  TRUE  = 'true';
  FALSE  = 'false';
TPRODUCTSDEEP_NODE;
LBRACKET = '{';
RBRACKET = '}';
LPARENT = '(';
SYMBOL17 = '%';
RPARENT = ')';
SEMICOLON = ';';
COLON = ':';
LSQBRACKET = '[';
RSQBRACKET = ']';
POT = '@';
INTVL = '..';
INF = '*';
ASSIGNMENT = '=';
ACCESS = '::';
COMMA = ',';
  FIELD_VALUE;
  FIELD_VALUES;
  LIST_VALUE;
}
@parser::header{
/*******************************************************************************
 * MetaDepth parser for language: products2
 ******************************************************************************/
package serializers;
import meteoric.at3rdx.parse.MetaDepthParserBase;
}

@lexer::header{
/*******************************************************************************
 * MetaDepth parser for language: products2
 ******************************************************************************/
package serializers;
import meteoric.at3rdx.parse.MetaDepthParserBase;
}

@members{
public void emitErrorMessage ( String msg ) {}
public products2Parser () {}
}

document : declas* EOF -> ^(DOC_INSTANCE declas*);
declas : loadinst | main;
main :  idt=ID id=ID LBRACKET ( vTProductDeep+=rTProductDeep )* RBRACKET -> ^(TPRODUCTSDEEP_NODE $idt $id  $vTProductDeep*  );

rTProductDeep :  idt=ID id=ID LPARENT price=FLOAT RPARENT LBRACKET flinginsts RBRACKET -> ^(TPRODUCTDEEP_NODE $idt $id  $price   flinginsts );

loadinst :	        LOAD file=STRING -> ^(LOAD $file);
flinginsts : (at+=attrInst SEMICOLON)* -> ^(FIELD_VALUES $at*);
attrInst :	ID ASSIGNMENT literal    -> ^(FIELD_VALUE ID literal) |
           ID ASSIGNMENT listOfLits -> ^(FIELD_VALUE ID listOfLits);

listOfLits :  LSQBRACKET RSQBRACKET					-> ^(LIST_VALUE ) |
              LSQBRACKET (ival+=FLOAT|ival+=INT) (COMMA (ival+=FLOAT|ival+=INT))* RSQBRACKET 	-> ^(LIST_VALUE $ival+) |
              LSQBRACKET ival+=STRING (COMMA ival+=STRING)* RSQBRACKET-> ^(LIST_VALUE $ival+) |
              LSQBRACKET ival+=(TRUE|FALSE) (COMMA ival+=(TRUE|FALSE))* RSQBRACKET 	-> ^(LIST_VALUE $ival+) |
              LSQBRACKET ival+=ID (COMMA ival+=ID)* RSQBRACKET 	-> ^(LIST_VALUE $ival+);

literal :	INT | FLOAT | STRING | bool | ID;

ID  :	('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'0'..'9'|'_')*;
INT :	'0'..'9'+;
FLOAT:   ('0'..'9')+ '.' ('0'..'9')* EXPONENT? |   '.' ('0'..'9')+ EXPONENT? |   ('0'..'9')+ EXPONENT;
fragment EXPONENT : ('e'|'E') ('+'|'-')? ('0'..'9')+ ;
COMMENT :   '//' ~('\n'|'\r')* '\r'? '\n' {$channel=HIDDEN;}  |   '/*' ( options {greedy=false;} : . )* '*/' {$channel=HIDDEN;};
WS  :   ( ' ' | '\t' | '\r' | '\n') {$channel=HIDDEN;};
STRING :  '"' ( ESC_SEQ | ~('\\'|'"') )* '"';
CHAR:  '\'' ( ESC_SEQ | ~('\''|'\\') ) '\'';
fragment ESC_SEQ :   '\\' ('b'|'t'|'n'|'f'|'r'|'\"'|'\''|'\\') |   UNICODE_ESC |   OCTAL_ESC;
fragment OCTAL_ESC :   '\\' ('0'..'3') ('0'..'7') ('0'..'7') |   '\\' ('0'..'7') ('0'..'7') |   '\\' ('0'..'7');
fragment UNICODE_ESC :   '\\' 'u' HEX_DIGIT HEX_DIGIT HEX_DIGIT HEX_DIGIT;
fragment HEX_DIGIT : ('0'..'9'|'a'..'f'|'A'..'F') ;
//TRUE : 'true';
//FALSE : 'false';
bool 	:	TRUE | FALSE;
