lexer grammar products2;

@header {
/*******************************************************************************
 * MetaDepth parser for language: products2
 ******************************************************************************/
package serializers;
import meteoric.at3rdx.parse.MetaDepthParserBase;
}

LOAD : 'load' ;
TRUE : 'true' ;
FALSE : 'false' ;
LBRACKET : '{' ;
RBRACKET : '}' ;
LPARENT : '(' ;
SYMBOL17 : '%' ;
RPARENT : ')' ;
SEMICOLON : ';' ;
COLON : ':' ;
LSQBRACKET : '[' ;
RSQBRACKET : ']' ;
POT : '@' ;
INTVL : '..' ;
INF : '*' ;
ASSIGNMENT : '=' ;
ACCESS : '::' ;
COMMA : ',' ;

// $ANTLR src "src/serializers/products2.g" 68
ID  :	('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'0'..'9'|'_')*;
// $ANTLR src "src/serializers/products2.g" 69
INT :	'0'..'9'+;
// $ANTLR src "src/serializers/products2.g" 70
FLOAT:   ('0'..'9')+ '.' ('0'..'9')* EXPONENT? |   '.' ('0'..'9')+ EXPONENT? |   ('0'..'9')+ EXPONENT;
// $ANTLR src "src/serializers/products2.g" 71
fragment EXPONENT : ('e'|'E') ('+'|'-')? ('0'..'9')+ ;
// $ANTLR src "src/serializers/products2.g" 72
COMMENT :   '//' ~('\n'|'\r')* '\r'? '\n' {$channel=HIDDEN;}  |   '/*' ( options {greedy=false;} : . )* '*/' {$channel=HIDDEN;};
// $ANTLR src "src/serializers/products2.g" 73
WS  :   ( ' ' | '\t' | '\r' | '\n') {$channel=HIDDEN;};
// $ANTLR src "src/serializers/products2.g" 74
STRING :  '"' ( ESC_SEQ | ~('\\'|'"') )* '"';
// $ANTLR src "src/serializers/products2.g" 75
CHAR:  '\'' ( ESC_SEQ | ~('\''|'\\') ) '\'';
// $ANTLR src "src/serializers/products2.g" 76
fragment ESC_SEQ :   '\\' ('b'|'t'|'n'|'f'|'r'|'\"'|'\''|'\\') |   UNICODE_ESC |   OCTAL_ESC;
// $ANTLR src "src/serializers/products2.g" 77
fragment OCTAL_ESC :   '\\' ('0'..'3') ('0'..'7') ('0'..'7') |   '\\' ('0'..'7') ('0'..'7') |   '\\' ('0'..'7');
// $ANTLR src "src/serializers/products2.g" 78
fragment UNICODE_ESC :   '\\' 'u' HEX_DIGIT HEX_DIGIT HEX_DIGIT HEX_DIGIT;
// $ANTLR src "src/serializers/products2.g" 79
fragment HEX_DIGIT : ('0'..'9'|'a'..'f'|'A'..'F') ;
//TRUE : 'true';
//FALSE : 'false';
