lexer grammar products;

@header {
/*******************************************************************************
 * MetaDepth parser for language: products
 ******************************************************************************/
package serializers;
import meteoric.at3rdx.parse.MetaDepthParserBase;
}

LOAD : 'load' ;
TRUE : 'true' ;
FALSE : 'false' ;
LBRACKET : '{' ;
RBRACKET : '}' ;
LPARENT : '(' ;
SYMBOL17 : '%' ;
RPARENT : ')' ;
SEMICOLON : ';' ;
COLON : ':' ;
LSQBRACKET : '[' ;
RSQBRACKET : ']' ;
POT : '@' ;
INTVL : '..' ;
INF : '*' ;
ASSIGNMENT : '=' ;
ACCESS : '::' ;
COMMA : ',' ;
INTEGERT : 'int' ;
INTEGERTO : 'Integer' ;
DOUBLET : 'double' ;
BOOLEANT : 'boolean' ;
STRINGT : 'String' ;
ORDERED : 'ordered' ;
UNIQUE : 'unique' ;
READONLY : 'readOnly' ;
ISID : 'id' ;
NODE : 'Node' ;
EDGE : 'Edge' ;

// $ANTLR src "src/serializers/products.g" 118
ID  :	('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'0'..'9'|'_')*;
// $ANTLR src "src/serializers/products.g" 119
INT :	'0'..'9'+;
// $ANTLR src "src/serializers/products.g" 120
FLOAT:   ('0'..'9')+ '.' ('0'..'9')* EXPONENT? |   '.' ('0'..'9')+ EXPONENT? |   ('0'..'9')+ EXPONENT;
// $ANTLR src "src/serializers/products.g" 121
fragment EXPONENT : ('e'|'E') ('+'|'-')? ('0'..'9')+ ;
// $ANTLR src "src/serializers/products.g" 122
COMMENT :   '//' ~('\n'|'\r')* '\r'? '\n' {$channel=HIDDEN;}  |   '/*' ( options {greedy=false;} : . )* '*/' {$channel=HIDDEN;};
// $ANTLR src "src/serializers/products.g" 123
WS  :   ( ' ' | '\t' | '\r' | '\n') {$channel=HIDDEN;};
// $ANTLR src "src/serializers/products.g" 124
STRING :  '"' ( ESC_SEQ | ~('\\'|'"') )* '"';
// $ANTLR src "src/serializers/products.g" 125
CHAR:  '\'' ( ESC_SEQ | ~('\''|'\\') ) '\'';
// $ANTLR src "src/serializers/products.g" 126
fragment ESC_SEQ :   '\\' ('b'|'t'|'n'|'f'|'r'|'\"'|'\''|'\\') |   UNICODE_ESC |   OCTAL_ESC;
// $ANTLR src "src/serializers/products.g" 127
fragment OCTAL_ESC :   '\\' ('0'..'3') ('0'..'7') ('0'..'7') |   '\\' ('0'..'7') ('0'..'7') |   '\\' ('0'..'7');
// $ANTLR src "src/serializers/products.g" 128
fragment UNICODE_ESC :   '\\' 'u' HEX_DIGIT HEX_DIGIT HEX_DIGIT HEX_DIGIT;
// $ANTLR src "src/serializers/products.g" 129
fragment HEX_DIGIT : ('0'..'9'|'a'..'f'|'A'..'F') ;
//TRUE : 'true';
//FALSE : 'false';
