grammar templatedsyntax;
options {backtrack=true; output=AST; ASTLabelType=CommonTree; superClass=MetaDepthParserBase;}
tokens{DOC_INSTANCE;
LOAD = 'load';
IMPORTS_NODE;
MODEL = 'model';
TEMPLATEMODELTEMPLATE_NODE;
MODEL = 'model';
TEMPLATENODETEMPLATE_NODE;
TTEMPLATETOKEN_NODE;
TTEMPLATESYMBOL_NODE;
TTEMPLATETOKEN2_NODE;
TTEMPLATESYMBOL2_NODE;
  TRUE  = 'true';
  FALSE  = 'false';
SYNTAX = 'syntax';
FOR = 'for';
SYNTAX_NODE;
LSQBRACKET = '[';
RSQBRACKET = ']';
LBRACKET = '{';
RBRACKET = '}';
COMMA = ',';
POT = '@';
COLON = ':';
SEMICOLON = ';';
}
@parser::header{
/*******************************************************************************
 * MetaDepth parser for language: templatedsyntax
 ******************************************************************************/
package serializers;
import meteoric.at3rdx.parse.MetaDepthParserBase;
}

@lexer::header{
/*******************************************************************************
 * MetaDepth parser for language: templatedsyntax
 ******************************************************************************/
package serializers;
import meteoric.at3rdx.parse.MetaDepthParserBase;
}

@members{
public void emitErrorMessage ( String msg ) {}
public templatedsyntaxParser () {}
}

document : declas* EOF -> ^(DOC_INSTANCE declas*);
declas : loadinst | main;
main :  SYNTAX id=ID FOR imports LSQBRACKET fileExtension=STRING RSQBRACKET LBRACKET ( ( vTemplateModelTemplate+=rTemplateModelTemplate | vTemplateNodeTemplate+=rTemplateNodeTemplate ) )* RBRACKET -> ^(SYNTAX_NODE  $id  imports  $fileExtension   $vTemplateModelTemplate* $vTemplateNodeTemplate*   );

imports  :	k+=ID (COMMA k+=ID)* -> ^(IMPORTS_NODE $k+);
rTemplateModelTemplate :  MODEL id=ID POT potency=INT COLON ( ( vTTemplateToken+=rTTemplateToken | vTTemplateSymbol+=rTTemplateSymbol ) )* SEMICOLON -> ^(TEMPLATEMODELTEMPLATE_NODE  $id  $potency  $vTTemplateToken* $vTTemplateSymbol*   );

rTemplateNodeTemplate :  MODEL id=ID POT potency=INT COLON ( ( vTTemplateToken2+=rTTemplateToken2 | vTTemplateSymbol2+=rTTemplateSymbol2 ) )* SEMICOLON -> ^(TEMPLATENODETEMPLATE_NODE  $id  $potency  $vTTemplateToken2* $vTTemplateSymbol2*   );

rTTemplateToken :  value=STRING -> ^(TTEMPLATETOKEN_NODE $value);

rTTemplateSymbol :  name=STRING -> ^(TTEMPLATESYMBOL_NODE $name);

rTTemplateToken2 :  value=STRING -> ^(TTEMPLATETOKEN2_NODE $value);

rTTemplateSymbol2 :  name=STRING -> ^(TTEMPLATESYMBOL2_NODE $name);

loadinst :	        LOAD file=STRING -> ^(LOAD $file);
ID  :	('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'0'..'9'|'_')*;
INT :	'0'..'9'+;
FLOAT:   ('0'..'9')+ '.' ('0'..'9')* EXPONENT? |   '.' ('0'..'9')+ EXPONENT? |   ('0'..'9')+ EXPONENT;
fragment EXPONENT : ('e'|'E') ('+'|'-')? ('0'..'9')+ ;
COMMENT :   '//' ~('\n'|'\r')* '\r'? '\n' {$channel=HIDDEN;}  |   '/*' ( options {greedy=false;} : . )* '*/' {$channel=HIDDEN;};
WS  :   ( ' ' | '\t' | '\r' | '\n') {$channel=HIDDEN;};
STRING :  '"' ( ESC_SEQ | ~('\\'|'"') )* '"';
CHAR:  '\'' ( ESC_SEQ | ~('\''|'\\') ) '\'';
fragment ESC_SEQ :   '\\' ('b'|'t'|'n'|'f'|'r'|'\"'|'\''|'\\') |   UNICODE_ESC |   OCTAL_ESC;
fragment OCTAL_ESC :   '\\' ('0'..'3') ('0'..'7') ('0'..'7') |   '\\' ('0'..'7') ('0'..'7') |   '\\' ('0'..'7');
fragment UNICODE_ESC :   '\\' 'u' HEX_DIGIT HEX_DIGIT HEX_DIGIT HEX_DIGIT;
fragment HEX_DIGIT : ('0'..'9'|'a'..'f'|'A'..'F') ;
//TRUE : 'true';
//FALSE : 'false';
bool 	:	TRUE | FALSE;
