lexer grammar templatedsyntax;

@header {
/*******************************************************************************
 * MetaDepth parser for language: templatedsyntax
 ******************************************************************************/
package serializers;
import meteoric.at3rdx.parse.MetaDepthParserBase;
}

LOAD : 'load' ;
MODEL : 'model' ;
TRUE : 'true' ;
FALSE : 'false' ;
SYNTAX : 'syntax' ;
FOR : 'for' ;
LSQBRACKET : '[' ;
RSQBRACKET : ']' ;
LBRACKET : '{' ;
RBRACKET : '}' ;
COMMA : ',' ;
POT : '@' ;
COLON : ':' ;
SEMICOLON : ';' ;

// $ANTLR src "src/serializers/templatedsyntax.g" 67
ID  :	('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'0'..'9'|'_')*;
// $ANTLR src "src/serializers/templatedsyntax.g" 68
INT :	'0'..'9'+;
// $ANTLR src "src/serializers/templatedsyntax.g" 69
FLOAT:   ('0'..'9')+ '.' ('0'..'9')* EXPONENT? |   '.' ('0'..'9')+ EXPONENT? |   ('0'..'9')+ EXPONENT;
// $ANTLR src "src/serializers/templatedsyntax.g" 70
fragment EXPONENT : ('e'|'E') ('+'|'-')? ('0'..'9')+ ;
// $ANTLR src "src/serializers/templatedsyntax.g" 71
COMMENT :   '//' ~('\n'|'\r')* '\r'? '\n' {$channel=HIDDEN;}  |   '/*' ( options {greedy=false;} : . )* '*/' {$channel=HIDDEN;};
// $ANTLR src "src/serializers/templatedsyntax.g" 72
WS  :   ( ' ' | '\t' | '\r' | '\n') {$channel=HIDDEN;};
// $ANTLR src "src/serializers/templatedsyntax.g" 73
STRING :  '"' ( ESC_SEQ | ~('\\'|'"') )* '"';
// $ANTLR src "src/serializers/templatedsyntax.g" 74
CHAR:  '\'' ( ESC_SEQ | ~('\''|'\\') ) '\'';
// $ANTLR src "src/serializers/templatedsyntax.g" 75
fragment ESC_SEQ :   '\\' ('b'|'t'|'n'|'f'|'r'|'\"'|'\''|'\\') |   UNICODE_ESC |   OCTAL_ESC;
// $ANTLR src "src/serializers/templatedsyntax.g" 76
fragment OCTAL_ESC :   '\\' ('0'..'3') ('0'..'7') ('0'..'7') |   '\\' ('0'..'7') ('0'..'7') |   '\\' ('0'..'7');
// $ANTLR src "src/serializers/templatedsyntax.g" 77
fragment UNICODE_ESC :   '\\' 'u' HEX_DIGIT HEX_DIGIT HEX_DIGIT HEX_DIGIT;
// $ANTLR src "src/serializers/templatedsyntax.g" 78
fragment HEX_DIGIT : ('0'..'9'|'a'..'f'|'A'..'F') ;
//TRUE : 'true';
//FALSE : 'false';
