factory_mm = """
    ## Classes ##
    WorkStation:Class {
        abstract = True;
    }
   Production:Class {
    abstract = True;
   }
   :Inheritance (Production -> WorkStation)
   Assembly:Class
   :Inheritance (Assembly -> Production)
   Inspection:Class
   :Inheritance (Inspection -> Production)
   
   Storage:Class
   :Inheritance (Storage -> WorkStation)
   ProduceA:Class
   :Inheritance (ProduceA -> Storage)
   ProduceB:Class
   :Inheritance (ProduceB -> Storage)
   StoreAccept:Class
   :Inheritance (StoreAccept -> Storage)
   StoreReject:Class
   :Inheritance (StoreReject -> Storage)
   
   Queue:Class
   
   Worker:Class
   
   Item:Class {
    abstract = True;
   }
   PartA:Class
   :Inheritance (PartA -> Item)
   PartB:Class
   :Inheritance (PartB -> Item)
   Product:Class
   :Inheritance (Product -> Item)
   
   ## Attributes ##
    Queue_capacity:AttributeLink (Queue -> Integer) {
        name = "capacity";
        optional = False;
    }
    
    ## Associations ##
    queueIn:Association (Queue -> WorkStation) {
        target_lower_cardinality = 1;
    }
    
    queueOut:Association (Queue -> WorkStation) {
        target_lower_cardinality = 1;
    }
"""

factory_rt_mm = factory_mm + """
    ## Classes ##
    State:Class
    State_processing:AttributeLink (State -> String) {
        name = "processing";
        optional = False;
        # constraint = `get_value(this) in ("processed", "processing", "ready")`;
    }
    
    ## Associations ##
    workingOn:Association (Worker -> Production) {
        target_upper_cardinality = 1;
        source_upper_cardinality = 1;
    }
    
    inQueue:Association (Item -> Queue)
    underInspection:Association (Item -> Inspection)
    stored:Association (Item -> Storage)
    
    stateOf:Association (Production -> State) {
        target_upper_cardinality = 1;
        source_upper_cardinality = 1;
        source_lower_cardinality = 1;
        target_lower_cardinality = 1;
    }
"""

small_factory_m = """
    ## Instances ##
    assemblyStation:Assembly
    inspectionStation:Inspection
    
    storeA:ProduceA
    storeB:ProduceB
    rejectSink:StoreReject
    acceptSink:StoreAccept
    
    inA:Queue {
        capacity = 5;
    }
    inB:Queue {
        capacity = 5;
    }
    toInspection:Queue {
        capacity = 3;
    }
    accept:Queue {
        capacity = 5;
    }
    reject:Queue {
        capacity = 5;
    }
    
    theWorker:Worker
    
    ## Associations ##
    storeAOut:queueOut (inA -> storeA)
    storeBOut:queueOut (inB -> storeB)
    
    assemblyAIn:queueIn (inA -> assemblyStation)
    assemblyBIn:queueIn (inB -> assemblyStation)
    assemblyOut:queueOut (toInspection -> assemblyStation)
    
    inspectionIn:queueIn (toInspection -> inspectionStation)
    acceptOut:queueOut (accept -> inspectionStation)
    rejectOut:queueOut (reject -> inspectionStation)
    
    acceptIn:queueIn (accept -> acceptSink)
    rejectIn:queueIn (reject -> rejectSink)
"""

small_factory_rt_m = small_factory_m + """
    assemblyState:State {
        processing = "ready";
    }
    :stateOf (assemblyStation -> assemblyState)
    inspectionState:State {
        processing = "ready";
    }
    :stateOf (inspectionStation -> inspectionState)
"""