
from ..util.infinity import INFINITY
from ..tcore.composer import Composer
from brule import BRule


class BSRule(Composer):
    '''
        Applies the transformation recursively until no branch can match anymore.
    '''
    def __init__(self, branches, max_iterations=INFINITY):
        '''
            Selects a successful matcher.
            @param branches: A list of ARules.
            @param max_iterations: The maximum number of times to apply the transformation.
        '''
        super(BSRule, self).__init__()
        self.brule = BRule(branches)
        self.max_iterations = max_iterations
        self.iterations = 1
    
    def packet_in(self, packet):
        self.exception = None
        self.is_success = False
        # Apply the BRule
        packet = self.brule.packet_in(packet)
        if not self.brule.is_success:
            self.exception = self.brule.exception
            return packet
        else:
            # Rule has been applied once, so it's a success anyway
            self.is_success = True
            while self.iterations < self.max_iterations:
                # Re-apply the BRule
                packet = self.brule.packet_in(packet)
                if not self.brule.is_success:
                    self.exception = self.brule.exception
                    return packet
                self.iterations += 1
            return packet
