/* Main Simulation File */
#include "MassSpringDamper1_model.h"


/* dummy VARINFO and FILEINFO */
const FILE_INFO dummyFILE_INFO = omc_dummyFileInfo;
const VAR_INFO dummyVAR_INFO = omc_dummyVarInfo;
#if defined(__cplusplus)
extern "C" {
#endif

int MassSpringDamper1_input_function(DATA *data, threadData_t *threadData)
{
  TRACE_PUSH

  data->localData[0]->realVars[4] /* fk variable */ = data->simulationInfo->inputVars[0];
  
  TRACE_POP
  return 0;
}

int MassSpringDamper1_input_function_init(DATA *data, threadData_t *threadData)
{
  TRACE_PUSH

  data->simulationInfo->inputVars[0] = data->modelData->realVarsData[4].attribute.start;
  
  TRACE_POP
  return 0;
}

int MassSpringDamper1_input_function_updateStartValues(DATA *data, threadData_t *threadData)
{
  TRACE_PUSH

  data->modelData->realVarsData[4].attribute.start = data->simulationInfo->inputVars[0];
  
  TRACE_POP
  return 0;
}

int MassSpringDamper1_inputNames(DATA *data, char ** names){
  TRACE_PUSH

  names[0] = (char *) data->modelData->realVarsData[4].info.name;
  
  TRACE_POP
  return 0;
}

int MassSpringDamper1_output_function(DATA *data, threadData_t *threadData)
{
  TRACE_PUSH

  data->simulationInfo->outputVars[0] = data->localData[0]->realVars[0] /* v1 STATE(1) */;
  data->simulationInfo->outputVars[1] = data->localData[0]->realVars[1] /* x1 STATE(1,v1) */;
  
  TRACE_POP
  return 0;
}


/*
 equation index: 5
 type: SIMPLE_ASSIGN
 der(v1) = DIVISION(fk + (-d1) * v1 - c1 * x1, m1)
 */
void MassSpringDamper1_eqFunction_5(DATA *data, threadData_t *threadData)
{
  TRACE_PUSH
  const int equationIndexes[2] = {1,5};
  data->localData[0]->realVars[2] /* der(v1) STATE_DER */ = DIVISION_SIM(data->localData[0]->realVars[4] /* fk variable */ + ((-data->simulationInfo->realParameter[1])) * (data->localData[0]->realVars[0] /* v1 STATE(1) */) - ((data->simulationInfo->realParameter[0]) * (data->localData[0]->realVars[1] /* x1 STATE(1,v1) */)),data->simulationInfo->realParameter[2],"m1",equationIndexes);
  TRACE_POP
}
/*
 equation index: 6
 type: SIMPLE_ASSIGN
 der(x1) = v1
 */
void MassSpringDamper1_eqFunction_6(DATA *data, threadData_t *threadData)
{
  TRACE_PUSH
  const int equationIndexes[2] = {1,6};
  data->localData[0]->realVars[3] /* der(x1) STATE_DER */ = data->localData[0]->realVars[0] /* v1 STATE(1) */;
  TRACE_POP
}


int MassSpringDamper1_functionDAE(DATA *data, threadData_t *threadData)
{
  TRACE_PUSH
  int equationIndexes[1] = {0};
  
  data->simulationInfo->needToIterate = 0;
  data->simulationInfo->discreteCall = 1;
  MassSpringDamper1_functionLocalKnownVars(data, threadData);
  MassSpringDamper1_eqFunction_5(data, threadData);

  MassSpringDamper1_eqFunction_6(data, threadData);
  data->simulationInfo->discreteCall = 0;
  
  TRACE_POP
  return 0;
}


int MassSpringDamper1_functionLocalKnownVars(DATA *data, threadData_t *threadData)
{
  TRACE_PUSH

  
  TRACE_POP
  return 0;
}


/* forwarded equations */
extern void MassSpringDamper1_eqFunction_5(DATA* data, threadData_t *threadData);
extern void MassSpringDamper1_eqFunction_6(DATA* data, threadData_t *threadData);

static void functionODE_system0(DATA *data, threadData_t *threadData)
{
  MassSpringDamper1_eqFunction_5(data, threadData);

  MassSpringDamper1_eqFunction_6(data, threadData);
}

int MassSpringDamper1_functionODE(DATA *data, threadData_t *threadData)
{
  TRACE_PUSH

  
  data->simulationInfo->callStatistics.functionODE++;
  
  MassSpringDamper1_functionLocalKnownVars(data, threadData);
  functionODE_system0(data, threadData);

  
  TRACE_POP
  return 0;
}

#ifdef FMU_EXPERIMENTAL
#endif
/* forward the main in the simulation runtime */
extern int _main_SimulationRuntime(int argc, char**argv, DATA *data, threadData_t *threadData);

#include "MassSpringDamper1_12jac.h"
#include "MassSpringDamper1_13opt.h"

struct OpenModelicaGeneratedFunctionCallbacks MassSpringDamper1_callback = {
   NULL,
   NULL,
   NULL,
   MassSpringDamper1_callExternalObjectDestructors,
   NULL,
   NULL,
   NULL,
   #if !defined(OMC_NO_STATESELECTION)
   MassSpringDamper1_initializeStateSets,
   #else
   NULL,
   #endif
   MassSpringDamper1_initializeDAEmodeData,
   MassSpringDamper1_functionODE,
   MassSpringDamper1_functionAlgebraics,
   MassSpringDamper1_functionDAE,
   MassSpringDamper1_functionLocalKnownVars,
   MassSpringDamper1_input_function,
   MassSpringDamper1_input_function_init,
   MassSpringDamper1_input_function_updateStartValues,
   MassSpringDamper1_output_function,
   MassSpringDamper1_function_storeDelayed,
   MassSpringDamper1_updateBoundVariableAttributes,
   MassSpringDamper1_functionInitialEquations,
   0, /* useHomotopy - 0: no homotopy or local homotopy, 1: global homotopy, 2: new global homotopy approach */
   MassSpringDamper1_functionInitialEquations_lambda0,
   MassSpringDamper1_functionRemovedInitialEquations,
   MassSpringDamper1_updateBoundParameters,
   MassSpringDamper1_checkForAsserts,
   MassSpringDamper1_function_ZeroCrossingsEquations,
   MassSpringDamper1_function_ZeroCrossings,
   MassSpringDamper1_function_updateRelations,
   MassSpringDamper1_checkForDiscreteChanges,
   MassSpringDamper1_zeroCrossingDescription,
   MassSpringDamper1_relationDescription,
   MassSpringDamper1_function_initSample,
   MassSpringDamper1_INDEX_JAC_A,
   MassSpringDamper1_INDEX_JAC_B,
   MassSpringDamper1_INDEX_JAC_C,
   MassSpringDamper1_INDEX_JAC_D,
   MassSpringDamper1_initialAnalyticJacobianA,
   MassSpringDamper1_initialAnalyticJacobianB,
   MassSpringDamper1_initialAnalyticJacobianC,
   MassSpringDamper1_initialAnalyticJacobianD,
   MassSpringDamper1_functionJacA_column,
   MassSpringDamper1_functionJacB_column,
   MassSpringDamper1_functionJacC_column,
   MassSpringDamper1_functionJacD_column,
   MassSpringDamper1_linear_model_frame,
   MassSpringDamper1_linear_model_datarecovery_frame,
   MassSpringDamper1_mayer,
   MassSpringDamper1_lagrange,
   MassSpringDamper1_pickUpBoundsForInputsInOptimization,
   MassSpringDamper1_setInputData,
   MassSpringDamper1_getTimeGrid,
   MassSpringDamper1_symbolicInlineSystem,
   MassSpringDamper1_function_initSynchronous,
   MassSpringDamper1_function_updateSynchronous,
   MassSpringDamper1_function_equationsSynchronous,
   MassSpringDamper1_read_input_fmu,
   #ifdef FMU_EXPERIMENTAL
   MassSpringDamper1_functionODE_Partial,
   MassSpringDamper1_functionFMIJacobian,
   #endif
   MassSpringDamper1_inputNames
};

void MassSpringDamper1_setupDataStruc(DATA *data, threadData_t *threadData)
{
  assertStreamPrint(threadData,0!=data, "Error while initialize Data");
  data->callback = &MassSpringDamper1_callback;
  data->modelData->modelName = "MassSpringDamper1";
  data->modelData->modelFilePrefix = "MassSpringDamper1";
  data->modelData->resultFileName = NULL;
  data->modelData->modelDir = "C:/srcctrl/2019.WinterSim.CosimTutorialMaterials/fmus/models";
  data->modelData->modelGUID = "{ba983824-a6c5-471e-a8b7-db59c2e3a0fa}";
  data->modelData->initXMLData = NULL;
  data->modelData->modelDataXml.infoXMLData =
  #if defined(OMC_MINIMAL_METADATA)
    NULL;
  #else
  #include "MassSpringDamper1_info.c"
  #endif
  ;
  
  data->modelData->nStates = 2;
  data->modelData->nVariablesReal = 5;
  data->modelData->nDiscreteReal = 0;
  data->modelData->nVariablesInteger = 0;
  data->modelData->nVariablesBoolean = 0;
  data->modelData->nVariablesString = 0;
  data->modelData->nParametersReal = 3;
  data->modelData->nParametersInteger = 0;
  data->modelData->nParametersBoolean = 0;
  data->modelData->nParametersString = 0;
  data->modelData->nInputVars = 1;
  data->modelData->nOutputVars = 2;
  
  data->modelData->nAliasReal = 0;
  data->modelData->nAliasInteger = 0;
  data->modelData->nAliasBoolean = 0;
  data->modelData->nAliasString = 0;
  
  data->modelData->nZeroCrossings = 0;
  data->modelData->nSamples = 0;
  data->modelData->nRelations = 0;
  data->modelData->nMathEvents = 0;
  data->modelData->nExtObjs = 0;
  data->modelData->modelDataXml.fileName = "MassSpringDamper1_info.json";
  data->modelData->modelDataXml.modelInfoXmlLength = 0;
  data->modelData->modelDataXml.nFunctions = 0;
  data->modelData->modelDataXml.nProfileBlocks = 0;
  data->modelData->modelDataXml.nEquations = 7;
  data->modelData->nMixedSystems = 0;
  data->modelData->nLinearSystems = 0;
  data->modelData->nNonLinearSystems = 0;
  data->modelData->nStateSets = 0;
  data->modelData->nJacobians = 4;
  data->modelData->nOptimizeConstraints = 0;
  data->modelData->nOptimizeFinalConstraints = 0;
  
  data->modelData->nDelayExpressions = 0;
  
  data->modelData->nClocks = 0;
  data->modelData->nSubClocks = 0;
  
  data->modelData->nSensitivityVars = 0;
  data->modelData->nSensitivityParamVars = 0;
}

#ifdef __cplusplus
}
#endif

static int rml_execution_failed()
{
  fflush(NULL);
  fprintf(stderr, "Execution failed!\n");
  fflush(NULL);
  return 1;
}

