/* Initialization */
#include "MassSpringDamper1_model.h"
#include "MassSpringDamper1_11mix.h"
#include "MassSpringDamper1_12jac.h"
#if defined(__cplusplus)
extern "C" {
#endif

void MassSpringDamper1_functionInitialEquations_0(DATA *data, threadData_t *threadData);


/*
 equation index: 1
 type: SIMPLE_ASSIGN
 v1 = $START.v1
 */
void MassSpringDamper1_eqFunction_1(DATA *data, threadData_t *threadData)
{
  TRACE_PUSH
  const int equationIndexes[2] = {1,1};
  data->localData[0]->realVars[0] /* v1 STATE(1) */ = data->modelData->realVarsData[0].attribute /* v1 STATE(1) */.start;
  TRACE_POP
}

/*
 equation index: 2
 type: SIMPLE_ASSIGN
 x1 = $START.x1
 */
void MassSpringDamper1_eqFunction_2(DATA *data, threadData_t *threadData)
{
  TRACE_PUSH
  const int equationIndexes[2] = {1,2};
  data->localData[0]->realVars[1] /* x1 STATE(1,v1) */ = data->modelData->realVarsData[1].attribute /* x1 STATE(1,v1) */.start;
  TRACE_POP
}

/*
 equation index: 3
 type: SIMPLE_ASSIGN
 der(x1) = v1
 */
void MassSpringDamper1_eqFunction_3(DATA *data, threadData_t *threadData)
{
  TRACE_PUSH
  const int equationIndexes[2] = {1,3};
  data->localData[0]->realVars[3] /* der(x1) STATE_DER */ = data->localData[0]->realVars[0] /* v1 STATE(1) */;
  TRACE_POP
}

/*
 equation index: 4
 type: SIMPLE_ASSIGN
 der(v1) = DIVISION(fk + (-d1) * v1 - c1 * x1, m1)
 */
void MassSpringDamper1_eqFunction_4(DATA *data, threadData_t *threadData)
{
  TRACE_PUSH
  const int equationIndexes[2] = {1,4};
  data->localData[0]->realVars[2] /* der(v1) STATE_DER */ = DIVISION_SIM(data->localData[0]->realVars[4] /* fk variable */ + ((-data->simulationInfo->realParameter[1])) * (data->localData[0]->realVars[0] /* v1 STATE(1) */) - ((data->simulationInfo->realParameter[0]) * (data->localData[0]->realVars[1] /* x1 STATE(1,v1) */)),data->simulationInfo->realParameter[2],"m1",equationIndexes);
  TRACE_POP
}
void MassSpringDamper1_functionInitialEquations_0(DATA *data, threadData_t *threadData)
{
  TRACE_PUSH
  MassSpringDamper1_eqFunction_1(data, threadData);
  MassSpringDamper1_eqFunction_2(data, threadData);
  MassSpringDamper1_eqFunction_3(data, threadData);
  MassSpringDamper1_eqFunction_4(data, threadData);
  TRACE_POP
}


int MassSpringDamper1_functionInitialEquations(DATA *data, threadData_t *threadData)
{
  TRACE_PUSH

  data->simulationInfo->discreteCall = 1;
  MassSpringDamper1_functionInitialEquations_0(data, threadData);
  data->simulationInfo->discreteCall = 0;
  
  TRACE_POP
  return 0;
}


int MassSpringDamper1_functionInitialEquations_lambda0(DATA *data, threadData_t *threadData)
{
  TRACE_PUSH

  data->simulationInfo->discreteCall = 1;
  data->simulationInfo->discreteCall = 0;
  
  TRACE_POP
  return 0;
}
int MassSpringDamper1_functionRemovedInitialEquations(DATA *data, threadData_t *threadData)
{
  TRACE_PUSH
  const int *equationIndexes = NULL;
  double res = 0.0;

  
  TRACE_POP
  return 0;
}


#if defined(__cplusplus)
}
#endif

