/* Linearization */
#include "MassSpringDamper1_model.h"
#if defined(__cplusplus)
extern "C" {
#endif

const char *MassSpringDamper1_linear_model_frame()
{
  return "model linear_MassSpringDamper1\n  parameter Integer n = 2; // states\n  parameter Integer k = 1; // top-level inputs\n  parameter Integer l = 2; // top-level outputs\n"
  "  parameter Real x0[2] = {%s};\n"
  "  parameter Real u0[1] = {%s};\n"
  "  parameter Real A[2,2] = [%s];\n"
  "  parameter Real B[2,1] = [%s];\n"
  "  parameter Real C[2,2] = [%s];\n"
  "  parameter Real D[2,1] = [%s];\n"
  "  Real x[2](start=x0);\n"
  "  input Real u[1](start= u0);\n"
  "  output Real y[2];\n"
  "\n    Real 'x_v1' = x[1];\n  Real 'x_x1' = x[2];\n  Real 'u_fk' = u[1];\n  Real 'y_v1' = y[1];\n  Real 'y_x1' = y[2];\n\n"
  "equation\n  der(x) = A * x + B * u;\n  y = C * x + D * u;\nend linear_MassSpringDamper1;\n";
}
const char *MassSpringDamper1_linear_model_datarecovery_frame()
{
  return "model linear_MassSpringDamper1\n  parameter Integer n = 2; // states\n  parameter Integer k = 1; // top-level inputs\n  parameter Integer l = 2; // top-level outputs\n  parameter Integer nz = 1; // data recovery variables\n"
  "  parameter Real x0[2] = {%s};\n"
  "  parameter Real u0[1] = {%s};\n"
  "  parameter Real z0[1] = {%s};\n"
  "  parameter Real A[2,2] = [%s];\n"
  "  parameter Real B[2,1] = [%s];\n"
  "  parameter Real C[2,2] = [%s];\n"
  "  parameter Real D[2,1] = [%s];\n"
  "  parameter Real Cz[1,2] = [%s];\n"
  "  parameter Real Dz[1,1] = [%s];\n"
  "  Real x[2](start=x0);\n"
  "  input Real u[1](start= u0);\n"
  "  output Real y[2];\n"
  "  output Real z[1];\n"
  "\n  Real 'x_v1' = x[1];\n  Real 'x_x1' = x[2];\n  Real 'u_fk' = u[1];\n  Real 'y_v1' = y[1];\n  Real 'y_x1' = y[2];\n  Real 'z_fk' = z[1];\n\n"
  "equation\n  der(x) = A * x + B * u;\n  y = C * x + D * u;\n  z = Cz * x + Dz * u;\nend linear_MassSpringDamper1;\n";
}
#if defined(__cplusplus)
}
#endif

