// define class name and unique id
#define MODEL_IDENTIFIER MassSpringDamper1
#define MODEL_GUID "{ba983824-a6c5-471e-a8b7-db59c2e3a0fa}"

// include fmu header files, typedefs and macros
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "openmodelica.h"
#include "openmodelica_func.h"
#include "simulation_data.h"
#include "util/omc_error.h"
#include "MassSpringDamper1_functions.h"
#include "simulation/solver/initialization/initialization.h"
#include "simulation/solver/events.h"
#include "fmu2_model_interface.h"

#ifdef __cplusplus
extern "C" {
#endif

void setStartValues(ModelInstance *comp);
void setDefaultStartValues(ModelInstance *comp);
void eventUpdate(ModelInstance* comp, fmi2EventInfo* eventInfo);
fmi2Real getReal(ModelInstance* comp, const fmi2ValueReference vr);
fmi2Status setReal(ModelInstance* comp, const fmi2ValueReference vr, const fmi2Real value);
fmi2Integer getInteger(ModelInstance* comp, const fmi2ValueReference vr);
fmi2Status setInteger(ModelInstance* comp, const fmi2ValueReference vr, const fmi2Integer value);
fmi2Boolean getBoolean(ModelInstance* comp, const fmi2ValueReference vr);
fmi2Status setBoolean(ModelInstance* comp, const fmi2ValueReference vr, const fmi2Boolean value);
fmi2String getString(ModelInstance* comp, const fmi2ValueReference vr);
fmi2Status setString(ModelInstance* comp, const fmi2ValueReference vr, fmi2String value);
fmi2Status setExternalFunction(ModelInstance* c, const fmi2ValueReference vr, const void* value);

// define model size
#define NUMBER_OF_STATES 2
#define NUMBER_OF_EVENT_INDICATORS 0
#define NUMBER_OF_REALS 8
#define NUMBER_OF_INTEGERS 0
#define NUMBER_OF_STRINGS 0
#define NUMBER_OF_BOOLEANS 0
#define NUMBER_OF_EXTERNALFUNCTIONS 0

// define variable data for model
#define $Pv1_vr 0 
#define $Px1_vr 1 
#define $P$DER$Pv1_vr 2 
#define $P$DER$Px1_vr 3 
#define $Pfk_vr 4 
#define $Pc1_vr 5 
#define $Pd1_vr 6 
#define $Pm1_vr 7 


// define initial state vector as vector of value references
#define STATES { $Pv1_vr, $Px1_vr }
#define STATESDERIVATIVES { $P$DER$Pv1_vr, $P$DER$Px1_vr }


// implementation of the Model Exchange functions
extern void MassSpringDamper1_setupDataStruc(DATA *data);
#define fmu2_model_interface_setupDataStruc MassSpringDamper1_setupDataStruc
#include "fmu2_model_interface.c"

// Set values for all variables that define a start value
void setDefaultStartValues(ModelInstance *comp) {
  comp->fmuData->modelData->realVarsData[0].attribute.start = 0.0;
  comp->fmuData->modelData->realVarsData[1].attribute.start = 1.0;
  comp->fmuData->modelData->realVarsData[2].attribute.start = 0;
  comp->fmuData->modelData->realVarsData[3].attribute.start = 0;
  comp->fmuData->modelData->realVarsData[4].attribute.start = 0;
  comp->fmuData->modelData->realParameterData[0].attribute.start = 5.0;
  comp->fmuData->modelData->realParameterData[1].attribute.start = 1.0;
  comp->fmuData->modelData->realParameterData[2].attribute.start = 1.0;
}
// Set values for all variables that define a start value
void setStartValues(ModelInstance *comp) {
  comp->fmuData->modelData->realVarsData[0].attribute.start =  comp->fmuData->localData[0]->realVars[0];
  comp->fmuData->modelData->realVarsData[1].attribute.start =  comp->fmuData->localData[0]->realVars[1];
  comp->fmuData->modelData->realVarsData[2].attribute.start =  comp->fmuData->localData[0]->realVars[2];
  comp->fmuData->modelData->realVarsData[3].attribute.start =  comp->fmuData->localData[0]->realVars[3];
  comp->fmuData->modelData->realVarsData[4].attribute.start =  comp->fmuData->localData[0]->realVars[4];
  comp->fmuData->modelData->realParameterData[0].attribute.start = comp->fmuData->simulationInfo->realParameter[0];
  comp->fmuData->modelData->realParameterData[1].attribute.start = comp->fmuData->simulationInfo->realParameter[1];
  comp->fmuData->modelData->realParameterData[2].attribute.start = comp->fmuData->simulationInfo->realParameter[2];
}

// Used to set the next time event, if any.
void eventUpdate(ModelInstance* comp, fmi2EventInfo* eventInfo) {
}

fmi2Real getReal(ModelInstance* comp, const fmi2ValueReference vr) {
  switch (vr) {
    case $Pv1_vr : return comp->fmuData->localData[0]->realVars[0]; break;
    case $Px1_vr : return comp->fmuData->localData[0]->realVars[1]; break;
    case $P$DER$Pv1_vr : return comp->fmuData->localData[0]->realVars[2]; break;
    case $P$DER$Px1_vr : return comp->fmuData->localData[0]->realVars[3]; break;
    case $Pfk_vr : return comp->fmuData->localData[0]->realVars[4]; break;
    case $Pc1_vr : return comp->fmuData->simulationInfo->realParameter[0]; break;
    case $Pd1_vr : return comp->fmuData->simulationInfo->realParameter[1]; break;
    case $Pm1_vr : return comp->fmuData->simulationInfo->realParameter[2]; break;
    default:
      return 0;
  }
}

fmi2Status setReal(ModelInstance* comp, const fmi2ValueReference vr, const fmi2Real value) {
  switch (vr) {
    case $Pv1_vr : comp->fmuData->localData[0]->realVars[0] = value; break;
    case $Px1_vr : comp->fmuData->localData[0]->realVars[1] = value; break;
    case $P$DER$Pv1_vr : comp->fmuData->localData[0]->realVars[2] = value; break;
    case $P$DER$Px1_vr : comp->fmuData->localData[0]->realVars[3] = value; break;
    case $Pfk_vr : comp->fmuData->localData[0]->realVars[4] = value; break;
    case $Pc1_vr : comp->fmuData->simulationInfo->realParameter[0] = value; break;
    case $Pd1_vr : comp->fmuData->simulationInfo->realParameter[1] = value; break;
    case $Pm1_vr : comp->fmuData->simulationInfo->realParameter[2] = value; break;
    default:
      return fmi2Error;
  }
  return fmi2OK;
}

fmi2Integer getInteger(ModelInstance* comp, const fmi2ValueReference vr) {
  switch (vr) {
    default:
      return 0;
  }
}
fmi2Status setInteger(ModelInstance* comp, const fmi2ValueReference vr, const fmi2Integer value) {
  switch (vr) {
    default:
      return fmi2Error;
  }
  return fmi2OK;
}
fmi2Boolean getBoolean(ModelInstance* comp, const fmi2ValueReference vr) {
  switch (vr) {
    default:
      return fmi2False;
  }
}

fmi2Status setBoolean(ModelInstance* comp, const fmi2ValueReference vr, const fmi2Boolean value) {
  switch (vr) {
    default:
      return fmi2Error;
  }
  return fmi2OK;
}

fmi2String getString(ModelInstance* comp, const fmi2ValueReference vr) {
  switch (vr) {
    default:
      return "";
  }
}

fmi2Status setString(ModelInstance* comp, const fmi2ValueReference vr, fmi2String value) {
  switch (vr) {
    default:
      return fmi2Error;
  }
  return fmi2OK;
}

fmi2Status setExternalFunction(ModelInstance* c, const fmi2ValueReference vr, const void* value){
  switch (vr) {
    default:
      return fmi2Error;
  }
  return fmi2OK;
}


#ifdef __cplusplus
}
#endif

