# Copyright 2014 Modelling, Simulation and Design Lab (MSDL) at
# McGill University and the University of Antwerp (http://msdl.cs.mcgill.ca/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Decorator functions to convert Classic DEVS models to Parallel DEVS models.
Note that these are simplistic transformations and not at all efficient nor smart.
"""

def _dec_output(func):
	def inner(self):
		res = func(self)
		for p, v in res.items():
			res[p] = [v]
		return res
	return inner


def _dec_external(func):
	def inner(self, inputs):
		for p, v in inputs.items():
			for el in v:
				res = func(self, {p: el})
		return res
	return inner


def classic2parallel(cls):
	cls.outputFnc = _dec_output(cls.outputFnc)
	cls.extTransition = _dec_external(cls.extTransition)
	return cls